/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir;

import de.quippy.javamod.mixer.dsp.iir.GraphicEQ;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicEqGUI
extends JPanel {
    private static final long serialVersionUID = 8091057988399658762L;
    private static final int SHIFT_DB = 100;
    private static final int SLIDER_MAX = 2000;
    private static final int SLIDER_MIN = -2000;
    private static final String DEZIBEL = "db";
    private GraphicEQ eq;
    private JPanel selectionPanel = null;
    private JPanel bandsPanel = null;
    private JPanel preAmpPanel = null;
    private JSlider[] sliders = null;
    private JLabel[] slidersLable = null;
    private JSlider preAmpSlider = null;
    private JLabel preAmpSliderLable = null;
    private JLabel minLabel = null;
    private JLabel centerLabel = null;
    private JLabel maxLabel = null;
    private JCheckBox equalizerActive = null;
    private JLabel presetSelectionLabel = null;
    private JComboBox presetSelection = null;
    private boolean presetsActive;
    private static final String[] PRESET_NAMES = new String[]{"Select a preset...", "Flat", "Classical", "Club", "Cristal", "Dance", "Full bass", "Full bass & treble", "Full treble", "Laptop", "Live", "Party", "Pop", "Reggae", "Rock", "Techno"};
    private static final int[][] PRESET_DB;

    static {
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[10];
        nArrayArray[1] = new int[10];
        int[] nArray = new int[10];
        nArray[6] = -8;
        nArray[7] = -8;
        nArray[8] = -8;
        nArray[9] = -10;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[10];
        nArray2[2] = 4;
        nArray2[3] = 7;
        nArray2[4] = 7;
        nArray2[5] = 7;
        nArray2[6] = 4;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[0] = 20;
        nArray3[1] = 15;
        nArray3[2] = 10;
        nArray3[3] = 5;
        nArray3[6] = 5;
        nArray3[7] = 10;
        nArray3[8] = 15;
        nArray3[9] = 20;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[0] = 10;
        nArray4[1] = 7;
        nArray4[2] = 2;
        nArray4[5] = -6;
        nArray4[6] = -8;
        nArray4[7] = -8;
        nArrayArray[5] = nArray4;
        nArrayArray[6] = new int[]{10, 10, 10, 6, 2, -4, -10, -11, -11, -11};
        int[] nArray5 = new int[10];
        nArray5[0] = 7;
        nArray5[1] = 7;
        nArray5[3] = -7;
        nArray5[4] = -4;
        nArray5[5] = 2;
        nArray5[6] = 9;
        nArray5[7] = 12;
        nArray5[8] = 13;
        nArray5[9] = 13;
        nArrayArray[7] = nArray5;
        nArrayArray[8] = new int[]{-11, -11, -11, -4, 4, 11, 17, 17, 17, 17};
        nArrayArray[9] = new int[]{5, 12, 6, -4, -3, 2, 5, 11, 14, 15};
        int[] nArray6 = new int[10];
        nArray6[0] = -6;
        nArray6[2] = 4;
        nArray6[3] = 6;
        nArray6[4] = 7;
        nArray6[5] = 7;
        nArray6[6] = 4;
        nArray6[7] = 4;
        nArray6[8] = 4;
        nArray6[9] = 4;
        nArrayArray[10] = nArray6;
        int[] nArray7 = new int[10];
        nArray7[0] = 8;
        nArray7[1] = 8;
        nArray7[8] = 8;
        nArray7[9] = 8;
        nArrayArray[11] = nArray7;
        nArrayArray[12] = new int[]{-2, 5, 8, 8, 5, -1, -2, -2, -1, -1};
        int[] nArray8 = new int[10];
        nArray8[0] = 1;
        nArray8[1] = 1;
        nArray8[3] = -6;
        nArray8[4] = 1;
        nArray8[5] = 7;
        nArray8[6] = 7;
        nArray8[7] = 1;
        nArray8[8] = 1;
        nArray8[9] = 1;
        nArrayArray[13] = nArray8;
        nArrayArray[14] = new int[]{8, 5, -5, -8, -2, 4, 9, 11, 11, 11};
        nArrayArray[15] = new int[]{8, 7, 1, -6, -5, 1, 8, 11, 11, 9};
        PRESET_DB = nArrayArray;
    }

    public GraphicEqGUI(GraphicEQ graphicEQ) {
        if (graphicEQ == null) {
            throw new IllegalArgumentException("Equalizer must not be null!");
        }
        this.eq = graphicEQ;
        this.presetsActive = this.eq.getBandCount() == 10;
        this.initialize();
    }

    private void initialize() {
        this.setName("Equalizer");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSelectionPanel(), Helpers.getGridBagConstraint(0, 0, 1, 0, 2, 18, 1.0, 0.0));
        this.add((Component)this.getBandsPanel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 2, 18, 1.0, 0.0));
        this.add((Component)this.getPreAmpPanel(), Helpers.getGridBagConstraint(1, 1, 1, 0, 2, 18, 1.0, 0.0));
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new JPanel();
            this.selectionPanel.setName("selectionPanel");
            this.selectionPanel.setLayout(new GridBagLayout());
            this.selectionPanel.setBorder(new TitledBorder(null, "Selections", 4, 2, Helpers.DIALOG_FONT, null));
            this.selectionPanel.add((Component)this.getEqualizerActive(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 1.0, 0.0));
            this.selectionPanel.add((Component)this.getPresetSelectionLabel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 13, 1.0, 0.0));
            this.selectionPanel.add((Component)this.getPresetSelection(), Helpers.getGridBagConstraint(2, 0, 1, 0, 2, 13, 1.0, 0.0));
        }
        return this.selectionPanel;
    }

    private JCheckBox getEqualizerActive() {
        if (this.equalizerActive == null) {
            this.equalizerActive = new JCheckBox();
            this.equalizerActive.setName("equalizerActive");
            this.equalizerActive.setText("activate equalizer");
            this.equalizerActive.setFont(Helpers.DIALOG_FONT);
            if (this.eq != null) {
                this.equalizerActive.setSelected(this.eq.isActive());
            }
            this.equalizerActive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if ((itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) && GraphicEqGUI.this.eq != null) {
                        GraphicEqGUI.this.eq.setIsActive(GraphicEqGUI.this.getEqualizerActive().isSelected());
                    }
                }
            });
        }
        return this.equalizerActive;
    }

    private JLabel getPresetSelectionLabel() {
        if (this.presetSelectionLabel == null) {
            this.presetSelectionLabel = new JLabel("Presets:");
            this.presetSelectionLabel.setFont(Helpers.DIALOG_FONT);
            this.presetSelectionLabel.setEnabled(this.presetsActive);
        }
        return this.presetSelectionLabel;
    }

    private JComboBox getPresetSelection() {
        if (this.presetSelection == null) {
            this.presetSelection = new JComboBox();
            this.presetSelection.setName("presetSelection");
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(PRESET_NAMES);
            this.presetSelection.setModel(defaultComboBoxModel);
            this.presetSelection.setFont(Helpers.DIALOG_FONT);
            this.presetSelection.setEnabled(this.presetsActive);
            this.presetSelection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        GraphicEqGUI.this.setPreset(GraphicEqGUI.this.getPresetSelection().getSelectedIndex());
                    }
                }
            });
        }
        return this.presetSelection;
    }

    private JSlider createDefaultSlider(float f) {
        if (f > 20.0f) {
            f = 20.0f;
        } else if (f < -20.0f) {
            f = -20.0f;
        }
        JSlider jSlider = new JSlider(1, -2000, 2000, (int)(f * 100.0f));
        jSlider.setFont(Helpers.DIALOG_FONT);
        jSlider.setMinorTickSpacing(500);
        jSlider.setMajorTickSpacing(1000);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(false);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTrack(true);
        jSlider.setToolTipText(String.valueOf(Float.toString((float)Math.round(f * 10.0f) / 10.0f)) + DEZIBEL);
        jSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    ((JSlider)mouseEvent.getSource()).setValue(0);
                }
            }
        });
        return jSlider;
    }

    private JPanel getBandsPanel() {
        if (this.bandsPanel == null) {
            this.bandsPanel = new JPanel();
            this.bandsPanel.setName("bandsPanel");
            this.bandsPanel.setLayout(new GridBagLayout());
            this.bandsPanel.setBorder(new TitledBorder(null, "Bands", 4, 2, Helpers.DIALOG_FONT, null));
            this.maxLabel = new JLabel("+" + Integer.toString(20));
            this.maxLabel.setFont(Helpers.DIALOG_FONT);
            this.bandsPanel.add((Component)this.maxLabel, Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 11, 0.0, 1.0));
            this.centerLabel = new JLabel("0db");
            this.centerLabel.setFont(Helpers.DIALOG_FONT);
            this.bandsPanel.add((Component)this.centerLabel, Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 10, 0.0, 1.0));
            this.minLabel = new JLabel(Integer.toString(-20));
            this.minLabel.setFont(Helpers.DIALOG_FONT);
            this.bandsPanel.add((Component)this.minLabel, Helpers.getGridBagConstraint(0, 2, 1, 1, 0, 15, 0.0, 1.0));
            int n = this.eq.getBandCount();
            this.sliders = new JSlider[n];
            this.slidersLable = new JLabel[n];
            int n2 = 0;
            while (n2 < n) {
                this.sliders[n2] = this.createDefaultSlider(this.eq.getBand(n2));
                this.sliders[n2].setName(Integer.toString(n2));
                this.sliders[n2].addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        JSlider jSlider = (JSlider)changeEvent.getSource();
                        String string = jSlider.getName();
                        int n = Integer.parseInt(string);
                        int n2 = jSlider.getValue();
                        GraphicEqGUI.this.eq.setBand(n, (float)n2 / 100.0f);
                        jSlider.setToolTipText(String.valueOf(Float.toString((float)Math.round(GraphicEqGUI.this.eq.getBand(n) * 10.0f) / 10.0f)) + GraphicEqGUI.DEZIBEL);
                    }
                });
                int n3 = this.eq.getCenterFreq(n2);
                String string = n3 >= 1000 ? String.valueOf(Integer.toString(n3 / 1000)) + "k" : Integer.toString(n3);
                this.slidersLable[n2] = new JLabel(string);
                this.slidersLable[n2].setFont(Helpers.DIALOG_FONT);
                this.bandsPanel.add((Component)this.sliders[n2], Helpers.getGridBagConstraint(n2 + 1, 0, 3, 1, 3, 10, 0.0, 1.0));
                this.bandsPanel.add((Component)this.slidersLable[n2], Helpers.getGridBagConstraint(n2 + 1, 3, 1, 1, 0, 10, 0.0, 0.0));
                ++n2;
            }
        }
        return this.bandsPanel;
    }

    private JPanel getPreAmpPanel() {
        if (this.preAmpPanel == null) {
            this.preAmpPanel = new JPanel();
            this.preAmpPanel.setName("preAmpPanel");
            this.preAmpPanel.setLayout(new GridBagLayout());
            this.preAmpPanel.setBorder(new TitledBorder(null, "Pre Amp", 4, 2, Helpers.DIALOG_FONT, null));
            this.preAmpSlider = this.createDefaultSlider(this.eq.getPreAmpDB());
            this.preAmpSlider.setName("PreAmp");
            this.preAmpSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    GraphicEqGUI.this.eq.setPreAmp((float)n / 100.0f);
                    jSlider.setToolTipText(String.valueOf(Float.toString((float)Math.round(GraphicEqGUI.this.eq.getPreAmpDB() * 10.0f) / 10.0f)) + GraphicEqGUI.DEZIBEL);
                }
            });
            this.preAmpSliderLable = new JLabel("PreAmp");
            this.preAmpSliderLable.setFont(Helpers.DIALOG_FONT);
            this.preAmpPanel.add((Component)this.preAmpSlider, Helpers.getGridBagConstraint(0, 0, 1, 0, 3, 10, 0.0, 1.0));
            this.preAmpPanel.add((Component)this.preAmpSliderLable, Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.preAmpPanel;
    }

    private void setPreset(int n) {
        int[] nArray = PRESET_DB[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.sliders[n2].setValue(nArray[n2] * 100);
            ++n2;
        }
    }
}

