/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.system.Log;
import javax.sound.sampled.AudioFormat;

public class ModMixer
extends BasicMixer {
    private static final int TMPBUFFERLENGTH = 2048;
    private final Module mod;
    private final BasicModMixer modMixer;
    private int bufferSize;
    private int outputBufferSize;
    private int sampleSizeInBits;
    private int channels;
    private int sampleRate;
    private int doISP;
    private int doNoLoops;
    private boolean doWideStereoMix;
    private boolean doNoiseReduction;
    private boolean doMegaBass;
    private int[] LBuffer;
    private int[] RBuffer;
    private byte[] output;
    private long currentSamplesWritten;
    private int maxWideStereo;
    private int[] wideLBuffer;
    private int[] wideRBuffer;
    private int readPointer;
    private int writePointer;
    private int nLeftNR;
    private int nRightNR;
    private int nXBassSum;
    private int nXBassBufferPos;
    private int nXBassDlyPos;
    private int nXBassMask;
    private int nXBassDepth;
    private int[] XBassBuffer;
    private int[] XBassDelay;

    public ModMixer(Module module, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, int n5) {
        this.mod = module;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.sampleRate = n3;
        this.doWideStereoMix = n2 < 2 ? false : bl;
        this.doNoiseReduction = bl2;
        this.doMegaBass = bl3;
        this.doISP = n4;
        this.doNoLoops = n5;
        this.modMixer = this.mod.getModMixer(n3, n4, n5);
    }

    private void initialize() {
        this.bufferSize = this.sampleRate >> 2;
        this.LBuffer = new int[this.bufferSize];
        this.RBuffer = new int[this.bufferSize];
        this.outputBufferSize = this.bufferSize * this.channels;
        int n = this.sampleSizeInBits >> 3;
        this.outputBufferSize *= n;
        this.output = new byte[this.outputBufferSize];
        this.maxWideStereo = this.sampleRate / 50;
        this.wideLBuffer = new int[this.maxWideStereo];
        this.wideRBuffer = new int[this.maxWideStereo];
        this.readPointer = 0;
        this.writePointer = this.maxWideStereo - 1;
        this.initMegaBass();
        this.nLeftNR = 0;
        this.nRightNR = 0;
        this.setAudioFormat(new AudioFormat(this.sampleRate, this.sampleSizeInBits, this.channels, true, false));
    }

    private void initMegaBass() {
        int n = this.sampleRate * 14 / 10000;
        if (n > 64) {
            n = 64;
        }
        int n2 = 2;
        while (n2 <= n) {
            n2 <<= 1;
        }
        this.XBassBuffer = new int[64];
        this.XBassDelay = new int[64];
        this.nXBassMask = (n2 >> 1) - 1;
        this.nXBassSum = 0;
        this.nXBassBufferPos = 0;
        this.nXBassDlyPos = 0;
        this.nXBassDepth = 6;
    }

    public void setDoNoiseReduction(boolean bl) {
        this.doNoiseReduction = bl;
    }

    public void setDoWideStereoMix(boolean bl) {
        this.doWideStereoMix = bl;
    }

    public void setDoMegaBass(boolean bl) {
        this.doMegaBass = bl;
    }

    public void setDoNoLoops(int n) {
        this.modMixer.changeDoNoLoops(n);
    }

    public void setDoISP(int n) {
        this.modMixer.changeISP(n);
    }

    public void setSampleRate(int n) {
        boolean bl;
        int n2 = this.sampleRate;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.sampleRate = n;
        if (bl) {
            this.modMixer.changeSampleRate(n);
            this.initialize();
            this.openAudioDevice();
            if (!this.isInitialized()) {
                this.sampleRate = n2;
                this.modMixer.changeSampleRate(n2);
                this.initialize();
                this.openAudioDevice();
            }
            this.pausePlayback();
        }
    }

    public void setSampleSizeInBits(int n) {
        boolean bl;
        int n2 = this.sampleSizeInBits;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.sampleSizeInBits = n;
        this.initialize();
        this.openAudioDevice();
        if (!this.isInitialized()) {
            this.sampleSizeInBits = n2;
            this.initialize();
            this.openAudioDevice();
        }
        if (bl) {
            this.pausePlayback();
        }
    }

    public void setChannels(int n) {
        boolean bl;
        int n2 = this.channels;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.pausePlayback();
        }
        this.channels = n;
        this.initialize();
        this.openAudioDevice();
        if (!this.isInitialized()) {
            this.channels = n2;
            this.initialize();
            this.openAudioDevice();
        }
        if (bl) {
            this.pausePlayback();
        }
    }

    public Module getMod() {
        return this.mod;
    }

    public BasicModMixer getModMixer() {
        return this.modMixer;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getMillisecondPosition() {
        return this.currentSamplesWritten * 1000L / (long)this.sampleRate;
    }

    @Override
    protected void seek(long l) {
        try {
            if (this.getMillisecondPosition() > l) {
                this.modMixer.initializeMixer();
                this.currentSamplesWritten = 0L;
            }
            int[] nArray = new int[2048];
            int[] nArray2 = new int[2048];
            this.modMixer.changeSampleRate(1000);
            this.modMixer.changeISP(0);
            while (this.getMillisecondPosition() < l) {
                int n = this.modMixer.mixIntoBuffer(nArray, nArray2, 2048);
                if (n <= 0) break;
                this.currentSamplesWritten += (long)(n * this.sampleRate / 1000);
            }
            this.modMixer.changeSampleRate(this.sampleRate);
            this.modMixer.changeISP(this.doISP);
        }
        catch (Exception exception) {
            Log.error("[ModMixer]", exception);
        }
    }

    @Override
    public long getLengthInMilliseconds() {
        int[] nArray = new int[2048];
        int[] nArray2 = new int[2048];
        this.modMixer.changeSampleRate(1000);
        this.modMixer.changeISP(0);
        if (this.doNoLoops == 0) {
            this.modMixer.changeDoNoLoops(1);
        }
        long l = 0L;
        this.modMixer.setIsFastForward(true);
        while (l < 3600000L) {
            int n = this.modMixer.mixIntoBuffer(nArray, nArray2, 2048);
            if (n <= 0) break;
            l += (long)n;
        }
        this.modMixer.setIsFastForward(false);
        this.modMixer.changeSampleRate(this.sampleRate);
        this.modMixer.changeISP(this.doISP);
        this.modMixer.changeDoNoLoops(this.doNoLoops);
        this.modMixer.initializeMixer();
        return l;
    }

    @Override
    public int getChannelCount() {
        if (this.modMixer != null) {
            return this.modMixer.getCurrentUsedChannels();
        }
        return 0;
    }

    @Override
    public int getCurrentKBperSecond() {
        return this.getChannelCount() * this.sampleSizeInBits * this.sampleRate / 1000;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.currentSamplesWritten = 0L;
        this.setIsPlaying();
        int n = this.nXBassDepth + 1;
        int n2 = (1 << n) - 1;
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                int n3;
                do {
                    if ((n3 = this.modMixer.mixIntoBuffer(this.LBuffer, this.RBuffer, this.bufferSize)) > 0) {
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < n3) {
                            int n6;
                            int n7 = this.LBuffer[n5];
                            this.LBuffer[n5] = 0;
                            int n8 = this.RBuffer[n5];
                            this.RBuffer[n5] = 0;
                            ++n5;
                            if (this.doWideStereoMix) {
                                this.wideLBuffer[this.writePointer] = n7;
                                this.wideRBuffer[this.writePointer++] = n8;
                                if (this.writePointer >= this.maxWideStereo) {
                                    this.writePointer = 0;
                                }
                                n8 += this.wideLBuffer[this.readPointer] >> 1;
                                n7 += this.wideRBuffer[this.readPointer++] >> 1;
                                if (this.readPointer >= this.maxWideStereo) {
                                    this.readPointer = 0;
                                }
                            }
                            if (this.doMegaBass) {
                                int n9;
                                this.nXBassSum -= this.XBassBuffer[this.nXBassBufferPos];
                                n6 = n7 + n8;
                                this.XBassBuffer[this.nXBassBufferPos] = n9 = n6 + (n6 >> 31 & n2) >> n;
                                this.nXBassSum += n9;
                                int n10 = this.XBassDelay[this.nXBassDlyPos];
                                this.XBassDelay[this.nXBassDlyPos] = n7;
                                n7 = n10 + this.nXBassSum;
                                n10 = this.XBassDelay[this.nXBassDlyPos + 1];
                                this.XBassDelay[this.nXBassDlyPos + 1] = n8;
                                n8 = n10 + this.nXBassSum;
                                this.nXBassDlyPos = this.nXBassDlyPos + 2 & this.nXBassMask;
                                this.nXBassBufferPos = this.nXBassBufferPos + 1 & this.nXBassMask;
                            }
                            if (this.doNoiseReduction) {
                                n6 = n7 >> 1;
                                n7 = n6 + this.nLeftNR;
                                this.nLeftNR = n6;
                                n6 = n8 >> 1;
                                n8 = n6 + this.nRightNR;
                                this.nRightNR = n6;
                            }
                            if (n7 > 0x7FFFFF) {
                                n7 = 0x7FFFFF;
                            } else if (n7 < -8388608) {
                                n7 = -8388608;
                            }
                            if (n8 > 0x7FFFFF) {
                                n8 = 0x7FFFFF;
                            } else if (n8 < -8388608) {
                                n8 = -8388608;
                            }
                            if (this.channels == 2) {
                                switch (this.sampleSizeInBits) {
                                    case 24: {
                                        this.output[n4++] = (byte)n7;
                                        this.output[n4++] = (byte)(n7 >> 8);
                                        this.output[n4++] = (byte)(n7 >> 16);
                                        this.output[n4++] = (byte)n8;
                                        this.output[n4++] = (byte)(n8 >> 8);
                                        this.output[n4++] = (byte)(n8 >> 16);
                                        break;
                                    }
                                    case 16: {
                                        this.output[n4++] = (byte)(n7 >> 8);
                                        this.output[n4++] = (byte)(n7 >> 16);
                                        this.output[n4++] = (byte)(n8 >> 8);
                                        this.output[n4++] = (byte)(n8 >> 16);
                                        break;
                                    }
                                    default: {
                                        this.output[n4++] = (byte)(n7 >> 16);
                                        this.output[n4++] = (byte)(n8 >> 16);
                                        break;
                                    }
                                }
                                continue;
                            }
                            n6 = (n7 >> 1) + (n8 >> 1);
                            switch (this.sampleSizeInBits) {
                                case 24: {
                                    this.output[n4++] = (byte)n6;
                                    this.output[n4++] = (byte)(n6 >> 8);
                                    this.output[n4++] = (byte)(n6 >> 16);
                                    break;
                                }
                                case 16: {
                                    this.output[n4++] = (byte)(n6 >> 8);
                                    this.output[n4++] = (byte)(n6 >> 16);
                                    break;
                                }
                                default: {
                                    this.output[n4++] = (byte)(n6 >> 16);
                                }
                            }
                        }
                        this.writeSampleDataToLine(this.output, 0, n4);
                        this.currentSamplesWritten += (long)n3;
                    }
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.isInSeeking()) continue;
                    this.setIsSeeking();
                    while (this.isInSeeking()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (n3 != -1);
                if (n3 <= 0) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
        }
    }
}

