/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.NoMPEGFramesException;
import java.io.IOException;

public class MPEGAudioFrameHeader {
    private static final int HEADER_SIZE = 4;
    private static final int[][] bitrateTable = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private static final int[][] sampleTable = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
    private static final String[] versionLabels;
    private static final String[] layerLabels;
    private static final String[] channelLabels;
    private static final String[] emphasisLabels;
    private static final int MPEG_V_25 = 0;
    private static final int MPEG_V_2 = 2;
    private static final int MPEG_V_1 = 3;
    private static final int MPEG_L_3 = 1;
    private static final int MPEG_L_2 = 2;
    private static final int MPEG_L_1 = 3;
    private int version = -1;
    private int layer = -1;
    private int bitRate = -1;
    private int sampleRate = -1;
    private int channelMode = -1;
    private boolean copyrighted = false;
    private boolean crced = false;
    private boolean original = false;
    private int emphasis = -1;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "MPEG Version 2.5";
        stringArray[2] = "MPEG Version 2.0";
        stringArray[3] = "MPEG Version 1.0";
        versionLabels = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[1] = "Layer III";
        stringArray2[2] = "Layer II";
        stringArray2[3] = "Layer I";
        layerLabels = stringArray2;
        channelLabels = new String[]{"Stereo", "Joint Stereo (STEREO)", "Dual Channel (STEREO)", "Single Channel (MONO)"};
        String[] stringArray3 = new String[4];
        stringArray3[0] = "none";
        stringArray3[1] = "50/15 ms";
        stringArray3[3] = "CCIT J.17";
        emphasisLabels = stringArray3;
    }

    public MPEGAudioFrameHeader(RandomAccessInputStream randomAccessInputStream) throws NoMPEGFramesException, IOException {
        this(randomAccessInputStream, 0);
    }

    public MPEGAudioFrameHeader(RandomAccessInputStream randomAccessInputStream, int n) throws NoMPEGFramesException, IOException {
        long l = this.findFrame(randomAccessInputStream, n);
        if (l == -1L) {
            throw new NoMPEGFramesException();
        }
        this.readHeader(randomAccessInputStream, l);
    }

    private long findFrame(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        long l = -1L;
        randomAccessInputStream.seek(n);
        while (l == -1L) {
            byte by = randomAccessInputStream.readByte();
            if ((by & 0xFF) != 255 || ((by = randomAccessInputStream.readByte()) & 0xE0) != 224) continue;
            return randomAccessInputStream.getFilePointer() - 2L;
        }
        return -1L;
    }

    private void readHeader(RandomAccessInputStream randomAccessInputStream, long l) throws IOException {
        byte[] byArray = new byte[4];
        randomAccessInputStream.seek(l);
        if (randomAccessInputStream.read(byArray) != 4) {
            throw new IOException("Error reading MPEG frame header.");
        }
        this.version = (byArray[1] & 0x18) >> 3;
        this.layer = (byArray[1] & 6) >> 1;
        this.crced = (byArray[1] & 1) == 0;
        this.bitRate = this.findBitRate((byArray[2] & 0xF0) >> 4, this.version, this.layer);
        this.sampleRate = this.findSampleRate((byArray[2] & 0xC) >> 2, this.version);
        this.channelMode = (byArray[3] & 0xC0) >> 6;
        this.copyrighted = (byArray[3] & 8) != 0;
        this.original = (byArray[3] & 4) != 0;
        this.emphasis = byArray[3] & 3;
    }

    private int findBitRate(int n, int n2, int n3) {
        int n4 = -1;
        if (n2 == 3) {
            if (n3 == 3) {
                n4 = 0;
            } else if (n3 == 2) {
                n4 = 1;
            } else if (n3 == 1) {
                n4 = 2;
            }
        } else if (n2 == 2 || n2 == 0) {
            if (n3 == 3) {
                n4 = 3;
            } else if (n3 == 2 || n3 == 1) {
                n4 = 4;
            }
        }
        if (n4 != -1 && n >= 0 && n <= 15) {
            return bitrateTable[n][n4];
        }
        return -1;
    }

    private int findSampleRate(int n, int n2) {
        int n3 = -1;
        switch (n2) {
            case 3: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 2;
            }
        }
        if (n3 != -1 && n >= 0 && n <= 3) {
            return sampleTable[n][n3];
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.getVersion()) + " " + this.getLayer() + "\nBitRate:\t\t\t" + this.getBitRate() + "kbps\nSampleRate:\t\t\t" + this.getSampleRate() + "Hz\nChannelMode:\t\t\t" + this.getChannelMode() + "\nCopyrighted:\t\t\t" + this.isCopyrighted() + "\nOriginal:\t\t\t" + this.isOriginal() + "\nCRC:\t\t\t\t" + this.isProtected() + "\nEmphasis:\t\t\t" + this.getEmphasis();
    }

    public String getVersion() {
        String string = null;
        if (this.version >= 0 && this.version < versionLabels.length) {
            string = versionLabels[this.version];
        }
        return string;
    }

    public String getLayer() {
        String string = null;
        if (this.layer >= 0 && this.layer < layerLabels.length) {
            string = layerLabels[this.layer];
        }
        return string;
    }

    public String getChannelMode() {
        String string = null;
        if (this.channelMode >= 0 && this.channelMode < channelLabels.length) {
            string = channelLabels[this.channelMode];
        }
        return string;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isCopyrighted() {
        return this.copyrighted;
    }

    public boolean isProtected() {
        return this.crced;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public String getEmphasis() {
        String string = null;
        if (this.emphasis >= 0 && this.emphasis < emphasisLabels.length) {
            string = emphasisLabels[this.emphasis];
        }
        return string;
    }

    public boolean isMP3() {
        return this.layer == 1;
    }
}

