/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg.metadata;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.multimedia.ogg.metadata.JOrbisComment;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;

public class OggMetaData {
    private URL urlName = null;
    private HashMap<String, String> oggInfo = null;
    private int lengthInMilliseconds;

    public OggMetaData(URL uRL) {
        this.readMetaData(uRL);
    }

    private void readMetaData(URL uRL) {
        InputStream inputStream = null;
        try {
            try {
                this.urlName = uRL;
                inputStream = new FileOrPackedInputStream(uRL);
                JOrbisComment jOrbisComment = new JOrbisComment();
                jOrbisComment.read(inputStream);
                inputStream.close();
                this.lengthInMilliseconds = jOrbisComment.getLengthInMilliseconds();
                this.oggInfo = new HashMap();
                int n = 99;
                while (n >= 0) {
                    String string = jOrbisComment.getComment().getComment(n);
                    if (string != null && string.length() > 0) {
                        int n2 = string.indexOf(61);
                        String string2 = string.substring(0, n2);
                        String string3 = new String(string.substring(n2 + 1).getBytes(), "UTF-8");
                        if (n2 != -1) {
                            this.oggInfo.put(string2, string3);
                        }
                    }
                    --n;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
                inputStream = null;
            }
        }
    }

    public int getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    public String getAlbum() {
        return this.oggInfo.get("ALBUM");
    }

    public String getTitle() {
        return this.oggInfo.get("TITLE");
    }

    public String getGenre() {
        return this.oggInfo.get("GENRE");
    }

    public String getComposer() {
        return this.oggInfo.get("COMPOSER");
    }

    public String getTrackNumber() {
        return this.oggInfo.get("TRACKNUMBER");
    }

    public String getComment() {
        return this.oggInfo.get("COMMENT");
    }

    public String getPublisher() {
        return this.oggInfo.get("PUBLISHER");
    }

    public String getBPM() {
        return this.oggInfo.get("bpm");
    }

    public String getArtist() {
        return this.oggInfo.get("ARTIST");
    }

    public String getDiscNumber() {
        return this.oggInfo.get("DISCNUMBER");
    }

    public String getAlbumArtist() {
        return this.oggInfo.get("ALBUMARTIST");
    }

    public String getDate() {
        return this.oggInfo.get("DATE");
    }

    public String getShortDescription() {
        String string = this.getArtist();
        String string2 = this.getTitle();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() != 0) {
            stringBuilder.append(string).append(" - ");
        }
        if ((string2 == null || string2.length() == 0) && this.urlName != null) {
            string2 = this.urlName.getPath();
            int n = (string2 = string2.substring(string2.lastIndexOf(47) + 1)).lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        }
        return stringBuilder.append(string2).toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("OggMetaData\nURL\t\t");
        stringBuilder.append(this.urlName);
        Set<String> set = this.oggInfo.keySet();
        for (String string : set) {
            String string2 = this.oggInfo.get(string);
            stringBuilder.append('\n').append(string).append("\t\t").append(string2);
        }
        stringBuilder.append("\nLength:\t\t\t").append(this.getLengthInMilliseconds());
        return stringBuilder.toString();
    }
}

