/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.sid.SIDMixer;
import de.quippy.javamod.multimedia.sid.SidConfigPanel;
import de.quippy.javamod.system.Log;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class SIDContainer
extends MultimediaContainer {
    private static final String[] SIDFILEEXTENSION = new String[]{"sid", "dat", "inf"};
    public static final String PROPERTY_SID_FREQUENCY = "javamod.player.sid.frequency";
    public static final String PROPERTY_SID_MODEL = "javamod.player.sid.sidmodel";
    public static final String PROPERTY_SID_OPTIMIZATION = "javamod.player.sid.optimization";
    public static final String PROPERTY_SID_USEFILTER = "javamod.player.sid.usesidfilter";
    public static final String PROPERTY_SID_VIRTUALSTEREO = "javamod.player.sid.virtualstrereo";
    public static final String DEFAULT_SAMPLERATE = "44100";
    public static final String DEFAULT_SIDMODEL = "0";
    public static final String DEFAULT_OPTIMIZATION = "1";
    public static final String DEFAULT_USEFILTER = "true";
    public static final String DEFAULT_VIRTUALSTEREO = "false";
    public static final String[] SAMPLERATE = new String[]{"8000", "11025", "16000", "22050", "33075", "44100", "48000", "96000"};
    public static final String[] SIDMODELS = new String[]{"best", "SID 6581 (old model)", "SID 8580 (new model)"};
    private SidTune sidTune;
    private SIDMixer currentMixer;
    private SidConfigPanel sidConfigPanel;
    private JPanel sidInfoPanel;

    static {
        MultimediaContainerManager.registerContainer(new SIDContainer());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        this.sidTune = this.loadSidTune(uRL);
        return multimediaContainer;
    }

    @Override
    public String getSongName() {
        if (this.sidTune != null) {
            return this.getShortDescriptionFrom(this.sidTune);
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            SidTune sidTune = this.loadSidTune(uRL);
            if (sidTune != null) {
                string = this.getShortDescriptionFrom(sidTune);
                l = sidTune.getInfo().songs * 1000;
            }
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    public void nameChanged() {
        this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID, this.getSongName()));
    }

    @Override
    public boolean canExport() {
        return true;
    }

    private SidTune loadSidTune(URL uRL) {
        FileOrPackedInputStream fileOrPackedInputStream = null;
        try {
            int n;
            fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
            int n2 = ((InputStream)fileOrPackedInputStream).available();
            if (n2 < 1024) {
                n2 = 1024;
            }
            short[] sArray = new short[n2];
            int n3 = 0;
            while ((n = ((InputStream)fileOrPackedInputStream).read()) != -1) {
                sArray[n3++] = (short)(n & 0xFF);
                if (n3 < sArray.length) continue;
                short[] sArray2 = new short[sArray.length + n2];
                System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
                sArray = sArray2;
            }
            SidTune sidTune = new SidTune(sArray, n3);
            return sidTune;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (fileOrPackedInputStream != null) {
                try {
                    ((InputStream)fileOrPackedInputStream).close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }

    private String getShortDescriptionFrom(SidTune sidTune) {
        SidTuneInfo sidTuneInfo = sidTune.getInfo();
        String[] stringArray = sidTuneInfo.infoString;
        return String.valueOf(stringArray[0]) + " [" + stringArray[1] + "] " + Integer.toString(sidTuneInfo.currentSong) + '/' + Integer.toString(sidTuneInfo.songs) + " (" + stringArray[2] + ')';
    }

    @Override
    public Mixer createNewMixer() {
        Properties properties = new Properties();
        this.configurationSave(properties);
        int n = Integer.parseInt(properties.getProperty(PROPERTY_SID_FREQUENCY, DEFAULT_SAMPLERATE));
        int n2 = Integer.parseInt(properties.getProperty(PROPERTY_SID_MODEL, DEFAULT_SIDMODEL));
        int n3 = Integer.parseInt(properties.getProperty(PROPERTY_SID_OPTIMIZATION, DEFAULT_OPTIMIZATION));
        boolean bl = Boolean.parseBoolean(properties.getProperty(PROPERTY_SID_USEFILTER, DEFAULT_USEFILTER));
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(PROPERTY_SID_VIRTUALSTEREO, DEFAULT_VIRTUALSTEREO));
        this.currentMixer = new SIDMixer(this.sidTune, this, n, n2, n3, bl, bl2);
        return this.currentMixer;
    }

    public SIDMixer getCurrentMixer() {
        return this.currentMixer;
    }

    @Override
    public void configurationChanged(Properties properties) {
        SidConfigPanel sidConfigPanel = (SidConfigPanel)this.getConfigPanel();
        sidConfigPanel.getPlayerSetUp_SampleRate().setSelectedItem(properties.getProperty(PROPERTY_SID_FREQUENCY, DEFAULT_SAMPLERATE));
        sidConfigPanel.getPlayerSetUp_SIDModel().setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_SID_MODEL, DEFAULT_SIDMODEL)));
        sidConfigPanel.getPlayerSetUp_UseSIDFilter().setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_SID_USEFILTER, DEFAULT_USEFILTER)));
        sidConfigPanel.getPlayerSetUp_VirtualStereo().setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_SID_VIRTUALSTEREO, DEFAULT_VIRTUALSTEREO)));
        int n = Integer.parseInt(properties.getProperty(PROPERTY_SID_OPTIMIZATION, DEFAULT_OPTIMIZATION));
        if (n <= 1) {
            sidConfigPanel.getPlayerSetUp_Optimization_Level1().setSelected(true);
        } else {
            sidConfigPanel.getPlayerSetUp_Optimization_Level2().setSelected(true);
        }
    }

    @Override
    public void configurationSave(Properties properties) {
        SidConfigPanel sidConfigPanel = (SidConfigPanel)this.getConfigPanel();
        properties.setProperty(PROPERTY_SID_FREQUENCY, sidConfigPanel.getPlayerSetUp_SampleRate().getSelectedItem().toString());
        properties.setProperty(PROPERTY_SID_MODEL, Integer.toString(sidConfigPanel.getPlayerSetUp_SIDModel().getSelectedIndex()));
        properties.setProperty(PROPERTY_SID_USEFILTER, Boolean.toString(sidConfigPanel.getPlayerSetUp_UseSIDFilter().isSelected()));
        properties.setProperty(PROPERTY_SID_VIRTUALSTEREO, Boolean.toString(sidConfigPanel.getPlayerSetUp_VirtualStereo().isSelected()));
        properties.setProperty(PROPERTY_SID_OPTIMIZATION, sidConfigPanel.getPlayerSetUp_Optimization_Level1().isSelected() ? DEFAULT_OPTIMIZATION : "2");
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.sidInfoPanel == null) {
            this.sidInfoPanel = new JPanel();
        }
        return this.sidInfoPanel;
    }

    @Override
    public JPanel getConfigPanel() {
        if (this.sidConfigPanel == null) {
            this.sidConfigPanel = new SidConfigPanel();
            this.sidConfigPanel.setParentContainer(this);
        }
        return this.sidConfigPanel;
    }

    @Override
    public String[] getFileExtensionList() {
        return SIDFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "SID-File";
    }
}

