/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.VorbisString;
import java.io.IOException;
import java.util.ArrayList;

public class VorbisComment
extends Metadata {
    private static final String EMPTY_STRING = "";
    protected byte[] vendorString = new byte[0];
    protected int numComments = 0;
    protected VorbisString[] comments;

    public VorbisComment(BitInputStream bitInputStream, int n, boolean bl) throws IOException {
        super(bl);
        int n2 = bitInputStream.readRawIntLittleEndian();
        this.vendorString = new byte[n2];
        bitInputStream.readByteBlockAlignedNoCRC(this.vendorString, this.vendorString.length);
        this.numComments = bitInputStream.readRawIntLittleEndian();
        if (this.numComments > 0) {
            this.comments = new VorbisString[this.numComments];
        }
        int n3 = 0;
        while (n3 < this.numComments) {
            this.comments[n3] = new VorbisString(bitInputStream);
            ++n3;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("VendorString '").append(new String(this.vendorString)).append("'\n");
        stringBuilder.append("VorbisComment (count=" + this.numComments + ")");
        int n = 0;
        while (n < this.numComments) {
            stringBuilder.append("\n\t" + this.comments[n].toString());
            ++n;
        }
        return stringBuilder.toString();
    }

    public String[] getCommentByName(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.comments.length) {
            String string2 = this.comments[n].toString();
            int n2 = string2.indexOf(61);
            if (n2 != -1 && string2.substring(0, n2).equalsIgnoreCase(string)) {
                arrayList.add(string2.substring(n2 + 1, string2.length()));
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    public String getComment() {
        String[] stringArray = this.getCommentByName("COMMENT");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getGenre() {
        String[] stringArray = this.getCommentByName("GENRE");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getDate() {
        String[] stringArray = this.getCommentByName("DATE");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getAlbum() {
        String[] stringArray = this.getCommentByName("ALBUM");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getTotalDiscs() {
        String[] stringArray = this.getCommentByName("TOTALDISCS");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getDiscNumber() {
        String[] stringArray = this.getCommentByName("DISCNUMBER");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getTotalTracks() {
        String[] stringArray = this.getCommentByName("TOTALTRACKS");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getTrackNumber() {
        String[] stringArray = this.getCommentByName("TRACKNUMBER");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getTitle() {
        String[] stringArray = this.getCommentByName("TITLE");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }

    public String getArtist() {
        String[] stringArray = this.getCommentByName("ARTIST");
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            return stringArray[0];
        }
        return EMPTY_STRING;
    }
}

