/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import java.io.EOFException;
import java.io.IOException;

public class ID3Tag {
    public String Header;
    public String Title;
    public String Artist;
    public String Album;
    public String Year;
    public String Comment;
    public short Track;
    public short Genre;
    public static final int ID3_TAG_BYTES = 128;

    public static final ID3Tag read(File file) throws IOException {
        file.seek(file.length() - 128L);
        try {
            ID3Tag iD3Tag = new ID3Tag();
            ByteArrayReader byteArrayReader = new ByteArrayReader(file, 128);
            iD3Tag.Header = byteArrayReader.readString(3, "US-ASCII");
            iD3Tag.Title = byteArrayReader.readString(30, "US-ASCII");
            iD3Tag.Artist = byteArrayReader.readString(30, "US-ASCII");
            iD3Tag.Album = byteArrayReader.readString(30, "US-ASCII");
            iD3Tag.Year = byteArrayReader.readString(4, "US-ASCII");
            iD3Tag.Comment = byteArrayReader.readString(29, "US-ASCII");
            iD3Tag.Track = byteArrayReader.readUnsignedByte();
            iD3Tag.Genre = byteArrayReader.readUnsignedByte();
            return iD3Tag.Header.equals("TAG") ? iD3Tag : null;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public final void write(ByteArrayWriter byteArrayWriter) {
        byteArrayWriter.writeString(this.Header, 3, "US-ASCII");
        byteArrayWriter.writeString(this.Title, 30, "US-ASCII");
        byteArrayWriter.writeString(this.Artist, 30, "US-ASCII");
        byteArrayWriter.writeString(this.Album, 30, "US-ASCII");
        byteArrayWriter.writeString(this.Year, 4, "US-ASCII");
        byteArrayWriter.writeString(this.Comment, 29, "US-ASCII");
        byteArrayWriter.writeUnsignedByte(this.Track);
        byteArrayWriter.writeUnsignedByte(this.Genre);
    }
}

