/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.ogg.jorbis;

import de.quippy.ogg.jogg.Buffer;
import de.quippy.ogg.jorbis.Block;
import de.quippy.ogg.jorbis.CodeBook;
import de.quippy.ogg.jorbis.DspState;
import de.quippy.ogg.jorbis.FuncResidue;
import de.quippy.ogg.jorbis.Info;
import de.quippy.ogg.jorbis.InfoMode;
import de.quippy.ogg.jorbis.Util;

class Residue0
extends FuncResidue {
    private static int[][][] _01inverse_partword = new int[2][][];
    static int[][] _2inverse_partword = null;

    Residue0() {
    }

    @Override
    void pack(Object object, Buffer buffer) {
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        int n = 0;
        buffer.write(infoResidue0.begin, 24);
        buffer.write(infoResidue0.end, 24);
        buffer.write(infoResidue0.grouping - 1, 24);
        buffer.write(infoResidue0.partitions - 1, 6);
        buffer.write(infoResidue0.groupbook, 8);
        int n2 = 0;
        while (n2 < infoResidue0.partitions) {
            int n3 = infoResidue0.secondstages[n2];
            if (Util.ilog(n3) > 3) {
                buffer.write(n3, 3);
                buffer.write(1, 1);
                buffer.write(n3 >>> 3, 5);
            } else {
                buffer.write(n3, 4);
            }
            n += Util.icount(n3);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            buffer.write(infoResidue0.booklist[n2], 8);
            ++n2;
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        int n = 0;
        InfoResidue0 infoResidue0 = new InfoResidue0();
        infoResidue0.begin = buffer.read(24);
        infoResidue0.end = buffer.read(24);
        infoResidue0.grouping = buffer.read(24) + 1;
        infoResidue0.partitions = buffer.read(6) + 1;
        infoResidue0.groupbook = buffer.read(8);
        int n2 = 0;
        while (n2 < infoResidue0.partitions) {
            int n3 = buffer.read(3);
            if (buffer.read(1) != 0) {
                n3 |= buffer.read(5) << 3;
            }
            infoResidue0.secondstages[n2] = n3;
            n += Util.icount(n3);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            infoResidue0.booklist[n2] = buffer.read(8);
            ++n2;
        }
        if (infoResidue0.groupbook >= info.books) {
            this.free_info(infoResidue0);
            return null;
        }
        n2 = 0;
        while (n2 < n) {
            if (infoResidue0.booklist[n2] >= info.books) {
                this.free_info(infoResidue0);
                return null;
            }
            ++n2;
        }
        return infoResidue0;
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        int n;
        int n2;
        int n3;
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        LookResidue0 lookResidue0 = new LookResidue0();
        int n4 = 0;
        int n5 = 0;
        lookResidue0.info = infoResidue0;
        lookResidue0.parts = infoResidue0.partitions;
        lookResidue0.fullbooks = dspState.fullbooks;
        lookResidue0.phrasebook = dspState.fullbooks[infoResidue0.groupbook];
        int n6 = lookResidue0.phrasebook.dim;
        lookResidue0.partbooks = new int[lookResidue0.parts][];
        int n7 = 0;
        while (n7 < lookResidue0.parts) {
            n3 = infoResidue0.secondstages[n7];
            n2 = Util.ilog(n3);
            if (n2 != 0) {
                if (n2 > n5) {
                    n5 = n2;
                }
                lookResidue0.partbooks[n7] = new int[n2];
                n = 0;
                while (n < n2) {
                    if ((n3 & 1 << n) != 0) {
                        lookResidue0.partbooks[n7][n] = infoResidue0.booklist[n4++];
                    }
                    ++n;
                }
            }
            ++n7;
        }
        lookResidue0.partvals = (int)Math.rint(Math.pow(lookResidue0.parts, n6));
        lookResidue0.stages = n5;
        lookResidue0.decodemap = new int[lookResidue0.partvals][];
        n7 = 0;
        while (n7 < lookResidue0.partvals) {
            n3 = n7;
            n2 = lookResidue0.partvals / lookResidue0.parts;
            lookResidue0.decodemap[n7] = new int[n6];
            n = 0;
            while (n < n6) {
                int n8 = n3 / n2;
                n3 -= n8 * n2;
                n2 /= lookResidue0.parts;
                lookResidue0.decodemap[n7][n] = n8;
                ++n;
            }
            ++n7;
        }
        return lookResidue0;
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    static synchronized int _01inverse(Block block, Object object, float[][] fArray, int n, int n2) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n3 = infoResidue0.grouping;
        int n4 = lookResidue0.phrasebook.dim;
        int n5 = infoResidue0.end - infoResidue0.begin;
        int n6 = n5 / n3;
        int n7 = (n6 + n4 - 1) / n4;
        if (_01inverse_partword.length < n) {
            _01inverse_partword = new int[n][][];
        }
        int n8 = 0;
        while (n8 < n) {
            if (_01inverse_partword[n8] == null || _01inverse_partword[n8].length < n7) {
                Residue0._01inverse_partword[n8] = new int[n7][];
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < lookResidue0.stages) {
            int n10 = 0;
            int n11 = 0;
            while (n10 < n6) {
                int n12;
                if (n9 == 0) {
                    n8 = 0;
                    while (n8 < n) {
                        n12 = lookResidue0.phrasebook.decode(block.opb);
                        if (n12 == -1) {
                            return 0;
                        }
                        Residue0._01inverse_partword[n8][n11] = lookResidue0.decodemap[n12];
                        if (_01inverse_partword[n8][n11] == null) {
                            return 0;
                        }
                        ++n8;
                    }
                }
                int n13 = 0;
                while (n13 < n4 && n10 < n6) {
                    n8 = 0;
                    while (n8 < n) {
                        CodeBook codeBook;
                        n12 = infoResidue0.begin + n10 * n3;
                        int n14 = _01inverse_partword[n8][n11][n13];
                        if ((infoResidue0.secondstages[n14] & 1 << n9) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[n14][n9]]) != null && (n2 == 0 ? codeBook.decodevs_add(fArray[n8], n12, block.opb, n3) == -1 : n2 == 1 && codeBook.decodev_add(fArray[n8], n12, block.opb, n3) == -1)) {
                            return 0;
                        }
                        ++n8;
                    }
                    ++n13;
                    ++n10;
                }
                ++n11;
            }
            ++n9;
        }
        return 0;
    }

    static synchronized int _2inverse(Block block, Object object, float[][] fArray, int n) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n2 = infoResidue0.grouping;
        int n3 = lookResidue0.phrasebook.dim;
        int n4 = infoResidue0.end - infoResidue0.begin;
        int n5 = n4 / n2;
        int n6 = (n5 + n3 - 1) / n3;
        if (_2inverse_partword == null || _2inverse_partword.length < n6) {
            _2inverse_partword = new int[n6][];
        }
        int n7 = 0;
        while (n7 < lookResidue0.stages) {
            int n8 = 0;
            int n9 = 0;
            while (n8 < n5) {
                int n10;
                if (n7 == 0) {
                    n10 = lookResidue0.phrasebook.decode(block.opb);
                    if (n10 == -1) {
                        return 0;
                    }
                    Residue0._2inverse_partword[n9] = lookResidue0.decodemap[n10];
                    if (_2inverse_partword[n9] == null) {
                        return 0;
                    }
                }
                int n11 = 0;
                while (n11 < n3 && n8 < n5) {
                    CodeBook codeBook;
                    n10 = infoResidue0.begin + n8 * n2;
                    int n12 = _2inverse_partword[n9][n11];
                    if ((infoResidue0.secondstages[n12] & 1 << n7) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[n12][n7]]) != null && codeBook.decodevv_add(fArray, n10, n, block.opb, n2) == -1) {
                        return 0;
                    }
                    ++n11;
                    ++n8;
                }
                ++n9;
            }
            ++n7;
        }
        return 0;
    }

    @Override
    int inverse(Block block, Object object, float[][] fArray, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] != 0) {
                fArray[n2++] = fArray[n3];
            }
            ++n3;
        }
        if (n2 != 0) {
            return Residue0._01inverse(block, object, fArray, n2, 0);
        }
        return 0;
    }

    private static class InfoResidue0 {
        int begin;
        int end;
        int grouping;
        int partitions;
        int groupbook;
        int[] secondstages = new int[64];
        int[] booklist = new int[256];

        private InfoResidue0() {
        }
    }

    private static class LookResidue0 {
        InfoResidue0 info;
        int parts;
        int stages;
        CodeBook[] fullbooks;
        CodeBook phrasebook;
        int[][] partbooks;
        int partvals;
        int[][] decodemap;

        private LookResidue0() {
        }
    }
}

