/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.Settings;
import xtrememp.util.Utilities;

public class EqualizerDialog
extends JDialog
implements ActionListener {
    private final Logger logger = LoggerFactory.getLogger(EqualizerDialog.class);
    private String[] sliderLabels = new String[]{"60", "170", "310", "600", "1K", "3K", "6K", "12K", "14K", "16K"};
    private String[] presetsLabels = new String[]{"Normal", "Classical", "Club", "Dance", "Full Bass", "Full Bass & Treble", "Full Treble", "Laptop", "Live", "Party", "Pop", "Reggae", "Rock", "Techno"};
    private int[] gainValue = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
    private int[] PRESET_NORMAL = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
    private int[] PRESET_CLASSICAL = new int[]{50, 50, 50, 50, 50, 50, 70, 70, 70, 76};
    private int[] PRESET_CLUB = new int[]{50, 50, 42, 34, 34, 34, 42, 50, 50, 50};
    private int[] PRESET_DANCE = new int[]{26, 34, 46, 50, 50, 66, 70, 70, 50, 50};
    private int[] PRESET_FULLBASS = new int[]{26, 26, 26, 36, 46, 62, 76, 78, 78, 78};
    private int[] PRESET_FULLBASSTREBLE = new int[]{34, 34, 50, 68, 62, 46, 28, 22, 18, 18};
    private int[] PRESET_FULLTREBLE = new int[]{78, 78, 78, 62, 42, 24, 8, 8, 8, 8};
    private int[] PRESET_LAPTOP = new int[]{38, 22, 36, 60, 58, 46, 38, 24, 16, 14};
    private int[] PRESET_LIVE = new int[]{66, 50, 40, 36, 34, 34, 40, 42, 42, 42};
    private int[] PRESET_PARTY = new int[]{32, 32, 50, 50, 50, 50, 50, 50, 32, 32};
    private int[] PRESET_POP = new int[]{56, 38, 32, 30, 38, 54, 56, 56, 54, 54};
    private int[] PRESET_REGGAE = new int[]{48, 48, 50, 66, 48, 34, 34, 48, 48, 48};
    private int[] PRESET_ROCK = new int[]{32, 38, 64, 72, 56, 40, 28, 24, 24, 24};
    private int[] PRESET_TECHNO = new int[]{30, 34, 48, 66, 64, 48, 30, 24, 24, 28};
    private Map<String, int[]> presetMap;
    public static final int LINEARDIST = 1;
    public static final int OVERDIST = 2;
    private float[] bands = null;
    private int[] eqgains = null;
    private int eqdist = 2;
    private JCheckBox activateCheckBox;
    private JComboBox presetComboBox;
    private JSlider panSlider;
    private JSlider[] sliders;

    public EqualizerDialog(JFrame mainFrame) {
        super((Frame)mainFrame, false);
        this.setLayout(new BorderLayout());
        this.setTitle(Utilities.tr("Equalizer"));
        this.initComponents();
        Utilities.closeOnEscape(this);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(mainFrame);
        this.setVisible(true);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.activateCheckBox = new JCheckBox("Activate");
        toolBar.add(this.activateCheckBox);
        toolBar.addSeparator();
        JPanel panPanel = new JPanel(new BorderLayout());
        this.panSlider = new JSlider(-100, 100, 0);
        panPanel.add((Component)new JLabel("L"), "West");
        panPanel.add((Component)this.panSlider, "Center");
        panPanel.add((Component)new JLabel("R"), "East");
        toolBar.add(panPanel);
        toolBar.addSeparator();
        this.presetMap = new HashMap<String, int[]>();
        this.presetMap.put(this.presetsLabels[0], this.PRESET_NORMAL);
        this.presetMap.put(this.presetsLabels[1], this.PRESET_CLASSICAL);
        this.presetMap.put(this.presetsLabels[2], this.PRESET_CLUB);
        this.presetMap.put(this.presetsLabels[3], this.PRESET_DANCE);
        this.presetMap.put(this.presetsLabels[4], this.PRESET_FULLBASS);
        this.presetMap.put(this.presetsLabels[5], this.PRESET_FULLBASSTREBLE);
        this.presetMap.put(this.presetsLabels[6], this.PRESET_FULLTREBLE);
        this.presetMap.put(this.presetsLabels[7], this.PRESET_LAPTOP);
        this.presetMap.put(this.presetsLabels[8], this.PRESET_LIVE);
        this.presetMap.put(this.presetsLabels[9], this.PRESET_PARTY);
        this.presetMap.put(this.presetsLabels[10], this.PRESET_POP);
        this.presetMap.put(this.presetsLabels[11], this.PRESET_REGGAE);
        this.presetMap.put(this.presetsLabels[12], this.PRESET_ROCK);
        this.presetMap.put(this.presetsLabels[13], this.PRESET_TECHNO);
        this.presetComboBox = new JComboBox<String>(this.presetsLabels);
        this.presetComboBox.setSelectedIndex(Settings.getEqualizerPresetIndex());
        this.presetComboBox.addActionListener(this);
        toolBar.add(this.presetComboBox);
        container.add((Component)toolBar, "North");
        this.sliders = new JSlider[10];
        int sLength = this.sliders.length;
        JPanel centerPanel = new JPanel(new GridLayout(0, sLength));
        this.sliders = new JSlider[10];
        for (int i = 0; i < sLength; ++i) {
            JPanel sliderPanel = new JPanel(new BorderLayout());
            this.sliders[i] = new JSlider(1, 0, 100, 50);
            this.sliders[i].setMajorTickSpacing(50);
            this.sliders[i].setMinorTickSpacing(5);
            this.sliders[i].setPaintTicks(true);
            sliderPanel.add((Component)this.sliders[i], "Center");
            JLabel sliderLabel = new JLabel(this.sliderLabels[i]);
            sliderLabel.setHorizontalAlignment(0);
            sliderPanel.add((Component)sliderLabel, "South");
            centerPanel.add(sliderPanel);
        }
        container.add((Component)centerPanel, "Center");
    }

    public void setBands(float[] bands) {
        this.bands = bands;
    }

    public void updateSliders(int[] gains) {
        if (gains != null) {
            int len = gains.length;
            for (int i = 0; i < len; ++i) {
                this.gainValue[i + 1] = gains[i];
                this.sliders[i].setValue(this.gainValue[i + 1]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source != this.activateCheckBox && source == this.presetComboBox) {
            Settings.setEqualizerPresetIndex(this.presetComboBox.getSelectedIndex());
            String currentPreset = String.valueOf(this.presetComboBox.getSelectedItem());
            this.updateSliders(this.presetMap.get(currentPreset));
            this.logger.info("Equilazer: new preset selected: {}", (Object)currentPreset);
        }
    }
}

