/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.tag.datatype.Artwork;

public abstract class TagInfo {
    protected String encodingType = null;
    protected String format = null;
    protected String location = null;
    protected String channels = null;
    protected String sampleRate = null;
    protected String bitRate = null;
    protected String track = null;
    protected String year = null;
    protected String genre = null;
    protected String title = null;
    protected String artist = null;
    protected String album = null;
    protected String comment = null;
    protected Artwork artwork = null;
    protected int channelsAsNumber = -1;
    protected int sampleRateAsNumber = -1;
    protected long bitRateAsNumber = -1L;
    protected long duration = -1L;
    protected long size = -1L;

    public abstract void load(InputStream var1) throws IOException, UnsupportedAudioFileException;

    public abstract void load(URL var1) throws IOException, UnsupportedAudioFileException;

    public abstract void load(File var1) throws IOException, UnsupportedAudioFileException;

    public abstract String getCodecDetails();

    public String getEncodingType() {
        return this.encodingType == null ? null : this.encodingType.trim();
    }

    public String getFormat() {
        return this.format == null ? null : this.format.trim();
    }

    public int getSampleRate() {
        return this.sampleRateAsNumber;
    }

    public int getSampleRateAsNumber() {
        return this.sampleRateAsNumber;
    }

    public String getBitRate() {
        return this.bitRate;
    }

    public long getBitRateAsNumber() {
        return this.bitRateAsNumber;
    }

    public String getChannels() {
        return this.channels;
    }

    public int getChannelsAsNumber() {
        this.channelsAsNumber = this.channels.contains("Stereo") ? 2 : (this.channels.contains("Joint Stereo") ? 2 : (this.channels.contains("Dual") ? 2 : (this.channels.contains("Mono") ? 1 : Integer.parseInt(this.channels))));
        return this.channelsAsNumber;
    }

    public long getTrackLength() {
        return this.duration;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title.trim();
    }

    public String getArtist() {
        return this.artist == null ? "" : this.artist.trim();
    }

    public String getAlbum() {
        return this.album == null ? "" : this.album.trim();
    }

    public String getTrack() {
        if (this.track != null && this.track.contains("/")) {
            this.track = this.track.substring(0, this.track.indexOf("/"));
        }
        return this.track == null ? "" : this.track.trim();
    }

    public String getGenre() {
        return this.genre == null ? "" : this.genre.trim();
    }

    public String getYear() {
        return this.year == null ? "" : this.year.trim();
    }

    public String getComment() {
        return this.comment == null ? "" : this.comment.trim();
    }

    public Artwork getArtwork() {
        return this.artwork;
    }
}

