/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.combobox;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.api.skin.SkinInfo;
import xtrememp.Settings;
import xtrememp.ui.skin.DarkSapphireSkin;

public class SkinComboSelector
extends JComboBox {
    public SkinComboSelector() {
        this.addItem(SkinComboSelector.create("Dark Sapphire", DarkSapphireSkin.class, false));
        Map skinMap = SubstanceLookAndFeel.getAllSkins();
        SubstanceSkin currentSkin = SubstanceLookAndFeel.getCurrentSkin();
        for (Map.Entry entry : skinMap.entrySet()) {
            SkinInfo si = (SkinInfo)entry.getValue();
            this.addItem(si);
            if (si.getDisplayName().compareTo(currentSkin.getDisplayName()) != 0) continue;
            this.setSelectedItem(si);
        }
        this.setRenderer(new SubstanceDefaultComboBoxRenderer(this){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, (Object)((SkinInfo)value).getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SkinInfo skinInfo = (SkinInfo)SkinComboSelector.this.getSelectedItem();
                        SubstanceLookAndFeel.setSkin((String)skinInfo.getClassName());
                        Settings.setSkin(skinInfo.getClassName());
                    }
                });
            }
        });
    }

    private static SkinInfo create(String displayName, Class<?> skinClass, boolean isDefault) {
        SkinInfo result = new SkinInfo(displayName, skinClass.getName());
        result.setDefault(isDefault);
        return result;
    }
}

