/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import xtrememp.ui.table.PlaylistColumn;
import xtrememp.ui.table.PlaylistTableColumn;

public class PlaylistTableColumnModel
extends DefaultTableColumnModel
implements ActionListener {
    private Map<JCheckBoxMenuItem, PlaylistTableColumn> map = new HashMap<JCheckBoxMenuItem, PlaylistTableColumn>();
    private JPopupMenu popupMenu = new JPopupMenu();

    public PlaylistTableColumnModel() {
        PlaylistColumn[] playlistColumns;
        for (PlaylistColumn playlistColumn : playlistColumns = PlaylistColumn.values()) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(playlistColumn.getDisplayName(), false);
            menuItem.setName(playlistColumn.name());
            if (playlistColumn == PlaylistColumn.TITLE) {
                menuItem.setEnabled(false);
            } else {
                menuItem.addActionListener(this);
            }
            this.popupMenu.add(menuItem);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void resetAll(int modelIndex) {
        Enumeration<TableColumn> columnEnum = this.getColumns();
        while (columnEnum.hasMoreElements()) {
            PlaylistTableColumn playlistTableColumn;
            TableColumn tableColumn = columnEnum.nextElement();
            if (!(tableColumn instanceof PlaylistTableColumn) || (playlistTableColumn = (PlaylistTableColumn)tableColumn).getModelIndex() == modelIndex) continue;
            playlistTableColumn.reset();
        }
    }

    public PlaylistColumn[] getPlaylistColumns() {
        PlaylistColumn[] playlistColumns = new PlaylistColumn[this.getColumnCount()];
        ArrayList<PlaylistColumn> columnsList = new ArrayList<PlaylistColumn>(this.getColumnCount());
        Enumeration<TableColumn> columnEnum = this.getColumns();
        while (columnEnum.hasMoreElements()) {
            TableColumn tableColumn = columnEnum.nextElement();
            if (!(tableColumn instanceof PlaylistTableColumn)) continue;
            PlaylistTableColumn playlistTableColumn = (PlaylistTableColumn)tableColumn;
            columnsList.add(playlistTableColumn.getModelIndex(), playlistTableColumn.getPlaylistColumn());
        }
        return columnsList.toArray(playlistColumns);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (tableColumn instanceof PlaylistTableColumn) {
            Component[] components;
            PlaylistTableColumn playlistTableColumn = (PlaylistTableColumn)tableColumn;
            for (Component component : components = this.popupMenu.getComponents()) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)component;
                if (!menuItem.getText().equals(playlistTableColumn.getName())) continue;
                this.map.put(menuItem, playlistTableColumn);
                menuItem.setSelected(true);
                break;
            }
        }
    }

    @Override
    public PlaylistTableColumn getColumn(int columnIndex) {
        return (PlaylistTableColumn)super.getColumn(columnIndex);
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        PlaylistTableColumn fromTableColumn = this.getColumn(columnIndex);
        PlaylistTableColumn toTableColumn = this.getColumn(newIndex);
        super.moveColumn(columnIndex, newIndex);
        fromTableColumn.setModelIndex(newIndex);
        toTableColumn.setModelIndex(columnIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)source;
            PlaylistTableColumn playlistTableColumn = this.map.get(menuItem);
            if (menuItem.isSelected()) {
                int columnCount = this.getColumnCount();
                if (playlistTableColumn == null) {
                    PlaylistColumn playlistColumn = PlaylistColumn.valueOf(menuItem.getName());
                    playlistTableColumn = new PlaylistTableColumn(playlistColumn, columnCount);
                    this.map.put(menuItem, playlistTableColumn);
                }
                super.addColumn(playlistTableColumn);
                playlistTableColumn.setModelIndex(columnCount);
            } else {
                Enumeration<TableColumn> columnEnum = this.getColumns();
                while (columnEnum.hasMoreElements()) {
                    TableColumn tableColumn = columnEnum.nextElement();
                    int modelIndex = tableColumn.getModelIndex();
                    if (modelIndex <= playlistTableColumn.getModelIndex()) continue;
                    tableColumn.setModelIndex(modelIndex - 1);
                }
                this.removeColumn(playlistTableColumn);
            }
        }
    }
}

