/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization.spectrum;

import xtrememp.visualization.spectrum.Band;
import xtrememp.visualization.spectrum.BandDistribution;
import xtrememp.visualization.spectrum.FFT;

public class LinearBandDistribution
implements BandDistribution {
    @Override
    public Band[] create(int bandCount, FFT fft, float sampleRate) {
        int oss = fft.getOutputSampleSize();
        int r = (int)((double)oss / (double)bandCount);
        float[] fqt = fft.calculateFrequencyTable(sampleRate);
        float lfq = 0.0f;
        Band[] bdTable = new Band[bandCount];
        int band = 0;
        for (double a = (double)r; a <= (double)oss && band < bandCount; ++band, a += (double)r) {
            bdTable[band] = new Band((int)a, lfq, fqt[(int)a - r]);
            lfq = fqt[(int)a - r];
        }
        return bdTable;
    }
}

