/*
 * Decompiled with CFR 0.152.
 */
package com.melloware.jspiff.jaxp;

import com.melloware.jspiff.jaxp.RStack;
import com.melloware.jspiff.jaxp.UJAXP;
import com.melloware.jspiff.jaxp.URelaxer;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public final class RNameClass {
    private Node pattern_;

    public RNameClass(String config) {
        try {
            Document doc = UJAXP.getDocument(new StringReader(config));
            this.pattern_ = this._makePattern(doc.getDocumentElement());
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        catch (SAXException e) {
            throw new IllegalArgumentException();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException();
        }
    }

    public String[] getAttributeHungry(RStack stack) {
        Element element = stack.getContextElement();
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            String attrName;
            Attr attr = (Attr)attrs.item(i);
            if (stack.isConsumedAttribute(attr) || !this.pattern_.eval("", attrName = attr.getName())) continue;
            stack.consumeAttribute(attr);
            String[] result = new String[]{attrName, element.getAttribute(attrName)};
            return result;
        }
        return null;
    }

    public boolean isMatchAttributeHungry(RStack stack) {
        Element element = stack.getContextElement();
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrName = attr.getName();
            if (stack.isConsumedAttribute(attr) || !this.pattern_.eval("", attrName)) continue;
            stack.consumeAttribute(attr);
            return true;
        }
        return false;
    }

    public boolean isMatchElement(Element element) {
        return this.pattern_.eval("", element.getTagName());
    }

    private Node _makePattern(Element element) {
        Node node;
        String tagName = element.getTagName();
        if ("anyName".equals(tagName)) {
            node = new AnyName();
        } else if ("nsName".equals(tagName)) {
            node = new NsName(element.getAttribute("ns"));
        } else {
            if ("name".equals(tagName)) {
                String ns = element.getAttribute("ns");
                String name = URelaxer.getElementPropertyAsString(element);
                Name node2 = new Name(ns, name);
                return node2;
            }
            if ("choice".equals(tagName)) {
                node = new Choice();
            } else if ("except".equals(tagName)) {
                node = new Except();
            } else {
                throw new IllegalArgumentException();
            }
        }
        Element[] children = URelaxer.getElements(element);
        for (int i = 0; i < children.length; ++i) {
            node.addChild(this._makePattern(children[i]));
        }
        return node;
    }

    public static class NsName
    extends Node {
        private String ns_;

        public NsName(String ns) {
            this.ns_ = ns;
        }

        protected boolean _evalBody(String ns, String local) {
            return this.ns_.equals(ns);
        }
    }

    public static class Node {
        protected List children_ = new ArrayList();

        public void addChild(Node child) {
            this.children_.add(child);
        }

        public boolean eval(String ns, String local) {
            if (!this._evalBody(ns, local)) {
                return false;
            }
            return this._evalChildren(ns, local);
        }

        protected boolean _evalBody(String ns, String local) {
            return true;
        }

        protected boolean _evalChildren(String ns, String local) {
            int size = this.children_.size();
            for (int i = 0; i < size; ++i) {
                Node node = (Node)this.children_.get(i);
                if (node.eval(ns, local)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Name
    extends Node {
        private String name_;
        private String ns_;

        public Name(String ns, String name) {
            this.ns_ = ns;
            this.name_ = name;
        }

        protected boolean _evalBody(String ns, String local) {
            return this.ns_.equals(ns) && this.name_.equals(local);
        }
    }

    public static class Except
    extends Node {
        public boolean eval(String ns, String local) {
            return !this._evalChildren(ns, local);
        }
    }

    public static class Choice
    extends Node {
        public boolean eval(String ns, String local) {
            int size = this.children_.size();
            for (int i = 0; i < size; ++i) {
                Node node = (Node)this.children_.get(i);
                if (!node.eval(ns, local)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AnyName
    extends Node {
    }
}

