/*
 * Decompiled with CFR 0.152.
 */
package com.melloware.jspiff.jaxp;

import com.melloware.jspiff.jaxp.RStack;
import com.melloware.jspiff.jaxp.UJAXP;
import com.melloware.jspiff.jaxp.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XspfLink
implements Serializable,
Cloneable {
    private String content_;
    private String rel_;

    public XspfLink() {
        this.rel_ = "";
    }

    public XspfLink(XspfLink source) {
        this.setup(source);
    }

    public XspfLink(RStack stack) {
        this.setup(stack);
    }

    public XspfLink(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XspfLink(Element element) {
        this.setup(element);
    }

    public XspfLink(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XspfLink(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XspfLink(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XspfLink(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XspfLink(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XspfLink(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "link")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "rel")) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XspfLink.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XspfLink.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }

    public String getContent() {
        return this.content_;
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getRel() {
        return this.rel_;
    }

    public String getRelAsString() {
        return URelaxer.getString(this.getRel());
    }

    public void setContent(String content) {
        this.content_ = content;
    }

    public void setContentByString(String string) {
        this.setContent(URelaxer.getString(string));
    }

    public void setRel(String rel) {
        this.rel_ = rel;
    }

    public void setRelByString(String string) {
        this.setRel(URelaxer.getString(string));
    }

    public Object clone() {
        return new XspfLink(this);
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("link");
        if (parent instanceof Document) {
            element.setAttribute("xmlns", "http://xspf.org/ns/0/");
        }
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.rel_ != null) {
            URelaxer.setAttributePropertyByString(element, "rel", this.rel_);
        }
        parent.appendChild(element);
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<link");
        buffer.append(" xmlns=\"http://xspf.org/ns/0/\"");
        if (this.rel_ != null) {
            buffer.append(" rel=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRel())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.content_ != null) {
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        }
        buffer.append("</link>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<link");
        buffer.write(" xmlns=\"http://xspf.org/ns/0/\"");
        if (this.rel_ != null) {
            buffer.write(" rel=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRel())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.content_ != null) {
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        }
        buffer.write("</link>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<link");
        buffer.print(" xmlns=\"http://xspf.org/ns/0/\"");
        if (this.rel_ != null) {
            buffer.print(" rel=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRel())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.content_ != null) {
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        }
        buffer.print("</link>");
    }

    public void setup(XspfLink source) {
        this.content_ = source.content_;
        this.rel_ = source.rel_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private void init(Element element) {
        try {
            this.content_ = URelaxer.getElementPropertyAsString(element);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.rel_ = URelaxer.getAttributePropertyAsString(element, "rel");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

