/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JLabel;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");
    protected static String defaultInstallDir = null;

    public PathInputPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        GridBagConstraints gbConstraint = this.getDefaultGridBagConstraints();
        gbConstraint.gridwidth = 0;
        this.setDefaultGridBagConstraints(gbConstraint);
        String introText = this.getI18nStringForClass("intro", "PathInputPanel");
        if (introText == null || introText.startsWith("PathInputPanel.intro")) {
            introText = "";
        }
        gbConstraint = this.getNextYGridBagConstraints();
        MultiLineLabel introLabel = this.createMultiLineLabel(introText);
        this.add((Component)introLabel, gbConstraint);
        gbConstraint = this.getNextYGridBagConstraints();
        gbConstraint.gridwidth = -1;
        gbConstraint.insets = new Insets(0, 0, 10, 0);
        JLabel infoLabel = this.createLabel("info", "TargetPanel", "open", 2);
        this.add((Component)infoLabel, gbConstraint);
        this.pathSelectionPanel = new PathSelectionPanel(this, idata);
        gbConstraint = this.getNextYGridBagConstraints();
        gbConstraint.gridwidth = 0;
        gbConstraint.fill = 2;
        gbConstraint.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.pathSelectionPanel, gbConstraint);
        this.createLayoutBottom();
        this.completeGridBagLayout();
    }

    public void createLayoutBottom() {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    public boolean isValidated() {
        String chosenPath = this.pathSelectionPanel.getPath();
        boolean ok = true;
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required"));
                return false;
            }
            ok = this.emitWarning(this.parent.langpack.getString("installer.warning"), this.emptyTargetMsg);
        }
        if (!ok) {
            return ok;
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this.pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("required", "PathInputPanel")));
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("notValid", "PathInputPanel")));
                return false;
            }
        } else {
            if (!this.isWriteable()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
            if (path.exists()) {
                int res = this.askQuestion(this.parent.langpack.getString("installer.warning"), this.warnMsg, 37, 47);
                ok = res == 47;
            } else {
                this.emitNotification(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + chosenPath);
            }
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this.existFiles == null) {
            return true;
        }
        for (int i = 0; i < this.existFiles.length; ++i) {
            File path = new File(this.pathSelectionPanel.getPath(), this.existFiles[i]).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean b) {
        this.mustExist = b;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaultInstallDir(InstallerFrame parentFrame, InstallData idata) {
        if (PathInputPanel.getDefaultInstallDir() != null) {
            return;
        }
        BufferedReader br = null;
        try {
            String line;
            InputStream in = null;
            if (OsVersion.IS_WINDOWS) {
                in = parentFrame.getResource("TargetPanel.dir.windows");
            } else if (OsVersion.IS_OSX) {
                in = parentFrame.getResource("TargetPanel.dir.macosx");
            } else {
                String os = System.getProperty("os.name");
                os = os.replace(' ', '_');
                os = os.toLowerCase();
                try {
                    in = parentFrame.getResource("TargetPanel.dir.".concat(os));
                }
                catch (ResourceNotFoundException rnfe) {
                    // empty catch block
                }
                if (in == null) {
                    in = parentFrame.getResource("TargetPanel.dir.unix");
                }
                if (in == null) {
                    try {
                        in = parentFrame.getResource("TargetPanel.dir.unix");
                    }
                    catch (ResourceNotFoundException eee) {
                        // empty catch block
                    }
                }
            }
            if (in == null) {
                try {
                    in = parentFrame.getResource("TargetPanel.dir");
                }
                catch (ResourceNotFoundException eee) {
                    // empty catch block
                }
            }
            InputStreamReader isr = new InputStreamReader(in);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null && (line = line.trim()).equals("")) {
            }
            defaultInstallDir = line;
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            defaultInstallDir = vs.substitute(defaultInstallDir, null);
        }
        catch (Exception e) {
            defaultInstallDir = null;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this.pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public static String getDefaultInstallDir() {
        return defaultInstallDir;
    }

    public static void setDefaultInstallDir(String string) {
        defaultInstallDir = string;
    }
}

