/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.tools.ByteArrayReader;
import davaguine.jmac.tools.ByteArrayWriter;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEHeaderNew {
    public int nCompressionLevel;
    public int nFormatFlags;
    public long nBlocksPerFrame;
    public long nFinalFrameBlocks;
    public long nTotalFrames;
    public int nBitsPerSample;
    public int nChannels;
    public long nSampleRate;
    public static final int APE_HEADER_BYTES = 24;

    public static APEHeaderNew read(File file) throws IOException {
        try {
            APEHeaderNew header = new APEHeaderNew();
            ByteArrayReader reader = new ByteArrayReader(file, 24);
            header.nCompressionLevel = reader.readUnsignedShort();
            header.nFormatFlags = reader.readUnsignedShort();
            header.nBlocksPerFrame = reader.readUnsignedInt();
            header.nFinalFrameBlocks = reader.readUnsignedInt();
            header.nTotalFrames = reader.readUnsignedInt();
            header.nBitsPerSample = reader.readUnsignedShort();
            header.nChannels = reader.readUnsignedShort();
            header.nSampleRate = reader.readUnsignedInt();
            return header;
        }
        catch (EOFException e) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter writer) {
        writer.writeUnsignedShort(this.nCompressionLevel);
        writer.writeUnsignedShort(this.nFormatFlags);
        writer.writeUnsignedInt(this.nBlocksPerFrame);
        writer.writeUnsignedInt(this.nFinalFrameBlocks);
        writer.writeUnsignedInt(this.nTotalFrames);
        writer.writeUnsignedShort(this.nBitsPerSample);
        writer.writeUnsignedShort(this.nChannels);
        writer.writeUnsignedInt(this.nSampleRate);
    }
}

