/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.spi;

import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.info.APETag;
import davaguine.jmac.tools.Globals;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class APEPropertiesHelper {
    public static void readProperties(IAPEDecompress decoder, Map fileProperties, Map formatProperties) throws IOException {
        formatProperties.put("bitrate", new Integer(decoder.getApeInfoDecompressAverageBitrate()));
        formatProperties.put("vbr", new Boolean(true));
        formatProperties.put("quality", new Integer(10));
        formatProperties.put("ape.version", new Integer(decoder.getApeInfoFileVersion()));
        formatProperties.put("ape.compressionlevel", new Integer(decoder.getApeInfoCompressionLevel()));
        formatProperties.put("ape.formatflags", new Integer(decoder.getApeInfoFormatFlags()));
        formatProperties.put("ape.totalframes", new Integer(decoder.getApeInfoTotalFrames()));
        formatProperties.put("ape.blocksperframe", new Integer(decoder.getApeInfoBlocksPerFrame()));
        formatProperties.put("ape.finalframeblocks", new Integer(decoder.getApeInfoFinalFrameBlocks()));
        formatProperties.put("ape.blockalign", new Integer(decoder.getApeInfoBlockAlign()));
        formatProperties.put("ape.totalblocks", new Integer(decoder.getApeInfoTotalBlocks()));
        formatProperties.put("ape.peaklevel", new Integer(decoder.getApeInfoPeakLevel()));
        fileProperties.put("duration", new Long(decoder.getApeInfoLengthMs()));
        if (decoder.getApeInfoIoSource().isLocal()) {
            APETag tag = decoder.getApeInfoTag();
            fileProperties.put("author", tag.GetFieldString("Artist"));
            fileProperties.put("title", tag.GetFieldString("Title"));
            fileProperties.put("copyright", tag.GetFieldString("Copyright"));
            String year = tag.GetFieldString("Year");
            Date date = null;
            try {
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(1, Integer.parseInt(year));
                date = c.getTime();
            }
            catch (Exception e) {
                // empty catch block
            }
            fileProperties.put("date", date);
            fileProperties.put("comment", tag.GetFieldString("Comment"));
            fileProperties.put("album", tag.GetFieldString("Album"));
            fileProperties.put("track", tag.GetFieldString("Track"));
            fileProperties.put("genre", tag.GetFieldString("Genre"));
        }
        if (Globals.DEBUG) {
            System.out.println("File Properties");
            System.out.println("duration: " + fileProperties.get("duration"));
            System.out.println("author: " + fileProperties.get("author"));
            System.out.println("title: " + fileProperties.get("title"));
            System.out.println("copyright: " + fileProperties.get("copyright"));
            System.out.println("date: " + fileProperties.get("date"));
            System.out.println("comment: " + fileProperties.get("comment"));
            System.out.println("album: " + fileProperties.get("album"));
            System.out.println("track: " + fileProperties.get("track"));
            System.out.println("genre: " + fileProperties.get("genre"));
            System.out.println("Format Properties");
            System.out.println("bitrate: " + formatProperties.get("bitrate"));
            System.out.println("vbr: " + formatProperties.get("vbr"));
            System.out.println("quality: " + formatProperties.get("quality"));
            System.out.println("ape.version: " + formatProperties.get("ape.version"));
            System.out.println("ape.compressionlevel: " + formatProperties.get("ape.compressionlevel"));
            System.out.println("ape.formatflags: " + formatProperties.get("ape.formatflags"));
            System.out.println("ape.totalframes: " + formatProperties.get("ape.totalframes"));
            System.out.println("ape.blocksperframe: " + formatProperties.get("ape.blocksperframe"));
            System.out.println("ape.finalframeblocks: " + formatProperties.get("ape.finalframeblocks"));
            System.out.println("ape.blockalign: " + formatProperties.get("ape.blockalign"));
            System.out.println("ape.totalblocks: " + formatProperties.get("ape.totalblocks"));
            System.out.println("ape.peaklevel: " + formatProperties.get("ape.peaklevel"));
        }
    }
}

