/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.skin;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DropTargetAdapter
implements DropTargetListener {
    private static Log log = LogFactory.getLog((Class)DropTargetAdapter.class);

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    protected boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) {
                dataFlavor = dataFlavorArray[i];
                break;
            }
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            dataFlavor = dataFlavorArray[i];
            break;
        }
        if (dataFlavor != null) {
            return (dropTargetDragEvent.getSourceActions() & 1) != 0;
        }
        return false;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) {
                dataFlavor = dataFlavorArray[i];
                break;
            }
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            dataFlavor = dataFlavorArray[i];
            break;
        }
        if (dataFlavor != null) {
            if ((dropTargetDropEvent.getSourceActions() & 1) == 0) {
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Object object = transferable.getTransferData(dataFlavor);
                this.processDrop(object);
            }
            catch (IOException iOException) {
                log.info((Object)"Drop error", (Throwable)iOException);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                log.info((Object)"Drop error", (Throwable)unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (Exception exception) {
                log.info((Object)"Drop error", (Throwable)exception);
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            dropTargetDropEvent.dropComplete(true);
        }
    }

    public void processDrop(Object object) {
    }
}

