/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamDemultiplexer;
import net.sourceforge.dvb.projectx.thirdparty.TS;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamConverter {
    private String FileName = "";
    private boolean FirstPacket = true;
    private boolean ptsover = false;
    private boolean ContainsVideo = false;
    private boolean BrokenLinkFlag = false;
    private boolean Debug = false;
    private boolean AddPcrToStream = false;
    private boolean ExportVideo = false;
    private boolean ExportNonVideo = false;
    private boolean MustStartWithVideo = false;
    private boolean SetMainAudioAc3 = false;
    private boolean GenerateTTX = false;
    private boolean GeneratePMT = false;
    private boolean PcrCounter = false;
    private boolean CreateVdrIndex = false;
    private boolean MuxPES = false;
    private byte[] PackHeader;
    private byte[] LeadingPackHeader;
    private byte[] SequenceEndCode;
    private byte[] TsStartPacketHeader;
    private byte[] TsSubPacketHeader;
    private byte[] PvaPacketHeader;
    private byte[] PvaPacketHeaderAndPTS;
    private byte[] SystemHeader;
    private byte[][] sys;
    private byte[] subID;
    private byte[] sysID;
    private byte[] adapt;
    private byte[] StuffingData;
    private long[] time;
    private long SCR_Value;
    private long PmtCounter;
    private long PCR_Delta;
    private final int PVA_MAINVIDEO = 1;
    private final int PVA_MAINAUDIO = 2;
    private int Action;
    private int CutMode;
    private int SystemHeaderInsertPoint;
    private int SystemHeaderLength;
    private int Packet;
    private int TsHeaderMode;
    private int[] PacketCounter;
    private int[] SystemHeaderStreams;
    private List PaddingStreamPositions;
    private List IDs;
    private IDDBufferedOutputStream OutputStream;
    private ByteArrayOutputStream Buffer;
    private ArrayList remuxList;

    public StreamConverter() {
        byte[] byArray = new byte[14];
        byArray[2] = 1;
        byArray[3] = -70;
        byArray[4] = 68;
        byArray[6] = 4;
        byArray[8] = 4;
        byArray[9] = 1;
        byArray[11] = -22;
        byArray[12] = 99;
        byArray[13] = -8;
        this.PackHeader = byArray;
        byte[] byArray2 = new byte[14];
        byArray2[2] = 1;
        byArray2[3] = -70;
        byArray2[4] = 68;
        byArray2[6] = 4;
        byArray2[8] = 4;
        byArray2[9] = 1;
        byArray2[11] = -22;
        byArray2[12] = 99;
        byArray2[13] = -8;
        this.LeadingPackHeader = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[2] = 1;
        byArray3[3] = -71;
        this.SequenceEndCode = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 71;
        byArray4[1] = 64;
        this.TsStartPacketHeader = byArray4;
        byte[] byArray5 = new byte[4];
        byArray5[0] = 71;
        this.TsSubPacketHeader = byArray5;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 65;
        byArray6[1] = 86;
        byArray6[4] = 85;
        this.PvaPacketHeader = byArray6;
        byte[] byArray7 = new byte[12];
        byArray7[0] = 65;
        byArray7[1] = 86;
        byArray7[4] = 85;
        byArray7[5] = 16;
        this.PvaPacketHeaderAndPTS = byArray7;
        byte[] byArray8 = new byte[12];
        byArray8[2] = 1;
        byArray8[3] = -69;
        byArray8[5] = 12;
        byArray8[6] = -128;
        byArray8[7] = -100;
        byArray8[8] = 65;
        byArray8[9] = 4;
        byArray8[10] = 33;
        byArray8[11] = 127;
        this.SystemHeader = byArray8;
        this.sys = new byte[][]{{-32, -32, -32}, {-67, -64, 32}, {-64, -64, 32}};
        byte[] byArray9 = new byte[4];
        byArray9[0] = -128;
        byArray9[1] = 1;
        byArray9[3] = 1;
        this.subID = byArray9;
        this.sysID = new byte[]{-32, -64};
        this.adapt = new byte[2];
        this.StuffingData = new byte[2324];
        this.time = new long[2];
        this.SCR_Value = 0L;
        this.PmtCounter = 0L;
        this.PCR_Delta = 65000L;
        this.PVA_MAINVIDEO = 1;
        this.PVA_MAINAUDIO = 2;
        this.Action = 0;
        this.CutMode = 0;
        this.SystemHeaderInsertPoint = 26;
        this.SystemHeaderLength = 138;
        this.Packet = 0;
        this.TsHeaderMode = 0;
        this.PacketCounter = new int[70];
        this.SystemHeaderStreams = new int[2];
        this.remuxList = new ArrayList();
        this.PaddingStreamPositions = new ArrayList();
        this.IDs = new ArrayList();
        this.Buffer = new ByteArrayOutputStream();
    }

    public void close(JobProcessing jobProcessing, boolean bl) {
        try {
            if (this.Action == 2) {
                this.writePacket(jobProcessing, this.SequenceEndCode);
            }
            this.OutputStream.flush();
            this.OutputStream.close();
            switch (this.Action) {
                case 2: {
                    int n;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.FileName, "rw");
                    if (this.LeadingPackHeader[2] == 1) {
                        randomAccessFile.seek(0L);
                        randomAccessFile.write(this.LeadingPackHeader);
                    }
                    randomAccessFile.seek(this.SystemHeaderInsertPoint);
                    Object[] objectArray = this.IDs.toArray();
                    Arrays.sort(objectArray);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        n = 0xFF & Integer.parseInt(objectArray[n2].toString());
                        if ((0xF0 & n) == 224) {
                            byte by = this.sysID[0];
                            this.sysID[0] = (byte)(by + 1);
                            this.sys[0][0] = by;
                            randomAccessFile.write(this.sys[0]);
                            this.SystemHeaderInsertPoint += 3;
                            this.SystemHeaderStreams[1] = this.SystemHeaderStreams[1] + 1;
                        } else if ((0xF0 & n) == 128) {
                            randomAccessFile.write(this.sys[1]);
                            this.SystemHeaderInsertPoint += 3;
                            this.SystemHeaderStreams[0] = this.SystemHeaderStreams[0] + 1;
                        } else if ((0xE0 & n) == 192) {
                            byte by = this.sysID[1];
                            this.sysID[1] = (byte)(by + 1);
                            this.sys[2][0] = by;
                            randomAccessFile.write(this.sys[2]);
                            this.SystemHeaderInsertPoint += 3;
                            this.SystemHeaderStreams[0] = this.SystemHeaderStreams[0] + 1;
                        }
                        ++n2;
                    }
                    randomAccessFile.writeInt(446);
                    randomAccessFile.writeShort((short)(138 - this.SystemHeaderInsertPoint));
                    randomAccessFile.write(this.StuffingData, 0, 138 - this.SystemHeaderInsertPoint);
                    n2 = (this.SystemHeaderStreams[0] + this.SystemHeaderStreams[1]) * 3 + 6;
                    CommonParsing.setPES_LengthField(this.SystemHeader, 0, n2);
                    this.SystemHeader[9] = (byte)(this.SystemHeaderStreams[0] << 2);
                    this.SystemHeader[10] = (byte)(0x20 | 0x1F & this.SystemHeaderStreams[1]);
                    randomAccessFile.seek(14L);
                    randomAccessFile.write(this.SystemHeader);
                    n = 0;
                    while (this.ContainsVideo && this.MustStartWithVideo && n < this.PaddingStreamPositions.size()) {
                        randomAccessFile.seek(Long.parseLong(this.PaddingStreamPositions.get(n).toString()));
                        randomAccessFile.write(-66);
                        ++n;
                    }
                    randomAccessFile.close();
                    break;
                }
                case 4: {
                    if (bl && this.GeneratePMT) {
                        TS.setPmtPids(this.IDs);
                    }
                    this.FileName = TS.updateAdditionalHeader(this.FileName, this.time, this.TsHeaderMode, jobProcessing);
                    break;
                }
                case 1: {
                    if (!this.CreateVdrIndex) break;
                    if (new File(this.FileName).length() < 150L) {
                        this.OutputStream.deleteIdd();
                        break;
                    }
                    this.FileName = this.OutputStream.renameVdrTo(String.valueOf(new File(this.FileName).getParent()) + System.getProperty("file.separator"), this.FileName);
                }
            }
            if (new File(this.FileName).length() < 150L) {
                new File(this.FileName).delete();
            } else {
                Common.setMessage(String.valueOf(Resource.getString("msg.newfile")) + " " + this.FileName);
                jobProcessing.addSummaryInfo(String.valueOf(Resource.getString("StreamConverter.Summary")) + "\t'" + this.FileName + "'");
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void getSettings(JobCollection jobCollection) {
        this.ExportVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo);
        this.ExportNonVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeAudio);
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.PCR_Delta = jobCollection.getSettings().getIntProperty(Keys.KEY_PcrDelta_Value);
        this.CutMode = jobCollection.getSettings().getIntProperty(Keys.KEY_CutMode);
        this.AddPcrToStream = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Conversion_addPcrToStream);
        this.MustStartWithVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Conversion_startWithVideo);
        this.SetMainAudioAc3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_setMainAudioAc3);
        this.GenerateTTX = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_generateTtx);
        this.GeneratePMT = jobCollection.getSettings().getBooleanProperty(Keys.KEY_TS_generatePmt);
        this.TsHeaderMode = jobCollection.getSettings().getIntProperty(Keys.KEY_TsHeaderMode);
        this.PcrCounter = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Conversion_PcrCounter);
        this.CreateVdrIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createVdrIndex);
    }

    public void init(JobCollection jobCollection, String string, int n, int n2, int n3) {
        this.FileName = string;
        this.FirstPacket = true;
        this.ContainsVideo = false;
        this.Action = n2;
        this.BrokenLinkFlag = false;
        this.ptsover = false;
        this.PmtCounter = 0L;
        this.SystemHeaderInsertPoint = 26;
        this.LeadingPackHeader[2] = 0;
        this.time[0] = -1L;
        this.SCR_Value = 0L;
        this.Packet = 0;
        this.getSettings(jobCollection);
        Arrays.fill(this.StuffingData, (byte)-1);
        this.Buffer.reset();
        if (n3 == 0) {
            this.IDs.clear();
            if (n2 == 4) {
                TS.buildTeletextStream(((XInputFile)jobCollection.getInputFile(0)).toString());
            }
            this.remuxList.clear();
            this.MuxPES = Common.getSettings().getBooleanProperty("HiddenKey.VDRExport.MuxPES", false);
            if (n2 == 1) {
                this.scanSecondaryStreams(jobCollection);
            }
        }
        try {
            this.OutputStream = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), n);
            if (this.Action == 1 && this.CreateVdrIndex) {
                this.OutputStream.InitVdr(String.valueOf(new File(this.FileName).getParent()) + System.getProperty("file.separator") + "index.vdr", n3);
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void packetizeToM2P(JobProcessing jobProcessing, byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer) {
        try {
            int n2 = streamDemultiplexer.getType();
            int n3 = streamDemultiplexer.getStreamType();
            int n4 = streamDemultiplexer.getnewID();
            if (CommonParsing.validateStartcode(byArray, n) < 0) {
                Common.setMessage("!> invalid startcode " + this.Packet + ", pos: " + jobProcessing.getLastHeaderBytePosition() + " (" + Integer.toHexString(n4) + "/" + n2 + ")");
                return;
            }
            int n5 = CommonParsing.getPES_LengthField(byArray, n);
            int n6 = 9;
            int n7 = n6 - 3 + n5;
            int n8 = 0;
            if (n7 + n > byArray.length) {
                return;
            }
            int n9 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
            boolean bl = false;
            boolean bl2 = CommonParsing.clearBit33ofPTS(byArray, n);
            CommonParsing.clearBit33ofDTS(byArray, n);
            switch (n2) {
                case 0: 
                case 6: {
                    if (this.ExportNonVideo) break;
                    return;
                }
                case 2: {
                    if (!this.ExportNonVideo) {
                        return;
                    }
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    break;
                }
                case 3: {
                    if (!this.ExportVideo || (0xFF & n4) != 224) {
                        return;
                    }
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    break;
                }
                default: {
                    return;
                }
            }
            if (n4 == 0) {
                return;
            }
            int n10 = 0;
            while (n10 < this.IDs.size()) {
                if (n4 == (0xFF & Integer.parseInt(this.IDs.get(n10).toString()))) break;
                ++n10;
            }
            if (n10 == this.IDs.size()) {
                if (n2 != 3 && !this.ContainsVideo && this.MustStartWithVideo) {
                    return;
                }
                if (!CommonParsing.alignSyncword(byArray, n, n2)) {
                    return;
                }
                n5 = CommonParsing.getPES_LengthField(byArray, n);
                n7 = n6 - 3 + n5;
                this.IDs.add(String.valueOf(n4 > 223 ? n4 : 256 + n4));
            }
            if (this.FirstPacket) {
                this.writePacket(jobProcessing, this.PackHeader);
                this.writePacket(jobProcessing, new byte[this.SystemHeaderLength - 8]);
                this.FirstPacket = false;
            }
            if (n2 == 0 || n2 == 6) {
                if (n3 == 3) {
                    CommonParsing.setPES_SubIdField(byArray, n, n6, n9, n4);
                    this.updateSCR(n7);
                    this.setSCRField(this.PackHeader);
                    this.writePacket(jobProcessing, this.PackHeader);
                    this.writePacket(jobProcessing, byArray, n, n7);
                    return;
                }
                n8 = n6 + n9;
                CommonParsing.setPES_LengthField(byArray, n, n5 += 4);
                CommonParsing.setValue(this.subID, n, 1, false, n4);
                this.updateSCR(n7 += 4);
                this.setSCRField(this.PackHeader);
                this.writePacket(jobProcessing, this.PackHeader);
                this.writePacket(jobProcessing, byArray, n, n8);
                this.writePacket(jobProcessing, this.subID, n, this.subID.length);
                this.writePacket(jobProcessing, byArray, n8 + n, n7 - n8 - this.subID.length);
                return;
            }
            if (!this.ContainsVideo) {
                if (n2 == 3) {
                    this.ContainsVideo = true;
                } else {
                    this.PaddingStreamPositions.add(String.valueOf(jobProcessing.getAllMediaFilesExportLength() + 17L));
                }
            }
            if (n2 == 3 && bl2 && this.AddPcrToStream) {
                int n11 = n6 + n9 + n;
                while (n11 < n7 - 6 + n) {
                    int n12 = CommonParsing.validateStartcode(byArray, n11);
                    if (n12 < 0 || CommonParsing.getPES_IdField(byArray, n11) != 0) {
                        n11 += (n12 < 0 ? -n12 : 4) - 1;
                    } else {
                        int n13 = 7 & byArray[n11 + 5] >>> 3;
                        if (n13 != 1) break;
                        this.SCR_Value = CommonParsing.getPTSfromBytes(byArray, n6 + n);
                        this.updateSCR(-this.PCR_Delta);
                        this.setSCRField(this.PackHeader);
                        if (this.LeadingPackHeader[2] == 0) {
                            System.arraycopy(this.PackHeader, 0, this.LeadingPackHeader, 0, this.PackHeader.length);
                        }
                        this.writePacket(jobProcessing, this.PackHeader);
                        bl = true;
                        break;
                    }
                    ++n11;
                }
            }
            if (!bl) {
                this.updateSCR(n7);
                this.setSCRField(this.PackHeader);
                this.writePacket(jobProcessing, this.PackHeader);
            }
            this.writePacket(jobProcessing, byArray, n, n7);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void packetizeToPVA(JobProcessing jobProcessing, byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer) {
        try {
            int n2 = streamDemultiplexer.getType();
            int n3 = streamDemultiplexer.getStreamType();
            int n4 = streamDemultiplexer.getnewID();
            if (CommonParsing.validateStartcode(byArray, n) < 0) {
                Common.setMessage("!> invalid startcode " + this.Packet + ", pos: " + jobProcessing.getLastHeaderBytePosition() + " (" + Integer.toHexString(n4) + "/" + n2 + ")");
                return;
            }
            int n5 = CommonParsing.getPES_LengthField(byArray, n);
            int n6 = 9;
            int n7 = n6 - 3 + n5;
            int n8 = 0;
            int n9 = 3;
            if (n7 + n > byArray.length) {
                return;
            }
            int n10 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
            boolean bl = CommonParsing.clearBit33ofPTS(byArray, n);
            CommonParsing.clearBit33ofDTS(byArray, n);
            switch (n2) {
                case 0: 
                case 1: 
                case 6: {
                    if (this.ExportNonVideo) break;
                    return;
                }
                case 2: {
                    if (!this.ExportNonVideo) {
                        return;
                    }
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    break;
                }
                case 3: {
                    if (!this.ExportVideo || (0xFF & n4) != 224) {
                        return;
                    }
                    int n11 = n6 + n10 + n;
                    while (!this.ContainsVideo && n11 < n7 - 4 + n) {
                        if (byArray[n11] == 0 && byArray[1 + n11] == 0 && byArray[2 + n11] == 1 && byArray[3 + n11] == -77) {
                            this.ContainsVideo = true;
                        }
                        ++n11;
                    }
                    if (this.MustStartWithVideo && !this.ContainsVideo) {
                        return;
                    }
                    n8 = n6;
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    if (bl) {
                        long l = CommonParsing.getPTSfromBytes(byArray, n8 + n);
                        n5 = n7 - (n8 += n10);
                        CommonParsing.setValue(this.PvaPacketHeaderAndPTS, 2, 1, false, 1L);
                        CommonParsing.setValue(this.PvaPacketHeaderAndPTS, 3, 1, false, 0xFF & this.PacketCounter[1]);
                        CommonParsing.setValue(this.PvaPacketHeaderAndPTS, 6, 2, false, n5 + 4);
                        CommonParsing.setValue(this.PvaPacketHeaderAndPTS, 8, 4, false, l);
                        this.writePacket(jobProcessing, this.PvaPacketHeaderAndPTS);
                    } else {
                        n5 = n7 - (n8 += n10);
                        CommonParsing.setValue(this.PvaPacketHeader, 2, 1, false, 1L);
                        CommonParsing.setValue(this.PvaPacketHeader, 3, 1, false, 0xFF & this.PacketCounter[1]);
                        CommonParsing.setValue(this.PvaPacketHeader, 5, 1, false, 0L);
                        CommonParsing.setValue(this.PvaPacketHeader, 6, 2, false, n5);
                        this.writePacket(jobProcessing, this.PvaPacketHeader);
                    }
                    this.writePacket(jobProcessing, byArray, n8 + n, n5);
                    this.PacketCounter[1] = this.PacketCounter[1] + 1;
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.MustStartWithVideo && !this.ContainsVideo) {
                return;
            }
            switch (n4) {
                case 192: {
                    CommonParsing.setValue(this.PvaPacketHeader, 2, 1, false, 2L);
                    CommonParsing.setValue(this.PvaPacketHeader, 3, 1, false, 0xFF & this.PacketCounter[2]);
                    CommonParsing.setValue(this.PvaPacketHeader, 5, 1, false, 16L);
                    CommonParsing.setValue(this.PvaPacketHeader, 6, 2, false, n7);
                    this.PacketCounter[2] = this.PacketCounter[2] + 1;
                    this.writePacket(jobProcessing, this.PvaPacketHeader);
                    this.writePacket(jobProcessing, byArray, n, n7);
                    return;
                }
            }
            switch (0xF0 & n4) {
                case 144: {
                    n9 = n4 - 140;
                    break;
                }
                case 128: {
                    n9 = n4 - 108;
                    break;
                }
                case 192: 
                case 208: {
                    n9 = n4 - 156;
                }
            }
            CommonParsing.setValue(this.PvaPacketHeader, 2, 1, false, n4);
            CommonParsing.setValue(this.PvaPacketHeader, 3, 1, false, 0xFF & this.PacketCounter[n9]);
            CommonParsing.setValue(this.PvaPacketHeader, 5, 1, false, 16L);
            int n12 = n9;
            this.PacketCounter[n12] = this.PacketCounter[n12] + 1;
            if ((n2 == 0 || n2 == 6) && n3 == 3) {
                CommonParsing.setPES_LengthField(byArray, n, n5 -= 4);
                CommonParsing.setValue(this.PvaPacketHeader, 6, 2, false, n7 - 4);
                n8 = n6 + n10;
                this.writePacket(jobProcessing, this.PvaPacketHeader);
                this.writePacket(jobProcessing, byArray, n, n8);
                this.writePacket(jobProcessing, byArray, (n8 += 4) + n, n7 - n8);
                return;
            }
            CommonParsing.setValue(this.PvaPacketHeader, 6, 2, false, n7);
            this.writePacket(jobProcessing, this.PvaPacketHeader);
            this.writePacket(jobProcessing, byArray, n, n7);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void packetizeToTS(JobProcessing jobProcessing, byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer, boolean bl) {
        try {
            int n2;
            int n3;
            boolean bl2 = false;
            boolean bl3 = false;
            long l = 0L;
            long l2 = 0L;
            int n4 = streamDemultiplexer.getType();
            int n5 = streamDemultiplexer.getStreamType();
            int n6 = streamDemultiplexer.getnewID();
            if (CommonParsing.validateStartcode(byArray, n) < 0) {
                Common.setMessage("!> invalid startcode " + this.Packet + ", pos: " + jobProcessing.getLastHeaderBytePosition() + " (" + Integer.toHexString(n6) + "/" + n4 + ")");
                return;
            }
            int n7 = CommonParsing.getPES_LengthField(byArray, n);
            int n8 = 9;
            int n9 = n8 - 3 + n7;
            int n10 = 0;
            int n11 = 3;
            if (n9 + n > byArray.length) {
                return;
            }
            int n12 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
            boolean bl4 = CommonParsing.clearBit33ofPTS(byArray, n);
            CommonParsing.clearBit33ofDTS(byArray, n);
            switch (n4) {
                case 0: 
                case 6: {
                    if (this.ExportNonVideo) break;
                    return;
                }
                case 2: {
                    if (this.ExportNonVideo) break;
                    return;
                }
                case 1: {
                    if (this.ExportNonVideo) break;
                    return;
                }
                case 3: {
                    if (this.ExportVideo && (0xFF & n6) == 224) break;
                    return;
                }
                case 5: {
                    if (this.ExportNonVideo && Common.getSettings().getBooleanProperty("HiddenKey.TSExport.Subpicture", false)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (!bl && n4 != 3 && !this.ContainsVideo && this.MustStartWithVideo) {
                return;
            }
            if ((n4 == 0 || n4 == 6) && n5 == 3) {
                n10 = n8 + n12 + 4;
                System.arraycopy(byArray, n10 + n, byArray, n8 + n12 + n, n9 - n10);
                n9 -= 4;
                CommonParsing.setPES_LengthField(byArray, n, n7 -= 4);
            }
            int n13 = 0;
            while (n13 < this.IDs.size()) {
                if (n6 == (0xFF & Integer.parseInt(this.IDs.get(n13).toString()))) break;
                ++n13;
            }
            if (n13 == this.IDs.size()) {
                n3 = n6;
                if (n3 < 144) {
                    n3 |= 0x200;
                }
                if (n3 < 192) {
                    n3 |= 0x300;
                }
                if (n3 < 224) {
                    n3 |= 0x100;
                }
                if (!bl) {
                    if (n4 != 1 && n4 != 5 && !CommonParsing.alignSyncword(byArray, n, n4)) {
                        return;
                    }
                    n7 = CommonParsing.getPES_LengthField(byArray, n);
                    n9 = n8 - 3 + n7;
                }
                this.IDs.add(String.valueOf(n3));
            }
            CommonParsing.setValue(this.TsStartPacketHeader, 2, 1, false, n6);
            CommonParsing.setValue(this.TsSubPacketHeader, 2, 1, false, n6);
            if (n4 == 3) {
                CommonParsing.setPES_LengthField(byArray, n, 0);
            }
            if (this.FirstPacket) {
                this.Buffer.write(TS.init(jobProcessing, this.FileName, this.SetMainAudioAc3, this.GenerateTTX, this.TsHeaderMode));
                this.FirstPacket = false;
            }
            if (bl4 && TS.getfirstID() == (0xFF & n6)) {
                l2 = CommonParsing.getPTSfromBytes(byArray, n8 + n);
                l = l2 - this.PCR_Delta;
                if ((l2 & 0xFF000000L) == 0xFF000000L) {
                    this.ptsover = true;
                }
                if (this.ptsover && l2 < 0xF0000000L) {
                    l2 |= 0x100000000L;
                }
                this.time[1] = l2;
                bl2 = true;
                if (this.time[0] == -1L) {
                    this.time[0] = this.time[1];
                }
            }
            block8 : switch (0xF0 & n6) {
                case 128: {
                    n11 = n6 - 108;
                    break;
                }
                case 144: {
                    n11 = n6 - 140;
                    break;
                }
                case 192: 
                case 208: {
                    n11 = n6 - 156;
                    break;
                }
                case 224: {
                    n11 = 1;
                    if (!bl4) break;
                    bl2 = false;
                    n3 = n8 + n12 + n;
                    while (n3 < n9 - 6 + n) {
                        int n14 = CommonParsing.validateStartcode(byArray, n3);
                        if (n14 < 0 || CommonParsing.getPES_IdField(byArray, n3) != 0) {
                            n3 += (n14 < 0 ? -n14 : 4) - 1;
                        } else {
                            n2 = 7 & byArray[n3 + 5] >>> 3;
                            if (n2 == 1) {
                                bl2 = true;
                                this.ContainsVideo = true;
                            }
                            if (n2 != 1 && n2 != 2) break block8;
                            bl3 = true;
                            break block8;
                        }
                        ++n3;
                    }
                    break;
                }
            }
            if (n4 == 3 && !this.ContainsVideo && this.MustStartWithVideo) {
                return;
            }
            if (30000L * this.PmtCounter <= jobProcessing.getAllMediaFilesExportLength()) {
                this.Buffer.write(TS.getPAT());
                if (this.GeneratePMT) {
                    this.Buffer.write(TS.getAutoPMT());
                } else {
                    this.Buffer.write(TS.getPMT());
                }
                ++this.PmtCounter;
            }
            if (this.GenerateTTX && bl3) {
                this.Buffer.write(TS.getTeletextStream(this.time[1]));
            }
            if (bl2 && this.AddPcrToStream) {
                if (!this.PcrCounter) {
                    this.Buffer.write(TS.getPCR(l, this.PacketCounter[n11], 0xFF & n6));
                } else {
                    int n15 = n11;
                    int n16 = this.PacketCounter[n15] + 1;
                    this.PacketCounter[n15] = n16;
                    this.Buffer.write(TS.getPCR(l, n16, 0xFF & n6));
                }
            }
            n3 = 0;
            while (n3 < n9) {
                if (n3 == 0) {
                    if (n9 - n3 < 183) {
                        int n17 = n11;
                        int n18 = this.PacketCounter[n17] + 1;
                        this.PacketCounter[n17] = n18;
                        this.TsStartPacketHeader[3] = (byte)(0x30 | 0xF & n18);
                        n2 = 182 - (n9 - n3);
                        this.adapt[0] = (byte)(n2 + 1);
                        this.Buffer.write(this.TsStartPacketHeader);
                        this.Buffer.write(this.adapt);
                        this.Buffer.write(this.StuffingData, 6, n2);
                        this.Buffer.write(byArray, n3 + n, n9 - n3);
                        n3 += n9 - n3;
                    } else if (n9 - n3 == 184) {
                        int n19 = n11;
                        int n20 = this.PacketCounter[n19] + 1;
                        this.PacketCounter[n19] = n20;
                        this.TsStartPacketHeader[3] = (byte)(0x10 | 0xF & n20);
                        this.Buffer.write(this.TsStartPacketHeader);
                        this.Buffer.write(byArray, n3 + n, 184);
                        n3 += 184;
                    } else if (n9 - n3 < 185) {
                        int n21 = n11;
                        int n22 = this.PacketCounter[n21] + 1;
                        this.PacketCounter[n21] = n22;
                        this.TsStartPacketHeader[3] = (byte)(0x30 | 0xF & n22);
                        this.adapt[0] = 1;
                        this.Buffer.write(this.TsStartPacketHeader);
                        this.Buffer.write(this.adapt);
                        this.Buffer.write(byArray, n3 + n, 182);
                        n3 += 182;
                    } else {
                        int n23 = n11;
                        int n24 = this.PacketCounter[n23] + 1;
                        this.PacketCounter[n23] = n24;
                        this.TsStartPacketHeader[3] = (byte)(0x10 | 0xF & n24);
                        this.Buffer.write(this.TsStartPacketHeader);
                        this.Buffer.write(byArray, n3 + n, 184);
                        n3 += 184;
                    }
                } else if (n9 - n3 < 183) {
                    int n25 = n11;
                    int n26 = this.PacketCounter[n25] + 1;
                    this.PacketCounter[n25] = n26;
                    this.TsSubPacketHeader[3] = (byte)(0x30 | 0xF & n26);
                    n2 = 182 - (n9 - n3);
                    this.adapt[0] = (byte)(n2 + 1);
                    this.Buffer.write(this.TsSubPacketHeader);
                    this.Buffer.write(this.adapt);
                    this.Buffer.write(this.StuffingData, 6, n2);
                    this.Buffer.write(byArray, n3 + n, n9 - n3);
                    n3 += n9 - n3;
                } else if (n9 - n3 == 184) {
                    int n27 = n11;
                    int n28 = this.PacketCounter[n27] + 1;
                    this.PacketCounter[n27] = n28;
                    this.TsSubPacketHeader[3] = (byte)(0x10 | 0xF & n28);
                    this.Buffer.write(this.TsSubPacketHeader);
                    this.Buffer.write(byArray, n3 + n, 184);
                    n3 += 184;
                } else if (n9 - n3 < 185) {
                    int n29 = n11;
                    int n30 = this.PacketCounter[n29] + 1;
                    this.PacketCounter[n29] = n30;
                    this.TsSubPacketHeader[3] = (byte)(0x30 | 0xF & n30);
                    this.adapt[0] = 1;
                    this.Buffer.write(this.TsSubPacketHeader);
                    this.Buffer.write(this.adapt);
                    this.Buffer.write(byArray, n3 + n, 182);
                    n3 += 182;
                } else {
                    int n31 = n11;
                    int n32 = this.PacketCounter[n31] + 1;
                    this.PacketCounter[n31] = n32;
                    this.TsSubPacketHeader[3] = (byte)(0x10 | 0xF & n32);
                    this.Buffer.write(this.TsSubPacketHeader);
                    this.Buffer.write(byArray, n3 + n, 184);
                    n3 += 184;
                }
                jobProcessing.countMediaFilesExportLength(188L);
                jobProcessing.countAllMediaFilesExportLength(188L);
            }
            this.Buffer.writeTo(this.OutputStream);
            this.Buffer.reset();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void packetizeToVDR(JobProcessing jobProcessing, byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer) {
        try {
            int n2 = streamDemultiplexer.getType();
            int n3 = streamDemultiplexer.getStreamType();
            int n4 = streamDemultiplexer.getnewID();
            if (CommonParsing.validateStartcode(byArray, n) < 0) {
                Common.setMessage("!> invalid startcode " + this.Packet + ", pos: " + jobProcessing.getLastHeaderBytePosition() + " (" + Integer.toHexString(n4) + "/" + n2 + ")");
                return;
            }
            int n5 = CommonParsing.getPES_LengthField(byArray, n);
            int n6 = 9;
            int n7 = n6 - 3 + n5;
            int n8 = 0;
            if (n7 + n > byArray.length) {
                return;
            }
            int n9 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
            boolean bl = CommonParsing.clearBit33ofPTS(byArray, n);
            CommonParsing.clearBit33ofDTS(byArray, n);
            switch (n2) {
                case 0: 
                case 6: {
                    if (!this.ExportNonVideo || (0xFF & n4) != 128) {
                        return;
                    }
                    if (n3 != 3) break;
                    CommonParsing.setPES_LengthField(byArray, n, n5 -= 4);
                    n8 = n6 + n9;
                    this.writePacket(jobProcessing, byArray, n, n8);
                    n8 += 4;
                    break;
                }
                case 2: {
                    if (!this.ExportNonVideo) {
                        return;
                    }
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    break;
                }
                case 1: {
                    if (!this.ExportNonVideo || (0x7F & n4) > 31) {
                        return;
                    }
                    CommonParsing.setPES_SubIdField(byArray, n, n6, n9, n4 - 128);
                    break;
                }
                case 3: {
                    if (!this.ExportVideo) {
                        return;
                    }
                    CommonParsing.setPES_IdField(byArray, n, n4);
                    if (!bl) break;
                    this.remuxPES(jobProcessing, CommonParsing.getPTSfromBytes(byArray, n6 + n));
                    break;
                }
                default: {
                    return;
                }
            }
            this.writePacket(jobProcessing, byArray, n8 + n, n7 - n8);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private void remuxPES(JobProcessing jobProcessing, long l) {
        if (!this.MuxPES) {
            return;
        }
        int n = 0;
        int n2 = this.remuxList.size();
        while (n < n2) {
            Object[] objectArray = (Object[])this.remuxList.get(n);
            ArrayList arrayList = (ArrayList)objectArray[0];
            String string = objectArray[1].toString();
            int[] nArray = (int[])objectArray[2];
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
                int n3 = arrayList.size();
                while (nArray[0] < n3) {
                    long[] lArray = (long[])arrayList.get(nArray[0]);
                    if (l < lArray[0]) break;
                    if (l <= lArray[0] + 43200L) {
                        byte[] byArray = new byte[(int)lArray[2]];
                        randomAccessFile.seek(lArray[1]);
                        randomAccessFile.read(byArray);
                        this.writePacket(jobProcessing, byArray);
                    }
                    nArray[0] = nArray[0] + 1;
                }
                randomAccessFile.close();
            }
            catch (Exception exception) {
                Common.setExceptionMessage(exception);
            }
            ++n;
        }
    }

    private void repackMpg1(byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer) {
        if (streamDemultiplexer.getStreamType() != 2) {
            return;
        }
        int n2 = 6;
        int n3 = 9;
        int n4 = 0;
        int n5 = CommonParsing.getPES_LengthField(byArray, n);
        int n6 = n2 + n5;
        int n7 = n2;
        int n8 = 0x800000;
        block11: while (true) {
            switch (0xC0 & byArray[n7 + n]) {
                case 64: {
                    n7 += 2;
                    continue block11;
                }
                case 128: {
                    n7 += 3;
                    continue block11;
                }
                case 192: {
                    ++n7;
                    continue block11;
                }
            }
            switch (0x30 & byArray[n7 + n]) {
                default: {
                    continue block11;
                }
                case 32: {
                    n4 = 5;
                    break block11;
                }
                case 48: {
                    n4 = 10;
                    break block11;
                }
                case 16: {
                    n7 += 5;
                    break block11;
                }
                case 0: {
                    ++n7;
                    break block11;
                }
            }
            break;
        }
        if (n4 == 5) {
            n8 = 0x808005;
        } else if (n4 == 10) {
            n8 = 8437770;
        }
        System.arraycopy(byArray, n7 + n, byArray, n3 + n, n6 - n7);
        CommonParsing.setValue(byArray, n2 + n, 3, false, n8);
        CommonParsing.setPES_LengthField(byArray, n, n6 - n7 + 3);
    }

    private void scanSecondaryStreams(JobCollection jobCollection) {
        if (!this.MuxPES) {
            return;
        }
        try {
            int n = jobCollection.getPrimaryInputFileSegments();
            int n2 = jobCollection.getInputFilesCount();
            while (n < n2) {
                XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(n);
                if (xInputFile.getStreamInfo().getStreamType() == 7) {
                    int n3 = 0;
                    long[] lArray = new long[2];
                    long l = 0L;
                    ArrayList<long[]> arrayList = new ArrayList<long[]>();
                    byte[] byArray = new byte[65552];
                    int n4 = 9;
                    int n5 = 6;
                    int n6 = 0;
                    int n7 = 0;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = xInputFile.length();
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(xInputFile.getInputStream(l2), byArray.length);
                    Common.setMessage("-> scanning for remux: " + xInputFile.getName());
                    Common.updateProgressBar(" scanning for remux: " + xInputFile.getName(), l3, l4);
                    block3: while (l3 < l4) {
                        Common.updateProgressBar(l3, l4);
                        while (Common.waitingMainProcess()) {
                        }
                        pushbackInputStream.read(byArray, 0, n5);
                        n7 = CommonParsing.getPES_IdField(byArray, 0);
                        n6 = CommonParsing.validateStartcode(byArray, 0);
                        if (n6 < 0) {
                            int n8;
                            n6 = n6 < 0 ? -n6 : 4;
                            pushbackInputStream.read(byArray, n5, byArray.length - n5);
                            for (n8 = n6; n8 < byArray.length - 3; n8 += -n6) {
                                n6 = CommonParsing.validateStartcode(byArray, n8);
                                if (n6 < 0) {
                                    continue;
                                }
                                pushbackInputStream.unread(byArray, n8, byArray.length - n8);
                                l3 += (long)n8;
                                continue block3;
                            }
                            pushbackInputStream.unread(byArray, n8, byArray.length - n8);
                            l3 += (long)n8;
                            continue;
                        }
                        if (n7 != 189) continue;
                        int n9 = CommonParsing.getPES_LengthField(byArray, 0);
                        pushbackInputStream.read(byArray, n5, n9);
                        int n10 = n5 + n9;
                        int n11 = CommonParsing.getPES_ExtensionLengthField(byArray, 0);
                        if (CommonParsing.clearBit33ofPTS(byArray, 0)) {
                            l = CommonParsing.getPTSfromBytes(byArray, n4);
                        }
                        ++n3;
                        arrayList.add(new long[]{l, l3, n10});
                        l3 += (long)n10;
                    }
                    pushbackInputStream.close();
                    this.remuxList.add(new Object[]{arrayList, xInputFile.toString(), new int[1]});
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void setBrokenLink(JobProcessing jobProcessing, byte[] byArray, int n) {
        int n2;
        if (CommonParsing.validateStartcode(byArray, n) < 0) {
            Common.setMessage("!> invalid start_code of packet (sbl), pos: " + jobProcessing.getLastHeaderBytePosition());
            return;
        }
        int n3 = CommonParsing.getPES_LengthField(byArray, n);
        int n4 = 9;
        int n5 = n4 - 3 + n3;
        int n6 = CommonParsing.getPES_ExtensionLengthField(byArray, n);
        int n7 = n5 - 7 + n;
        for (int i = n4 + n6 + n; i < n7; i += n2 < 0 ? -n2 : 4) {
            n2 = CommonParsing.validateStartcode(byArray, i);
            if (n2 < 0 || CommonParsing.getPES_IdField(byArray, i) != 184) {
                continue;
            }
            int n8 = 7 + i;
            byArray[n8] = (byte)(byArray[n8] | 0x20);
            break;
        }
        this.BrokenLinkFlag = true;
    }

    private void setSCRField(byte[] byArray) {
        if (this.Debug) {
            System.out.println("SCR_Value " + this.SCR_Value);
        }
        if (!this.AddPcrToStream) {
            return;
        }
        byArray[4] = (byte)(0x44L | 3L & this.SCR_Value >>> 28 | 0x38L & this.SCR_Value >>> 27);
        byArray[5] = (byte)(0xFFL & this.SCR_Value >>> 20);
        byArray[6] = (byte)(4L | 3L & this.SCR_Value >>> 13 | 0xF8L & this.SCR_Value >>> 12);
        byArray[7] = (byte)(0xFFL & this.SCR_Value >>> 5);
        byArray[8] = (byte)(4L | 0xF8L & this.SCR_Value << 3);
    }

    private void updateSCR(int n) {
        this.SCR_Value += (long)(n * 8 / 150);
    }

    private void updateSCR(long l) {
        this.SCR_Value += l;
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, int n, int n2, StreamDemultiplexer streamDemultiplexer, long l, boolean bl, List list) throws IOException {
        if (this.CutMode == 0 && !bl && !CommonParsing.makecut(jobProcessing, l + 5L, list)) {
            this.BrokenLinkFlag = false;
            return;
        }
        if (this.Action == 5) {
            this.writePacket(jobProcessing, byArray, n, n2);
            return;
        }
        this.repackMpg1(byArray, n, streamDemultiplexer);
        if (streamDemultiplexer.getType() == 3 && !this.BrokenLinkFlag) {
            this.setBrokenLink(jobProcessing, byArray, n);
        }
        if (this.Buffer.size() != 0) {
            this.Buffer.reset();
        }
        switch (this.Action) {
            case 1: {
                this.packetizeToVDR(jobProcessing, byArray, n, streamDemultiplexer);
                return;
            }
            case 2: {
                this.packetizeToM2P(jobProcessing, byArray, n, streamDemultiplexer);
                return;
            }
            case 3: {
                this.packetizeToPVA(jobProcessing, byArray, n, streamDemultiplexer);
                return;
            }
            case 4: {
                this.packetizeToTS(jobProcessing, byArray, n, streamDemultiplexer, bl);
                return;
            }
        }
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, int n, StreamDemultiplexer streamDemultiplexer, long l, boolean bl, List list) throws IOException {
        this.write(jobProcessing, byArray, n, byArray.length, streamDemultiplexer, l, bl, list);
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, StreamDemultiplexer streamDemultiplexer, long l, boolean bl, List list) throws IOException {
        this.write(jobProcessing, byArray, 0, byArray.length, streamDemultiplexer, l, bl, list);
    }

    public void writePacket(JobProcessing jobProcessing, byte[] byArray) throws IOException {
        this.writePacket(jobProcessing, byArray, 0, byArray.length);
    }

    public void writePacket(JobProcessing jobProcessing, byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n >= byArray.length) {
            Common.setMessage("!> packet writing: index out of bounds, ignore it.. (" + this.Packet + ")");
            return;
        }
        if (n + n2 > byArray.length) {
            Common.setMessage("!> packet writing: length index out of bounds, shortened.. (" + this.Packet + ")");
            n2 = byArray.length - n;
        }
        this.OutputStream.write(byArray, n, n2);
        jobProcessing.countMediaFilesExportLength(n2);
        jobProcessing.countAllMediaFilesExportLength(n2);
    }
}

