/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class UnicodeWriter {
    private DataOutputStream out1;
    private PrintWriter out2;
    private boolean useUnicode = false;
    private boolean useUTF8 = false;
    private short mask_1 = (short)-128;
    private short mask_2 = (short)-2048;

    private UnicodeWriter() {
    }

    public UnicodeWriter(ByteArrayOutputStream byteArrayOutputStream, boolean bl, boolean bl2) {
        this.useUnicode = bl || bl2;
        this.useUTF8 = bl2;
        if (this.useUnicode) {
            this.out1 = new DataOutputStream(byteArrayOutputStream);
        } else {
            this.out2 = new PrintWriter(byteArrayOutputStream, true);
        }
    }

    public void close() throws IOException {
        if (this.useUnicode) {
            this.out1.close();
        } else {
            this.out2.close();
        }
    }

    public void flush() throws IOException {
        if (this.useUnicode) {
            this.out1.flush();
        } else {
            this.out2.flush();
        }
    }

    public void print(String string) throws IOException {
        if (!this.useUnicode) {
            this.out2.print(string);
            return;
        }
        if (this.useUTF8) {
            if (this.out1.size() == 0) {
                this.out1.write(new byte[]{-17, -69, -65}, 0, 3);
            }
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                if ((this.mask_1 & cArray[n]) == 0) {
                    this.out1.writeByte(cArray[n]);
                } else if ((this.mask_2 & cArray[n]) == 0) {
                    this.out1.writeShort(0xC080 | 0x1F00 & cArray[n] << 2 | 0x3F & cArray[n]);
                } else {
                    this.out1.writeByte(0xE0 | 0xF0000 & cArray[n] << 4);
                    this.out1.writeShort(0x8080 | 0x3F00 & cArray[n] << 2 | 0x3F & cArray[n]);
                }
                ++n;
            }
            return;
        }
        if (this.out1.size() == 0) {
            this.out1.writeChar(65279);
        }
        this.out1.writeChars(string);
    }

    public void println() throws IOException {
        if (this.useUnicode) {
            this.print(System.getProperty("line.separator"));
        } else {
            this.out2.println();
        }
    }

    public void println(String string) throws IOException {
        if (this.useUnicode) {
            this.print(string);
            this.print(System.getProperty("line.separator"));
        } else {
            this.out2.println(string);
        }
    }
}

