/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public final class XMLUtil {
    public static final String ENCODING = "UTF-8";

    private XMLUtil() {
    }

    public static void writePrologue(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>");
    }

    public static void checkValidPrologue(BufferedReader bufferedReader) throws Exception {
        String string = XMLUtil.nextDataLine(bufferedReader);
        if (string == null || !string.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"")) {
            throw new Exception("Ung\u00fcltiger Dateianfang: " + string);
        }
    }

    public static String nextDataLine(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            return null;
        } while ((string = string.trim()).length() <= 0 || string.startsWith("<!--"));
        return string;
    }

    public static String getValue(String string, boolean bl) throws Exception {
        int n = string.indexOf(62);
        int n2 = string.lastIndexOf(60);
        if (n < 0 || n >= n2) {
            throw new Exception("Ung\u00fcltiges Element: " + string);
        }
        String string2 = string.substring(n + 1, n2);
        if (bl && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static long getLongValue(String string) throws Exception {
        return Long.parseLong(XMLUtil.getValue(string, true));
    }

    public static int getIntValue(String string) throws Exception {
        return Integer.parseInt(XMLUtil.getValue(string, true));
    }

    public static void writeComment(PrintWriter printWriter, String string) {
        printWriter.println("<!-- " + XMLUtil.escapeString(string) + " -->");
    }

    public static String escapeString(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '<': {
                    string = String.valueOf(string.substring(0, n2)) + "&lt;" + string.substring(n2 + 1);
                    n += 3;
                    n2 += 4;
                    break;
                }
                case '>': {
                    string = String.valueOf(string.substring(0, n2)) + "&gt;" + string.substring(n2 + 1);
                    n += 3;
                    n2 += 4;
                    break;
                }
                case '&': {
                    string = String.valueOf(string.substring(0, n2)) + "&amp;" + string.substring(n2 + 1);
                    n += 4;
                    n2 += 5;
                    break;
                }
                default: {
                    ++n2;
                    break;
                }
            }
        }
        return string;
    }

    public static String unescapeString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '&') {
                if (n2 + 3 < n && string.charAt(n2 + 1) == 'g' && string.charAt(n2 + 2) == 't' && string.charAt(n2 + 3) == ';') {
                    string = String.valueOf(string.substring(0, n2)) + ">" + string.substring(n2 + 4);
                    n -= 3;
                } else if (n2 + 3 < n && string.charAt(n2 + 1) == 'l' && string.charAt(n2 + 2) == 't' && string.charAt(n2 + 3) == ';') {
                    string = String.valueOf(string.substring(0, n2)) + "<" + string.substring(n2 + 4);
                    n -= 3;
                } else if (n2 + 4 < n && string.charAt(n2 + 1) == 'a' && string.charAt(n2 + 2) == 'm' && string.charAt(n2 + 3) == 'p' && string.charAt(n2 + 4) == ';') {
                    string = String.valueOf(string.substring(0, n2)) + "&" + string.substring(n2 + 5);
                    n -= 4;
                }
            }
            ++n2;
        }
        return string;
    }
}

