/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextAreaEditingTool
extends AbstractTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolderFigure typingTarget;

    public TextAreaEditingTool(TextHolderFigure typingTarget) {
        this.typingTarget = typingTarget;
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.typingTarget != null) {
            this.beginEdit(this.typingTarget);
            this.updateCursor(this.getView(), e.getPoint());
        }
    }

    @Override
    public void draw(Graphics2D g) {
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolder);
        this.textArea.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle2D.Double getFieldBounds(TextHolderFigure figure) {
        Rectangle2D.Double r = figure.getDrawingArea();
        Insets2D.Double insets = figure.getInsets();
        insets.subtractTo(r);
        r.x -= 1.0;
        r.y -= 2.0;
        r.width += 18.0;
        r.height += 4.0;
        return r;
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure editedFigure = this.typingTarget;
            final String oldText = this.typingTarget.getText();
            final String newText = this.textArea.getText();
            if (newText.length() > 0) {
                this.typingTarget.setText(newText);
            } else {
                this.typingTarget.setText("");
            }
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("attribute.text.text");
                }

                @Override
                public void undo() {
                    super.undo();
                    editedFigure.willChange();
                    editedFigure.setText(oldText);
                    editedFigure.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    editedFigure.willChange();
                    editedFigure.setText(newText);
                    editedFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(edit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

