/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class PickAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public PickAttributesAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, "edit.pickAttributes");
        this.setEnabled(true);
    }

    public void setExcludedAttributes(Set<AttributeKey> a) {
        this.excludedAttributes = a;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pickAttributes();
    }

    public void pickAttributes() {
        DrawingEditor editor = this.getEditor();
        Set<Figure> selection = this.getView().getSelectedFigures();
        if (selection.size() > 0) {
            Figure figure = (Figure)selection.iterator().next();
            for (Map.Entry<AttributeKey, Object> entry : figure.getAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                editor.setDefaultAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

