/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
import org.jhotdraw.xml.DefaultDOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

public class DefaultDOMStorableSample {
    public static void main(String[] args) {
        try {
            DefaultDOMFactory factory = new DefaultDOMFactory();
            factory.addStorableClass("MyElementName", MyObject.class);
            MyObject obj = new MyObject("Hello World");
            System.out.println("The name of the original object is:" + obj.getName());
            NanoXMLDOMOutput out = new NanoXMLDOMOutput(factory);
            out.writeObject(obj);
            StringWriter writer = new StringWriter();
            out.save(writer);
            String serializedString = writer.toString();
            System.out.println("\nThe serialized representation of the object is:\n" + serializedString);
            StringReader reader = new StringReader(serializedString);
            NanoXMLDOMInput in = new NanoXMLDOMInput((DOMFactory)factory, reader);
            MyObject obj2 = (MyObject)in.readObject();
            System.out.println("\nThe name of the restored object is:" + obj2.getName());
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultDOMStorableSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class MyObject
    implements DOMStorable {
        private String name;

        public MyObject() {
        }

        public MyObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void write(DOMOutput out) throws IOException {
            out.addAttribute("name", this.name);
        }

        @Override
        public void read(DOMInput in) throws IOException {
            this.name = in.getAttribute("name", null);
        }
    }
}

