/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.draw.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.net.NetFactory;
import org.jhotdraw.samples.net.figures.NodeFigure;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class NetView
extends AbstractView {
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private AbstractButton toggleGridButton;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    @Override
    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NetView.this.setHasUnsavedChanges(NetView.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        this.toggleGridButton = pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "view.toggleGrid.placard");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
        this.toggleGridButton.setSelected(this.preferences.getBoolean("view.gridVisible", false));
        this.view.setScaleFactor(this.preferences.getDouble("view.scaleFactor", 1.0));
        this.view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("scaleFactor")) {
                    NetView.this.preferences.putDouble("view.scaleFactor", (Double)evt.getNewValue());
                    NetView.this.firePropertyChange("scaleFactor", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    public boolean isGridVisible() {
        return this.view.isConstrainerVisible();
    }

    public void setGridVisible(boolean newValue) {
        boolean oldValue = this.isGridVisible();
        this.view.setConstrainerVisible(newValue);
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, newValue);
    }

    protected Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new NetFactory());
        drawing.addInputFormat(ioFormat);
        drawing.addInputFormat(new TextInputFormat(new NodeFigure()));
        drawing.addOutputFormat(ioFormat);
        drawing.addOutputFormat(new ImageOutputFormat());
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    public double getScaleFactor() {
        return this.view.getScaleFactor();
    }

    public void setScaleFactor(double newValue) {
        this.view.setScaleFactor(newValue);
    }

    private void initActions() {
        this.putAction("edit.undo", this.undo.getUndoAction());
        this.putAction("edit.redo", this.undo.getRedoAction());
    }

    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    @Override
    public void write(File f) throws IOException {
        Drawing drawing = this.view.getDrawing();
        OutputFormat outputFormat = drawing.getOutputFormats().get(0);
        outputFormat.write(f, drawing);
    }

    @Override
    public void read(File f) throws IOException {
        try {
            final Drawing drawing = this.createDrawing();
            InputFormat inputFormat = drawing.getInputFormats().get(0);
            inputFormat.read(f, drawing, true);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    NetView.this.view.getDrawing().removeUndoableEditListener(NetView.this.undo);
                    NetView.this.view.setDrawing(drawing);
                    NetView.this.view.getDrawing().addUndoableEditListener(NetView.this.undo);
                    NetView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
    }

    public void setDrawingEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.remove(this.view);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.add(this.view);
        }
    }

    public DrawingEditor getDrawingEditor() {
        return this.editor;
    }

    @Override
    public void clear() {
        final Drawing newDrawing = this.createDrawing();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    NetView.this.view.getDrawing().removeUndoableEditListener(NetView.this.undo);
                    NetView.this.view.setDrawing(newDrawing);
                    NetView.this.view.getDrawing().addUndoableEditListener(NetView.this.undo);
                    NetView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected JFileChooser createOpenChooser() {
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram", "xml"));
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    protected JFileChooser createSaveChooser() {
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram", "xml"));
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    public boolean canSaveTo(File file) {
        return file.getName().endsWith(".xml");
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
    }
}

