/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.SelectionTool;

public class SelectionComponentDisplayer
implements PropertyChangeListener,
FigureSelectionListener {
    protected DrawingEditor editor;
    protected JComponent component;
    protected int minSelectionCount = 1;
    protected boolean isVisibleIfCreationTool = true;

    public SelectionComponentDisplayer(DrawingEditor editor, JComponent component) {
        this.editor = editor;
        this.component = component;
        if (editor.getActiveView() != null) {
            DrawingView view = editor.getActiveView();
            view.addPropertyChangeListener(this);
            view.addFigureSelectionListener(this);
        }
        editor.addPropertyChangeListener(this);
        this.updateVisibility();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "activeView") {
            DrawingView view = (DrawingView)evt.getOldValue();
            if (view != null) {
                view.removePropertyChangeListener(this);
                view.removeFigureSelectionListener(this);
            }
            if ((view = (DrawingView)evt.getNewValue()) != null) {
                view.addPropertyChangeListener(this);
                view.addFigureSelectionListener(this);
            }
            this.updateVisibility();
        } else if (name == "tool") {
            this.updateVisibility();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent evt) {
        this.updateVisibility();
    }

    public void updateVisibility() {
        boolean newValue = this.editor != null && this.editor.getActiveView() != null && (this.isVisibleIfCreationTool && this.editor.getTool() != null && !(this.editor.getTool() instanceof SelectionTool) || this.editor.getActiveView().getSelectionCount() >= this.minSelectionCount);
        this.component.setVisible(newValue);
        if (newValue) {
            this.component.setPreferredSize(null);
        } else {
            this.component.setPreferredSize(new Dimension(0, 0));
        }
        this.component.revalidate();
    }

    public void dispose() {
        if (this.editor != null) {
            if (this.editor.getActiveView() != null) {
                DrawingView view = this.editor.getActiveView();
                view.removePropertyChangeListener(this);
                view.removeFigureSelectionListener(this);
            }
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        this.component = null;
    }

    public void setMinSelectionCount(int newValue) {
        this.minSelectionCount = newValue;
        this.updateVisibility();
    }

    public void setVisibleIfCreationTool(boolean newValue) {
        this.isVisibleIfCreationTool = newValue;
    }
}

