/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.alert;

import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.calendar.CalendarEntry;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.CalendarFeed;
import com.google.gdata.data.extensions.Reminder;
import com.google.gdata.data.extensions.When;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.Utils;

public class GoogleCalendar {
    private static URL feedUrl = null;
    private static final Log log;

    public static boolean SMS(String username, String password, String message) {
        URL postUrl;
        CalendarFeed calendarFeed;
        CalendarService calendarService = new CalendarService("JStock");
        try {
            calendarService.setUserCredentials(username, password);
        }
        catch (AuthenticationException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        CalendarEntry calendarEntry = null;
        try {
            calendarFeed = (CalendarFeed)calendarService.getFeed(feedUrl, CalendarFeed.class);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        catch (ServiceException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        List calendarEntries = calendarFeed.getEntries();
        for (CalendarEntry ce : calendarEntries) {
            String title = ce.getTitle().getPlainText();
            if (!title.equalsIgnoreCase("JStock")) continue;
            calendarEntry = ce;
            break;
        }
        if (calendarEntry == null) {
            calendarEntry = new CalendarEntry();
            calendarEntry.setTitle((TextConstruct)new PlainTextConstruct("JStock"));
            calendarEntry.setSummary((TextConstruct)new PlainTextConstruct("For JStock SMS Alert Usage."));
            try {
                calendarEntry = (CalendarEntry)calendarService.insert(feedUrl, (IEntry)calendarEntry);
            }
            catch (IOException exp) {
                log.error(null, (Throwable)exp);
                return false;
            }
            catch (ServiceException exp) {
                log.error(null, (Throwable)exp);
                return false;
            }
        }
        String postUrlString = calendarEntry.getLink("alternate", "application/atom+xml").getHref();
        try {
            postUrl = new URL(postUrlString);
        }
        catch (MalformedURLException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        Calendar cstart = Calendar.getInstance();
        long now = Utils.getGoogleServerTimestamp();
        if (now == 0L) {
            now = System.currentTimeMillis();
        }
        Date start = new Date(now + 60000L);
        cstart.setTime(start);
        int second = cstart.get(13);
        if (60 - second < 30) {
            cstart.add(13, 60 - second);
            start = cstart.getTime();
        }
        Date end = new Date(start.getTime() + 60000L);
        DateTime startTime = new DateTime(start.getTime());
        DateTime endTime = new DateTime(end.getTime());
        When when = new When();
        when.setStartTime(startTime);
        when.setEndTime(endTime);
        CalendarEventEntry calendarEventEntry = new CalendarEventEntry();
        calendarEventEntry.setTitle((TextConstruct)new PlainTextConstruct(message));
        calendarEventEntry.setContent((TextConstruct)new PlainTextConstruct(message));
        calendarEventEntry.addTime(when);
        Reminder reminder = new Reminder();
        reminder.setMinutes(Integer.valueOf(0));
        reminder.setMethod(Reminder.Method.SMS);
        List reminders = calendarEventEntry.getReminder();
        reminders.add(reminder);
        try {
            calendarEventEntry = (CalendarEventEntry)calendarService.insert(postUrl, (IEntry)calendarEventEntry);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        catch (ServiceException exp) {
            log.error(null, (Throwable)exp);
            return false;
        }
        return true;
    }

    static {
        try {
            feedUrl = new URL("http://www.google.com/calendar/feeds/default/owncalendars/full");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        log = LogFactory.getLog(GoogleCalendar.class);
    }
}

