/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.network.Utils;

public class CurrencyExchangeMonitor
extends Subject<CurrencyExchangeMonitor, Double> {
    private static final Map<Country, String> countryToCurrencyCode = new EnumMap<Country, String>(Country.class);
    private static boolean successUpdatedCountryToCurrencyCode = false;
    private final Country fromCountry;
    private final Country toCountry;
    private List<StockServerFactory> stockServerFactories = new CopyOnWriteArrayList<StockServerFactory>();
    private volatile double exchangeRate = 1.0;
    private boolean suspend = false;
    private volatile boolean isRefresh = false;
    private boolean has_started = false;
    private final CurrencyExchangeThread currencyExchangeThread = new CurrencyExchangeThread();
    private static final Log log;

    public CurrencyExchangeMonitor(Country fromCountry, Country toCountry) {
        this.fromCountry = fromCountry;
        this.toCountry = toCountry;
    }

    public synchronized void start() {
        if (this.has_started) {
            return;
        }
        this.currencyExchangeThread.start();
        this.has_started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        CurrencyExchangeThread currencyExchangeThread = this.currencyExchangeThread;
        synchronized (currencyExchangeThread) {
            if (this.suspend) {
                return;
            }
            this.isRefresh = true;
            this.currencyExchangeThread.interrupt();
        }
    }

    public synchronized void stop() {
        this.currencyExchangeThread._stop();
        try {
            this.currencyExchangeThread.join();
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void suspend() {
        CurrencyExchangeThread currencyExchangeThread = this.currencyExchangeThread;
        synchronized (currencyExchangeThread) {
            this.suspend = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        CurrencyExchangeThread currencyExchangeThread = this.currencyExchangeThread;
        synchronized (currencyExchangeThread) {
            this.suspend = false;
            this.currencyExchangeThread.notify();
        }
    }

    public synchronized void setStockServerFactories(List<StockServerFactory> factories) {
        this.stockServerFactories = factories;
    }

    public String getFromCurrency() {
        return countryToCurrencyCode.get((Object)this.fromCountry);
    }

    public String getToCurrency() {
        return countryToCurrencyCode.get((Object)this.toCountry);
    }

    public Country getFromCountry() {
        return this.fromCountry;
    }

    public Country getToCountry() {
        return this.toCountry;
    }

    public Code getCode() {
        String fromCurrencyCode = countryToCurrencyCode.get((Object)this.getFromCountry());
        String toCurrencyCode = countryToCurrencyCode.get((Object)this.getToCountry());
        return Code.newInstance(fromCurrencyCode + toCurrencyCode + "=X");
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    static {
        countryToCurrencyCode.put(Country.Australia, "AUD");
        countryToCurrencyCode.put(Country.Austria, "EUR");
        countryToCurrencyCode.put(Country.Belgium, "EUR");
        countryToCurrencyCode.put(Country.Brazil, "BRL");
        countryToCurrencyCode.put(Country.Canada, "CAD");
        countryToCurrencyCode.put(Country.China, "CNY");
        countryToCurrencyCode.put(Country.Czech, "CZK");
        countryToCurrencyCode.put(Country.Denmark, "DKK");
        countryToCurrencyCode.put(Country.France, "EUR");
        countryToCurrencyCode.put(Country.Germany, "EUR");
        countryToCurrencyCode.put(Country.HongKong, "HKD");
        countryToCurrencyCode.put(Country.India, "INR");
        countryToCurrencyCode.put(Country.Indonesia, "IDR");
        countryToCurrencyCode.put(Country.Israel, "ILS");
        countryToCurrencyCode.put(Country.Italy, "EUR");
        countryToCurrencyCode.put(Country.Korea, "KPW");
        countryToCurrencyCode.put(Country.Malaysia, "MYR");
        countryToCurrencyCode.put(Country.Netherlands, "EUR");
        countryToCurrencyCode.put(Country.NewZealand, "NZD");
        countryToCurrencyCode.put(Country.Norway, "NOK");
        countryToCurrencyCode.put(Country.Portugal, "EUR");
        countryToCurrencyCode.put(Country.Singapore, "SGD");
        countryToCurrencyCode.put(Country.Spain, "EUR");
        countryToCurrencyCode.put(Country.Sweden, "SEK");
        countryToCurrencyCode.put(Country.Switzerland, "CHF");
        countryToCurrencyCode.put(Country.Taiwan, "TWD");
        countryToCurrencyCode.put(Country.UnitedKingdom, "GBP");
        countryToCurrencyCode.put(Country.UnitedState, "USD");
        log = LogFactory.getLog(CurrencyExchangeMonitor.class);
    }

    private class CurrencyExchangeThread
    extends Thread {
        private volatile boolean isRunnable = true;

        private CurrencyExchangeThread() {
        }

        public void _stop() {
            this.isRunnable = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: while (this.isRunnable) {
                try {
                    while (this.isRunnable) {
                        CurrencyExchangeThread currencyExchangeThread = this;
                        synchronized (currencyExchangeThread) {
                            while (CurrencyExchangeMonitor.this.suspend) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException ex) {
                                    log.error(null, (Throwable)ex);
                                    if (CurrencyExchangeMonitor.this.isRefresh) continue;
                                    this.isRunnable = false;
                                    break;
                                }
                            }
                        }
                        if (!successUpdatedCountryToCurrencyCode) {
                            String server = Utils.getURL(Utils.Type.CURRENCY_CODE_TXT);
                            Map<String, String> map = org.yccheok.jstock.gui.Utils.getUUIDValue(server);
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                if (entry.getValue() == null) continue;
                                try {
                                    countryToCurrencyCode.put(Country.valueOf(entry.getKey()), entry.getValue());
                                }
                                catch (IllegalArgumentException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                                successUpdatedCountryToCurrencyCode = true;
                            }
                        }
                        for (StockServerFactory factory : CurrencyExchangeMonitor.this.stockServerFactories) {
                            StockServer stockServer = factory.getStockServer();
                            if (stockServer == null) continue;
                            Stock stock = null;
                            try {
                                stock = stockServer.getStock(CurrencyExchangeMonitor.this.getCode());
                            }
                            catch (StockNotFoundException ex) {
                                log.error(null, (Throwable)ex);
                                continue;
                            }
                            if (!(stock.getLastPrice() > 0.0)) continue;
                            CurrencyExchangeMonitor.this.exchangeRate = stock.getLastPrice();
                            CurrencyExchangeMonitor.this.notify(CurrencyExchangeMonitor.this, CurrencyExchangeMonitor.this.exchangeRate);
                            break;
                        }
                        try {
                            Thread.sleep(MainFrame.getInstance().getJStockOptions().getScanningSpeed());
                        }
                        catch (InterruptedException ex) {
                            log.error(null, (Throwable)ex);
                            if (!CurrencyExchangeMonitor.this.isRefresh) {
                                this.isRunnable = false;
                                continue block13;
                            }
                            CurrencyExchangeMonitor.this.isRefresh = false;
                        }
                    }
                }
                catch (Exception exp) {
                    log.error(null, (Throwable)exp);
                }
            }
        }
    }
}

