/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.Utils;

public class AppLock {
    private static File f;
    private static FileChannel channel;
    private static FileLock lock;
    private static final Log log;

    public static boolean lock() {
        try {
            String directory = Utils.getUserDataDirectory();
            String fileName = "jstock.lock";
            Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory);
            f = new File(directory + fileName);
            channel = new RandomAccessFile(f, "rw").getChannel();
            lock = channel.tryLock();
            if (lock == null) {
                channel.close();
                return false;
            }
        }
        catch (FileNotFoundException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        return true;
    }

    public static void unlock() {
        try {
            if (lock != null) {
                lock.release();
                channel.close();
                f.delete();
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    static {
        log = LogFactory.getLog(AppLock.class);
    }
}

