/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.gui.MainFrame;

public class WizardSelectStockJPanel
extends JPanel {
    private List<JCheckBox> boardCheckBoxes = new ArrayList<JCheckBox>();
    private List<JCheckBox> industryCheckBoxes = new ArrayList<JCheckBox>();
    private Map<JCheckBox, Stock.Industry> checkBoxToIndustry = new HashMap<JCheckBox, Stock.Industry>();
    private Map<JCheckBox, Stock.Board> checkBoxToBoard = new HashMap<JCheckBox, Stock.Board>();
    private List<StockInfo> selectedStockInfos = new ArrayList<StockInfo>();
    private static final Log log = LogFactory.getLog(WizardSelectStockJPanel.class);
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox10;
    private JCheckBox jCheckBox11;
    private JCheckBox jCheckBox12;
    private JCheckBox jCheckBox13;
    private JCheckBox jCheckBox14;
    private JCheckBox jCheckBox15;
    private JCheckBox jCheckBox16;
    private JCheckBox jCheckBox17;
    private JCheckBox jCheckBox18;
    private JCheckBox jCheckBox19;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox20;
    private JCheckBox jCheckBox21;
    private JCheckBox jCheckBox22;
    private JCheckBox jCheckBox23;
    private JCheckBox jCheckBox24;
    private JCheckBox jCheckBox25;
    private JCheckBox jCheckBox26;
    private JCheckBox jCheckBox27;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JCheckBox jCheckBox9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JXHeader jXHeader1;

    public WizardSelectStockJPanel(StockInfoDatabase stockInfoDatabase) {
        this.initComponents();
        this.initBoardCheckBoxes(stockInfoDatabase);
        this.initIndustryCheckBoxes(stockInfoDatabase);
        this.updateCheckBoxesState();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox21 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox23 = new JCheckBox();
        this.jCheckBox25 = new JCheckBox();
        this.jCheckBox26 = new JCheckBox();
        this.jCheckBox27 = new JCheckBox();
        this.jRadioButton3 = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jCheckBox9 = new JCheckBox();
        this.jCheckBox10 = new JCheckBox();
        this.jCheckBox11 = new JCheckBox();
        this.jCheckBox12 = new JCheckBox();
        this.jCheckBox13 = new JCheckBox();
        this.jCheckBox14 = new JCheckBox();
        this.jCheckBox15 = new JCheckBox();
        this.jCheckBox16 = new JCheckBox();
        this.jCheckBox17 = new JCheckBox();
        this.jCheckBox18 = new JCheckBox();
        this.jCheckBox19 = new JCheckBox();
        this.jCheckBox20 = new JCheckBox();
        this.jCheckBox22 = new JCheckBox();
        this.jCheckBox24 = new JCheckBox();
        this.jRadioButton4 = new JRadioButton();
        this.setPreferredSize(new Dimension(638, 488));
        this.setLayout(new BorderLayout(5, 5));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("WizardSelectStockJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/64x64/find.png")));
        this.jXHeader1.setTitle(bundle.getString("WizardSelectStockJPanel_SelectStockOfInterest"));
        this.add((Component)this.jXHeader1, "North");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(bundle.getString("WizardSelectStockJPanel__SelectEntireStockMarket"));
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardSelectStockJPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText(bundle.getString("WizardSelectStockJPanel_SelectBasedOnBoard"));
        this.jRadioButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardSelectStockJPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("WizardSelectStockJPanel_Board")));
        this.jCheckBox1.setText("Main board");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox2.setText("Second board");
        this.jCheckBox2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox3.setText("Call warrant");
        this.jCheckBox3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox21.setText("Mesdaq");
        this.jCheckBox21.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox21.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox4.setText("Call warrant");
        this.jCheckBox4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox23.setText("Call warrant");
        this.jCheckBox23.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox23.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox25.setText("Call warrant");
        this.jCheckBox25.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox25.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox26.setText("Call warrant");
        this.jCheckBox26.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox26.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox27.setText("Call warrant");
        this.jCheckBox27.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox27.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jCheckBox3)).addGap(49, 49, 49).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox4).addComponent(this.jCheckBox2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBox25).addGap(49, 49, 49).addComponent(this.jCheckBox26))).addGap(40, 40, 40).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox27).addComponent(this.jCheckBox23).addComponent(this.jCheckBox21)).addContainerGap(18, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jCheckBox21)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jCheckBox4).addComponent(this.jCheckBox23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox25).addComponent(this.jCheckBox26).addComponent(this.jCheckBox27)).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText(bundle.getString("WizardSelectStockJPanel_ScanBasedOnIndustry"));
        this.jRadioButton3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardSelectStockJPanel.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("WizardSelectStockJPanel_Industry")));
        this.jCheckBox5.setText("Consumer products");
        this.jCheckBox5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox5.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox6.setText("Trading / Services");
        this.jCheckBox6.setActionCommand("Trading/Services");
        this.jCheckBox6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox6.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox7.setText("Industrial products");
        this.jCheckBox7.setActionCommand("Industry Product");
        this.jCheckBox7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox7.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox8.setText("Technology");
        this.jCheckBox8.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox9.setText("Construction");
        this.jCheckBox9.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox9.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox10.setText("Infrastructure");
        this.jCheckBox10.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox10.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox11.setText("Finance");
        this.jCheckBox11.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox11.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox12.setText("Hotels");
        this.jCheckBox12.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox12.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox13.setText("Properties");
        this.jCheckBox13.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox13.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox14.setText("Plantation");
        this.jCheckBox14.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox14.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox15.setText("Mining");
        this.jCheckBox15.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox15.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox16.setText("Trusts");
        this.jCheckBox16.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox16.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox17.setText("Close-end fund");
        this.jCheckBox17.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox17.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox18.setText("ETF");
        this.jCheckBox18.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox18.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox19.setText("Call warrant");
        this.jCheckBox19.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox19.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox20.setText("Unknown");
        this.jCheckBox20.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox20.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox22.setText("Loans");
        this.jCheckBox22.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox22.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox24.setText("Unknown");
        this.jCheckBox24.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox24.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox5).addComponent(this.jCheckBox6).addComponent(this.jCheckBox11).addComponent(this.jCheckBox14).addComponent(this.jCheckBox17).addComponent(this.jCheckBox19)).addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox7).addComponent(this.jCheckBox8).addComponent(this.jCheckBox12).addComponent(this.jCheckBox15).addComponent(this.jCheckBox18).addComponent(this.jCheckBox20)).addGap(14, 14, 14).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox24).addComponent(this.jCheckBox22).addComponent(this.jCheckBox16).addComponent(this.jCheckBox13).addComponent(this.jCheckBox10).addComponent(this.jCheckBox9)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox5).addComponent(this.jCheckBox7).addComponent(this.jCheckBox9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox6).addComponent(this.jCheckBox8).addComponent(this.jCheckBox10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox11).addComponent(this.jCheckBox12).addComponent(this.jCheckBox13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox14).addComponent(this.jCheckBox15).addComponent(this.jCheckBox16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox17).addComponent(this.jCheckBox18).addComponent(this.jCheckBox22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox20).addComponent(this.jCheckBox19).addComponent(this.jCheckBox24)).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.setText(bundle.getString("WizardSelectStockJPanel_ScanBasedOnStockWatchlistTab"));
        this.jRadioButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardSelectStockJPanel.this.jRadioButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jRadioButton1).addGap(138, 138, 138)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton4).addContainerGap(326, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton1).addGap(18, 18, 18).addComponent(this.jRadioButton4).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton3).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(25, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.updateCheckBoxesState();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.updateCheckBoxesState();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.updateCheckBoxesState();
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.updateCheckBoxesState();
    }

    public final void updateCheckBoxesState() {
        for (Component component : this.jPanel2.getComponents()) {
            component.setEnabled(this.jRadioButton2.isSelected());
        }
        for (Component component : this.jPanel3.getComponents()) {
            component.setEnabled(this.jRadioButton3.isSelected());
        }
    }

    public void updateRadioBoxState() {
        MainFrame m = MainFrame.getInstance();
        List<Stock> stocks = m.getStocks();
        this.jRadioButton4.setEnabled(stocks.size() > 0);
    }

    public boolean isNextFinishButtonEnabled() {
        if (this.jRadioButton1.isSelected()) {
            return true;
        }
        if (this.jRadioButton2.isSelected()) {
            for (JCheckBox checkBox : this.boardCheckBoxes) {
                if (!checkBox.isSelected()) continue;
                return true;
            }
        }
        if (this.jRadioButton3.isSelected()) {
            for (JCheckBox checkBox : this.industryCheckBoxes) {
                if (!checkBox.isSelected()) continue;
                return true;
            }
        }
        return this.jRadioButton4.isSelected();
    }

    public void addActionListenerForAllComponents(ActionListener actionListener) {
        this.jCheckBox1.addActionListener(actionListener);
        this.jCheckBox10.addActionListener(actionListener);
        this.jCheckBox11.addActionListener(actionListener);
        this.jCheckBox12.addActionListener(actionListener);
        this.jCheckBox13.addActionListener(actionListener);
        this.jCheckBox14.addActionListener(actionListener);
        this.jCheckBox15.addActionListener(actionListener);
        this.jCheckBox16.addActionListener(actionListener);
        this.jCheckBox17.addActionListener(actionListener);
        this.jCheckBox18.addActionListener(actionListener);
        this.jCheckBox19.addActionListener(actionListener);
        this.jCheckBox2.addActionListener(actionListener);
        this.jCheckBox20.addActionListener(actionListener);
        this.jCheckBox21.addActionListener(actionListener);
        this.jCheckBox22.addActionListener(actionListener);
        this.jCheckBox3.addActionListener(actionListener);
        this.jCheckBox5.addActionListener(actionListener);
        this.jCheckBox6.addActionListener(actionListener);
        this.jCheckBox7.addActionListener(actionListener);
        this.jCheckBox8.addActionListener(actionListener);
        this.jCheckBox9.addActionListener(actionListener);
        this.jCheckBox4.addActionListener(actionListener);
        this.jCheckBox23.addActionListener(actionListener);
        this.jCheckBox24.addActionListener(actionListener);
        this.jCheckBox25.addActionListener(actionListener);
        this.jCheckBox26.addActionListener(actionListener);
        this.jCheckBox27.addActionListener(actionListener);
        this.jRadioButton1.addActionListener(actionListener);
        this.jRadioButton2.addActionListener(actionListener);
        this.jRadioButton3.addActionListener(actionListener);
        this.jRadioButton4.addActionListener(actionListener);
    }

    public boolean buildSelectedStockCodes() {
        this.selectedStockInfos.clear();
        MainFrame m = MainFrame.getInstance();
        StockInfoDatabase stock_info_database = m.getStockInfoDatabase();
        if (stock_info_database == null) {
            log.error((Object)"Unable to locate MainFrame");
            return false;
        }
        if (this.jRadioButton1.isSelected()) {
            this.selectedStockInfos.addAll(stock_info_database.getStockInfos());
            return true;
        }
        if (this.jRadioButton2.isSelected()) {
            for (JCheckBox checkBox : this.boardCheckBoxes) {
                if (!checkBox.isSelected()) continue;
                Stock.Board board = this.checkBoxToBoard.get(checkBox);
                if (board == null) {
                    log.error((Object)("Wrong text in JCheckBox GUI : " + checkBox.getText()));
                    continue;
                }
                this.selectedStockInfos.addAll(stock_info_database.getStockInfos(board));
            }
            return true;
        }
        if (this.jRadioButton3.isSelected()) {
            for (JCheckBox checkBox : this.industryCheckBoxes) {
                if (!checkBox.isSelected()) continue;
                Stock.Industry industry = this.checkBoxToIndustry.get(checkBox);
                if (industry == null) {
                    log.error((Object)("Wrong text in JCheckBox GUI : " + checkBox.getText()));
                    continue;
                }
                this.selectedStockInfos.addAll(stock_info_database.getStockInfos(industry));
            }
            return true;
        }
        if (this.jRadioButton4.isSelected()) {
            List<Stock> stocks = m.getStocks();
            for (Stock stock : stocks) {
                this.selectedStockInfos.add(StockInfo.newInstance(stock));
            }
            return true;
        }
        return false;
    }

    public List<StockInfo> getSelectedStockInfos() {
        return Collections.unmodifiableList(this.selectedStockInfos);
    }

    private void initBoardCheckBoxes(StockInfoDatabase stockInfoDatabase) {
        this.boardCheckBoxes.add(this.jCheckBox1);
        this.boardCheckBoxes.add(this.jCheckBox2);
        this.boardCheckBoxes.add(this.jCheckBox21);
        this.boardCheckBoxes.add(this.jCheckBox3);
        this.boardCheckBoxes.add(this.jCheckBox4);
        this.boardCheckBoxes.add(this.jCheckBox23);
        this.boardCheckBoxes.add(this.jCheckBox25);
        this.boardCheckBoxes.add(this.jCheckBox26);
        this.boardCheckBoxes.add(this.jCheckBox27);
        for (JCheckBox checkBox : this.boardCheckBoxes) {
            checkBox.setVisible(false);
        }
        List<Stock.Board> sortedBoards = stockInfoDatabase.getBoards();
        Collections.sort(sortedBoards);
        int count = 0;
        for (Stock.Board board : sortedBoards) {
            if (count >= this.boardCheckBoxes.size()) {
                log.error((Object)("You do not have enough check box components (" + this.boardCheckBoxes.size() + ") to hold board (" + sortedBoards.size() + ")"));
                break;
            }
            JCheckBox checkBox = this.boardCheckBoxes.get(count++);
            checkBox.setText(board.toString());
            checkBox.setVisible(true);
            this.checkBoxToBoard.put(checkBox, board);
        }
    }

    private void initIndustryCheckBoxes(StockInfoDatabase stockInfoDatabase) {
        this.industryCheckBoxes.add(this.jCheckBox5);
        this.industryCheckBoxes.add(this.jCheckBox7);
        this.industryCheckBoxes.add(this.jCheckBox9);
        this.industryCheckBoxes.add(this.jCheckBox6);
        this.industryCheckBoxes.add(this.jCheckBox8);
        this.industryCheckBoxes.add(this.jCheckBox10);
        this.industryCheckBoxes.add(this.jCheckBox11);
        this.industryCheckBoxes.add(this.jCheckBox12);
        this.industryCheckBoxes.add(this.jCheckBox13);
        this.industryCheckBoxes.add(this.jCheckBox14);
        this.industryCheckBoxes.add(this.jCheckBox15);
        this.industryCheckBoxes.add(this.jCheckBox16);
        this.industryCheckBoxes.add(this.jCheckBox17);
        this.industryCheckBoxes.add(this.jCheckBox18);
        this.industryCheckBoxes.add(this.jCheckBox22);
        this.industryCheckBoxes.add(this.jCheckBox19);
        this.industryCheckBoxes.add(this.jCheckBox20);
        this.industryCheckBoxes.add(this.jCheckBox24);
        for (JCheckBox checkBox : this.industryCheckBoxes) {
            checkBox.setVisible(false);
        }
        List<Stock.Industry> sortedIndustries = stockInfoDatabase.getIndustries();
        Collections.sort(sortedIndustries);
        int count = 0;
        for (Stock.Industry industry : sortedIndustries) {
            if (count >= this.industryCheckBoxes.size()) {
                log.error((Object)("You do not have enough check box components (" + this.industryCheckBoxes.size() + ") to hold industry (" + sortedIndustries.size() + ")"));
                break;
            }
            JCheckBox checkBox = this.industryCheckBoxes.get(count++);
            checkBox.setText(industry.toString());
            checkBox.setVisible(true);
            this.checkBoxToIndustry.put(checkBox, industry);
        }
    }
}

