/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.charting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.yccheok.jstock.charting.ChartData;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.ChartJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;

public class ChartLayerUI<V extends JComponent>
extends AbstractLayerUI<V> {
    private TraceInfo mainTraceInfo = TraceInfo.newInstance(null, 0, 0, 0);
    private final List<TraceInfo> indicatorTraceInfos = new ArrayList<TraceInfo>();
    private final Rectangle2D mainDrawArea = new Rectangle();
    private static final Color COLOR_BLUE = new Color(85, 85, 255);
    private static final Color COLOR_BACKGROUND = new Color(255, 255, 153);
    private static final Color COLOR_BORDER = new Color(255, 204, 0);
    private final ChartJDialog chartJDialog;
    private static final List<String> params = Collections.unmodifiableList(Arrays.asList(GUIBundle.getString("StockHistory_Open"), GUIBundle.getString("StockHistory_High"), GUIBundle.getString("StockHistory_Low"), GUIBundle.getString("StockHistory_Close"), GUIBundle.getString("StockHistory_Volume")));
    private static final ThreadLocal<SimpleDateFormat> simpleDataFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE, MMM d, yyyy");
        }
    };
    private static final String longDateString;
    private int maxWidth = Integer.MIN_VALUE;

    public ChartLayerUI(ChartJDialog chartJDialog) {
        this.chartJDialog = chartJDialog;
    }

    private void drawInformationBox(Graphics2D g2, JXLayer<? extends V> layer) {
        int paramStringWidth;
        Font oldFont;
        if (MainFrame.getInstance().getJStockOptions().getYellowInformationBoxOption() == JStockOptions.YellowInformationBoxOption.Hide) {
            return;
        }
        Font paramFont = oldFont = g2.getFont();
        FontMetrics paramFontMetrics = g2.getFontMetrics(paramFont);
        Font valueFont = oldFont.deriveFont(oldFont.getStyle() | 1, (float)oldFont.getSize() + 1.0f);
        FontMetrics valueFontMetrics = g2.getFontMetrics(valueFont);
        Font dateFont = oldFont.deriveFont((float)oldFont.getSize() - 1.0f);
        FontMetrics dateFontMetrics = g2.getFontMetrics(dateFont);
        List<ChartData> chartDatas = this.chartJDialog.getChartDatas();
        ArrayList<String> values = new ArrayList<String>();
        ChartData chartData = chartDatas.get(this.mainTraceInfo.getDataIndex());
        DecimalFormat integerFormat = new DecimalFormat("###,###");
        values.add(Utils.stockPriceDecimalFormat(chartData.openPrice));
        values.add(Utils.stockPriceDecimalFormat(chartData.highPrice));
        values.add(Utils.stockPriceDecimalFormat(chartData.lowPrice));
        values.add(Utils.stockPriceDecimalFormat(chartData.lastPrice));
        values.add(integerFormat.format(chartData.volume));
        ArrayList<String> indicatorParams = new ArrayList<String>();
        ArrayList<String> indicatorValues = new ArrayList<String>();
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        for (TraceInfo indicatorTraceInfo : this.indicatorTraceInfos) {
            int plotIndex = indicatorTraceInfo.getPlotIndex();
            int seriesIndex = indicatorTraceInfo.getSeriesIndex();
            int dataIndex = indicatorTraceInfo.getDataIndex();
            String name = this.getLegendName(plotIndex, seriesIndex);
            Number value = this.getValue(plotIndex, seriesIndex, dataIndex);
            if (name == null || value == null) continue;
            indicatorParams.add(name);
            indicatorValues.add(decimalFormat.format(value));
        }
        assert (values.size() == params.size());
        int index = 0;
        int paramValueWidthMargin = 10;
        boolean paramValueHeightMargin = false;
        int infoIndicatorHeightMargin = 8;
        int maxInfoWidth = -1;
        int totalInfoHeight = Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight()) * values.size() + 0 * (values.size() - 1);
        for (String param : params) {
            String value = (String)values.get(index++);
            paramStringWidth = paramFontMetrics.stringWidth(param + ":") + 10 + valueFontMetrics.stringWidth(value);
            if (maxInfoWidth >= paramStringWidth) continue;
            maxInfoWidth = paramStringWidth;
        }
        if (indicatorValues.size() > 0) {
            totalInfoHeight += 8;
            totalInfoHeight += Math.max(paramFontMetrics.getHeight(), valueFontMetrics.getHeight()) * indicatorValues.size() + 0 * (indicatorValues.size() - 1);
            index = 0;
            for (String indicatorParam : indicatorParams) {
                String indicatorValue = (String)indicatorValues.get(index++);
                paramStringWidth = paramFontMetrics.stringWidth(indicatorParam + ":") + 10 + valueFontMetrics.stringWidth(indicatorValue);
                if (maxInfoWidth >= paramStringWidth) continue;
                maxInfoWidth = paramStringWidth;
            }
        }
        Date date = new Date(chartData.timestamp);
        SimpleDateFormat simpleDateFormat = simpleDataFormatThreadLocal.get();
        String dateString = simpleDateFormat.format(date);
        int dateStringWidth = dateFontMetrics.stringWidth(dateString);
        int dateStringHeight = dateFontMetrics.getHeight();
        int maxStringWidth = Math.max(dateFontMetrics.stringWidth(longDateString), Math.max(this.maxWidth, Math.max(dateStringWidth, maxInfoWidth)));
        if (maxStringWidth > this.maxWidth) {
            this.maxWidth = maxStringWidth;
        }
        int dateInfoHeightMargin = 5;
        int maxStringHeight = dateStringHeight + 5 + totalInfoHeight;
        int padding = 5;
        int boxPointMargin = 8;
        int width = maxStringWidth + 10;
        int height = maxStringHeight + 10;
        int borderWidth = width + 2;
        int borderHeight = height + 2;
        double suggestedBorderX = this.mainTraceInfo.getPoint().getX() - (double)borderWidth - 8.0;
        double suggestedBorderY = this.mainTraceInfo.getPoint().getY() - (double)(borderHeight >> 1);
        double bestBorderX = 0.0;
        double bestBorderY = 0.0;
        if (MainFrame.getInstance().getJStockOptions().getYellowInformationBoxOption() == JStockOptions.YellowInformationBoxOption.Stay) {
            if (this.mainTraceInfo.getPoint().getX() > (double)((int)(this.mainDrawArea.getX() + this.mainDrawArea.getWidth() + 0.5) >> 1)) {
                bestBorderX = this.mainDrawArea.getX();
                bestBorderY = this.mainDrawArea.getY();
            } else {
                bestBorderX = this.mainDrawArea.getX() + this.mainDrawArea.getWidth() - (double)borderWidth;
                bestBorderY = this.mainDrawArea.getY();
            }
        } else {
            assert (MainFrame.getInstance().getJStockOptions().getYellowInformationBoxOption() == JStockOptions.YellowInformationBoxOption.Follow);
            double d = suggestedBorderX > this.mainDrawArea.getX() ? (suggestedBorderX + (double)borderWidth < this.mainDrawArea.getX() + this.mainDrawArea.getWidth() ? suggestedBorderX : this.mainDrawArea.getX() + this.mainDrawArea.getWidth() - (double)borderWidth - 8.0) : (bestBorderX = this.mainTraceInfo.getPoint().getX() + 8.0);
            bestBorderY = suggestedBorderY > this.mainDrawArea.getY() ? (suggestedBorderY + (double)borderHeight < this.mainDrawArea.getY() + this.mainDrawArea.getHeight() ? suggestedBorderY : this.mainDrawArea.getY() + this.mainDrawArea.getHeight() - (double)borderHeight - 8.0) : this.mainDrawArea.getY() + 8.0;
        }
        double x = bestBorderX + 1.0;
        double y = bestBorderY + 1.0;
        Object oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Composite oldComposite = g2.getComposite();
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(COLOR_BORDER);
        g2.drawRoundRect((int)(bestBorderX + 0.5), (int)(bestBorderY + 0.5), borderWidth - 1, borderHeight - 1, 15, 15);
        g2.setColor(COLOR_BACKGROUND);
        g2.setComposite(Utils.makeComposite(0.75f));
        g2.fillRoundRect((int)(x + 0.5), (int)(y + 0.5), width, height, 15, 15);
        g2.setComposite(oldComposite);
        g2.setColor(oldColor);
        int yy = (int)(y + 5.0 + (double)dateFontMetrics.getAscent() + 0.5);
        g2.setFont(dateFont);
        g2.setColor(COLOR_BLUE);
        g2.drawString(dateString, (int)((double)(width - dateFontMetrics.stringWidth(dateString) >> 1) + x + 0.5), yy);
        index = 0;
        yy += dateFontMetrics.getDescent() + 5 + valueFontMetrics.getAscent();
        String CLOSE_STR = GUIBundle.getString("StockHistory_Close");
        for (String param : params) {
            String value = (String)values.get(index++);
            g2.setColor(Color.BLACK);
            if (param.equals(CLOSE_STR)) {
                double changePrice = chartData.lastPrice - chartData.openPrice;
                if (changePrice > 0.0) {
                    g2.setColor(JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR);
                } else if (changePrice < 0.0) {
                    g2.setColor(JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR);
                }
            }
            g2.setFont(paramFont);
            g2.drawString(param + ":", (int)(5.0 + x + 0.5), yy);
            g2.setFont(valueFont);
            g2.drawString(value, (int)((double)(width - 5 - valueFontMetrics.stringWidth(value)) + x + 0.5), yy);
            yy += 0 + valueFontMetrics.getHeight();
        }
        g2.setColor(Color.BLACK);
        yy += 0;
        yy += 8;
        index = 0;
        for (String indicatorParam : indicatorParams) {
            String indicatorValue = (String)indicatorValues.get(index++);
            g2.setFont(paramFont);
            g2.drawString(indicatorParam + ":", (int)(5.0 + x + 0.5), yy);
            g2.setFont(valueFont);
            g2.drawString(indicatorValue, (int)((double)(width - 5 - valueFontMetrics.stringWidth(indicatorValue)) + x + 0.5), yy);
            yy += 0 + valueFontMetrics.getHeight();
        }
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
        g2.setFont(oldFont);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends V> layer) {
        super.paintLayer(g2, layer);
        if (this.mainTraceInfo.getPoint() == null) {
            return;
        }
        Object oldValueAntiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(COLOR_BLUE);
        int BALL_RADIUS = 8;
        g2.fillOval((int)(this.mainTraceInfo.getPoint().getX() - 4.0 + 0.5), (int)(this.mainTraceInfo.getPoint().getY() - 4.0 + 0.5), 8, 8);
        for (TraceInfo indicatorTraceInfo : this.indicatorTraceInfos) {
            Point2D point = indicatorTraceInfo.getPoint();
            if (null == point) continue;
            g2.fillOval((int)(point.getX() - 4.0 + 0.5), (int)(point.getY() - 4.0 + 0.5), 8, 8);
        }
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValueAntiAlias);
        this.drawInformationBox(g2, layer);
    }

    protected void processMouseEvent(MouseEvent e, JXLayer<? extends V> layer) {
        super.processMouseEvent(e, layer);
        this.processEvent(e, layer);
    }

    protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends V> layer) {
        super.processMouseMotionEvent(e, layer);
        this.processEvent(e, layer);
    }

    private void updateIndicatorTraceInfos(int mainPointIndex) {
        this.indicatorTraceInfos.clear();
        if (this.mainTraceInfo == null) {
            return;
        }
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        Day day = null;
        XYDataset xyDataset = this.chartJDialog.getPlot().getDataset();
        if (xyDataset instanceof TimeSeriesCollection) {
            day = (Day)((TimeSeriesCollection)xyDataset).getSeries(0).getDataItem(mainPointIndex).getPeriod();
            XYPlot plot = this.chartJDialog.getPlot();
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset();
            int size = timeSeriesCollection.getSeriesCount();
            for (int j = 1; j < size; ++j) {
                TimeSeries timeSeries = timeSeriesCollection.getSeries(j);
                int dataIndex = this.getDataIndex(timeSeries, day);
                if (dataIndex < 0) continue;
                Point2D.Double point = this.getPoint(0, j, dataIndex);
                String name = this.getLegendName(0, j);
                Number value = this.getValue(0, j, dataIndex);
                if (point == null || name == null || value == null) continue;
                this.indicatorTraceInfos.add(TraceInfo.newInstance(null, 0, j, dataIndex));
            }
        } else {
            Date date = ((DefaultHighLowDataset)xyDataset).getXDate(0, mainPointIndex);
            day = new Day(date);
            XYPlot plot = this.chartJDialog.getPlot();
            int count = plot.getDatasetCount();
            for (int i = 1; i < count; ++i) {
                TimeSeries timeSeries;
                int dataIndex;
                TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset(i);
                if (timeSeriesCollection == null || (dataIndex = this.getDataIndex(timeSeries = timeSeriesCollection.getSeries(0), day)) < 0) continue;
                Point2D.Double point = this.getPoint(0, i, dataIndex);
                String name = this.getLegendName(0, i);
                Number value = this.getValue(0, i, dataIndex);
                if (point == null || name == null || value == null) continue;
                this.indicatorTraceInfos.add(TraceInfo.newInstance(null, 0, i, dataIndex));
            }
        }
        int size = this.chartJDialog.getPlotSize();
        for (int i = 1; i < size; ++i) {
            XYPlot plot = this.chartJDialog.getPlot(i);
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset();
            assert (1 == timeSeriesCollection.getSeriesCount());
            int size2 = timeSeriesCollection.getSeriesCount();
            for (int j = 0; j < size2; ++j) {
                TimeSeries timeSeries = timeSeriesCollection.getSeries(j);
                int dataIndex = this.getDataIndex(timeSeries, day);
                if (dataIndex < 0) continue;
                Point2D.Double point = this.getPoint(i, j, dataIndex);
                String name = this.getLegendName(i, j);
                Number value = this.getValue(i, j, dataIndex);
                if (point == null || name == null || value == null) continue;
                Rectangle2D plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(i).getDataArea();
                if (plotArea.contains(point)) {
                    this.indicatorTraceInfos.add(TraceInfo.newInstance(point, i, j, dataIndex));
                    continue;
                }
                this.indicatorTraceInfos.add(TraceInfo.newInstance(null, i, j, dataIndex));
            }
        }
    }

    private TimeSeries getTimeSeries(int plotIndex, int seriesIndex) {
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        if (plotIndex >= chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotCount()) {
            return null;
        }
        if (plotIndex >= this.chartJDialog.getPlotSize()) {
            return null;
        }
        XYDataset xyDataset = this.chartJDialog.getPlot(plotIndex).getDataset();
        if (xyDataset instanceof TimeSeriesCollection) {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)xyDataset;
            if (seriesIndex >= timeSeriesCollection.getSeriesCount()) {
                return null;
            }
            return timeSeriesCollection.getSeries(seriesIndex);
        }
        if (plotIndex == 0 && seriesIndex == 0) {
            return null;
        }
        if (seriesIndex >= this.chartJDialog.getPlot(plotIndex).getDatasetCount()) {
            return null;
        }
        XYDataset d = this.chartJDialog.getPlot(plotIndex).getDataset(seriesIndex);
        return ((TimeSeriesCollection)d).getSeries(0);
    }

    private String getLegendName(int plotIndex, int seriesIndex) {
        TimeSeries timeSeries = this.getTimeSeries(plotIndex, seriesIndex);
        if (timeSeries == null) {
            return null;
        }
        return (String)((Object)timeSeries.getKey());
    }

    private Point2D.Double _getPointForCandlestick(int plotIndex, int seriesIndex, int dataIndex) {
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        XYPlot plot = this.chartJDialog.getPlot(plotIndex);
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        DefaultHighLowDataset defaultHighLowDataset = (DefaultHighLowDataset)plot.getDataset(seriesIndex);
        if (dataIndex >= defaultHighLowDataset.getItemCount(0)) {
            return null;
        }
        double xValue = defaultHighLowDataset.getXDate(0, dataIndex).getTime();
        double yValue = defaultHighLowDataset.getCloseValue(0, dataIndex);
        Rectangle2D plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(plotIndex).getDataArea();
        double xJava2D = domainAxis.valueToJava2D(xValue, plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, plotArea, rangeAxisEdge);
        return new Point2D.Double(xJava2D, yJava2D);
    }

    private Point2D.Double getPoint(int plotIndex, int seriesIndex, int dataIndex) {
        TimeSeries timeSeries = this.getTimeSeries(plotIndex, seriesIndex);
        if (timeSeries == null) {
            XYPlot plot = this.chartJDialog.getPlot(plotIndex);
            if (plot.getDataset(seriesIndex) instanceof DefaultHighLowDataset) {
                return this._getPointForCandlestick(plotIndex, seriesIndex, dataIndex);
            }
            return null;
        }
        if (dataIndex >= timeSeries.getItemCount()) {
            return null;
        }
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        XYPlot plot = this.chartJDialog.getPlot(plotIndex);
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(dataIndex);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        Rectangle2D plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(plotIndex).getDataArea();
        double xJava2D = domainAxis.valueToJava2D(xValue, plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, plotArea, rangeAxisEdge);
        return new Point2D.Double(xJava2D, yJava2D);
    }

    private Number getValue(int plotIndex, int seriesIndex, int dataIndex) {
        TimeSeries timeSeries = this.getTimeSeries(plotIndex, seriesIndex);
        if (timeSeries == null) {
            return null;
        }
        if (dataIndex >= timeSeries.getItemCount()) {
            return null;
        }
        return timeSeries.getDataItem(dataIndex).getValue();
    }

    private int getDataIndex(TimeSeries timeSeries, Day targetDay) {
        int low = 0;
        int high = timeSeries.getItemCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(mid);
            Day searchDay = (Day)timeSeriesDataItem.getPeriod();
            long cmp = searchDay.compareTo((Object)targetDay);
            if (cmp < 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private void updateTraceInfosIfPossible(int dataOffset) {
        if (this.mainTraceInfo.point == null) {
            return;
        }
        int newDataIndex = dataOffset + this.mainTraceInfo.dataIndex;
        if (newDataIndex < 0) {
            // empty if block
        }
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
        Point2D.Double tmpPoint = this.getPoint(0, 0, newDataIndex);
        if (tmpPoint == null || !_plotArea.contains(tmpPoint)) {
            return;
        }
        this.mainTraceInfo = TraceInfo.newInstance(tmpPoint, 0, 0, newDataIndex);
        this.updateTraceInfos();
    }

    public void updateTraceInfos() {
        this.updateMainTraceInfo();
        this.updateIndicatorTraceInfos(this.mainTraceInfo.getDataIndex());
        this.setDirty(true);
    }

    private void updateMainTraceInfo() {
        if (!this.updateMainTraceInfo(this.mainTraceInfo.getPoint())) {
            this.mainTraceInfo = TraceInfo.newInstance(null, 0, 0, 0);
        }
    }

    private boolean _updateMainTraceInfoForCandlestick(Point2D point) {
        if (point == null) {
            return false;
        }
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        XYPlot plot = this.chartJDialog.getPlot();
        DefaultHighLowDataset defaultHighLowDataset = (DefaultHighLowDataset)plot.getDataset();
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double coordinateX = domainAxis.java2DToValue(point.getX(), _plotArea, domainAxisEdge);
        int low = 0;
        int high = defaultHighLowDataset.getItemCount(0) - 1;
        Date date = new Date((long)coordinateX);
        long time = date.getTime();
        long bestDistance = Long.MAX_VALUE;
        int bestMid = 0;
        while (low <= high) {
            long abs_cmp;
            int mid = low + high >>> 1;
            Date d = defaultHighLowDataset.getXDate(0, mid);
            long search = d.getTime();
            long cmp = search - time;
            if (cmp < 0L) {
                low = mid + 1;
            } else if (cmp > 0L) {
                high = mid - 1;
            } else {
                bestDistance = 0L;
                bestMid = mid;
                break;
            }
            if ((abs_cmp = Math.abs(cmp)) >= bestDistance) continue;
            bestDistance = abs_cmp;
            bestMid = mid;
        }
        double xValue = defaultHighLowDataset.getXDate(0, bestMid).getTime();
        double yValue = defaultHighLowDataset.getCloseValue(0, bestMid);
        double xJava2D = domainAxis.valueToJava2D(xValue, _plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, _plotArea, rangeAxisEdge);
        int tmpIndex = bestMid;
        Point tmpPoint = chartPanel.translateJava2DToScreen((Point2D)new Point2D.Double(xJava2D, yJava2D));
        this.mainDrawArea.setRect(_plotArea);
        if (this.mainDrawArea.contains(tmpPoint)) {
            this.mainTraceInfo = TraceInfo.newInstance(tmpPoint, 0, 0, tmpIndex);
            return true;
        }
        return false;
    }

    public void processKeyEvent(KeyEvent e, JXLayer<? extends V> l) {
        if (e.getID() != 401) {
            return;
        }
        int code = e.getKeyCode();
        switch (code) {
            case 37: {
                this.updateTraceInfosIfPossible(-1);
                break;
            }
            case 39: {
                this.updateTraceInfosIfPossible(1);
            }
        }
    }

    private boolean updateMainTraceInfo(Point2D point) {
        if (point == null) {
            return false;
        }
        ChartPanel chartPanel = this.chartJDialog.getChartPanel();
        XYPlot plot = this.chartJDialog.getPlot();
        if (plot.getDataset() instanceof DefaultHighLowDataset) {
            return this._updateMainTraceInfoForCandlestick(point);
        }
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)plot.getDataset();
        TimeSeries timeSeries = timeSeriesCollection.getSeries(0);
        Rectangle2D _plotArea = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double coordinateX = domainAxis.java2DToValue(point.getX(), _plotArea, domainAxisEdge);
        int low = 0;
        int high = timeSeries.getItemCount() - 1;
        Date date = new Date((long)coordinateX);
        long time = date.getTime();
        long bestDistance = Long.MAX_VALUE;
        int bestMid = 0;
        while (low <= high) {
            long abs_cmp;
            int mid = low + high >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(mid);
            Day day = (Day)timeSeriesDataItem.getPeriod();
            long search = day.getFirstMillisecond();
            long cmp = search - time;
            if (cmp < 0L) {
                low = mid + 1;
            } else if (cmp > 0L) {
                high = mid - 1;
            } else {
                bestDistance = 0L;
                bestMid = mid;
                break;
            }
            if ((abs_cmp = Math.abs(cmp)) >= bestDistance) continue;
            bestDistance = abs_cmp;
            bestMid = mid;
        }
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(bestMid);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        double xJava2D = domainAxis.valueToJava2D(xValue, _plotArea, domainAxisEdge);
        double yJava2D = rangeAxis.valueToJava2D(yValue, _plotArea, rangeAxisEdge);
        int tmpIndex = bestMid;
        Point tmpPoint = chartPanel.translateJava2DToScreen((Point2D)new Point2D.Double(xJava2D, yJava2D));
        this.mainDrawArea.setRect(_plotArea);
        if (this.mainDrawArea.contains(tmpPoint)) {
            this.mainTraceInfo = TraceInfo.newInstance(tmpPoint, 0, 0, tmpIndex);
            return true;
        }
        return false;
    }

    private void processEvent(MouseEvent e, JXLayer layer) {
        if (506 == e.getID()) {
            return;
        }
        Point mousePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)layer);
        if (this.updateMainTraceInfo(mousePoint)) {
            this.updateIndicatorTraceInfos(this.mainTraceInfo.getDataIndex());
            this.setDirty(true);
        }
    }

    static {
        Calendar c = Calendar.getInstance();
        c.set(2010, 8, 29);
        longDateString = simpleDataFormatThreadLocal.get().format(c.getTime());
    }

    private static class TraceInfo {
        private final Point2D point;
        private final int dataIndex;
        private final int plotIndex;
        private final int seriesIndex;

        private TraceInfo(Point2D point, int plotIndex, int seriesIndex, int dataIndex) {
            this.point = point;
            this.dataIndex = dataIndex;
            this.plotIndex = plotIndex;
            this.seriesIndex = seriesIndex;
        }

        public static TraceInfo newInstance(Point2D point, int plotIndex, int seriesIndex, int dataIndex) {
            return new TraceInfo(point, plotIndex, seriesIndex, dataIndex);
        }

        public Point2D getPoint() {
            return this.point;
        }

        public int getDataIndex() {
            return this.dataIndex;
        }

        public int getPlotIndex() {
            return this.plotIndex;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }
    }
}

