/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.portfolio.Builder;

public class Contract {
    private final Stock stock;
    private final SimpleDate date;
    private final Type type;
    private final double quantity;
    private final double price;
    private final double referencePrice;
    private final double total;
    private final double referenceTotal;
    private final double referenceBroker;
    private final double referenceClearingFee;
    private final double referenceStampDuty;
    private SimpleDate referenceDate;

    public Stock getStock() {
        return this.stock;
    }

    public SimpleDate getDate() {
        return this.date;
    }

    public Type getType() {
        return this.type;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public double getPrice() {
        return this.price;
    }

    public double getReferencePrice() {
        return this.referencePrice;
    }

    public double getReferenceBroker() {
        return this.referenceBroker;
    }

    public double getReferenceClearingFee() {
        return this.referenceClearingFee;
    }

    public double getReferenceStampDuty() {
        return this.referenceStampDuty;
    }

    public double getTotal() {
        return this.total;
    }

    public double getReferenceTotal() {
        return this.referenceTotal;
    }

    public SimpleDate getReferenceDate() {
        return this.referenceDate;
    }

    private Contract(ContractBuilder builder) {
        this.stock = builder.stock;
        this.date = builder.date;
        this.type = builder.type;
        this.quantity = builder.quantity;
        this.price = builder.price;
        this.referencePrice = builder.referencePrice;
        this.referenceBroker = builder.referenceBroker;
        this.referenceClearingFee = builder.referenceClearingFee;
        this.referenceStampDuty = builder.referenceStampDuty;
        this.total = this.price * this.quantity;
        this.referenceTotal = this.referencePrice * this.quantity;
        this.referenceDate = builder.referenceDate;
    }

    public Contract deriveWithQuantity(double quantity) {
        ContractBuilder builder = new ContractBuilder(this.stock, this.date);
        return builder.type(this.type).quantity(quantity).price(this.price).referencePrice(this.referencePrice).referenceBroker(this.referenceBroker).referenceClearingFee(this.referenceClearingFee).referenceStampDuty(this.referenceStampDuty).build();
    }

    public Contract deriveWithPrice(double price) {
        ContractBuilder builder = new ContractBuilder(this.stock, this.date);
        return builder.type(this.type).quantity(this.quantity).price(price).referencePrice(this.referencePrice).referenceBroker(this.referenceBroker).referenceClearingFee(this.referenceClearingFee).referenceStampDuty(this.referenceStampDuty).build();
    }

    public Contract(Contract contract) {
        this.stock = new Stock(contract.stock);
        this.date = new SimpleDate(contract.date);
        this.type = contract.type;
        this.quantity = contract.quantity;
        this.price = contract.price;
        this.referencePrice = contract.referencePrice;
        this.referenceBroker = contract.referenceBroker;
        this.referenceClearingFee = contract.referenceClearingFee;
        this.referenceStampDuty = contract.referenceStampDuty;
        this.total = contract.total;
        this.referenceTotal = contract.referenceTotal;
        this.referenceDate = contract.referenceDate;
    }

    private Object readResolve() {
        if (this.referenceDate == null) {
            this.referenceDate = this.date;
        }
        return this;
    }

    public static enum Type {
        Buy,
        Sell;

    }

    public static class ContractBuilder
    implements Builder<Contract> {
        private final Stock stock;
        private final SimpleDate date;
        private Type type = Type.Buy;
        private double quantity = 0.0;
        private double price = 0.0;
        private double referencePrice = 0.0;
        private double referenceBroker = 0.0;
        private double referenceClearingFee = 0.0;
        private double referenceStampDuty = 0.0;
        private SimpleDate referenceDate = new SimpleDate();

        public ContractBuilder(Stock stock, SimpleDate date) {
            this.stock = stock;
            this.date = date;
        }

        public ContractBuilder type(Type val) {
            this.type = val;
            return this;
        }

        public ContractBuilder quantity(double val) {
            this.quantity = val;
            return this;
        }

        public ContractBuilder price(double val) {
            this.price = val;
            return this;
        }

        public ContractBuilder referencePrice(double val) {
            this.referencePrice = val;
            return this;
        }

        public ContractBuilder referenceBroker(double val) {
            this.referenceBroker = val;
            return this;
        }

        public ContractBuilder referenceClearingFee(double val) {
            this.referenceClearingFee = val;
            return this;
        }

        public ContractBuilder referenceStampDuty(double val) {
            this.referenceStampDuty = val;
            return this;
        }

        public ContractBuilder referenceDate(SimpleDate date) {
            this.referenceDate = date;
            return this;
        }

        @Override
        public Contract build() {
            return new Contract(this);
        }
    }
}

