/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.data.IEntry;
import com.google.gdata.data.media.MediaBodyPart;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.common.base.Preconditions;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MediaMultipart
extends MimeMultipart {
    private static final Logger LOGGER = Logger.getLogger(MediaMultipart.class.getName());
    protected MediaBodyPart atomPart;
    protected MediaBodyPart mediaPart;

    public static void loadMimeMappings() {
        String[] CONTENT_TYPES = new String[]{"application/atom+xml", "application/rss+xml", "application/json"};
        String CONTENT_HANDLER = ";; x-java-content-handler=com.google.gdata.data.media.GDataContentHandler";
        CommandMap commandMap = CommandMap.getDefaultCommandMap();
        if (commandMap instanceof MailcapCommandMap) {
            MailcapCommandMap mailcapMap = (MailcapCommandMap)commandMap;
            for (int i = 0; i < CONTENT_TYPES.length; ++i) {
                CommandInfo[] comm = mailcapMap.getAllCommands(CONTENT_TYPES[i]);
                if (comm != null && comm.length != 0) continue;
                mailcapMap.addMailcap(CONTENT_TYPES[i] + ";; x-java-content-handler=com.google.gdata.data.media.GDataContentHandler");
            }
        } else {
            LOGGER.warning("Unable to find MailcapCommandMap, skipping dynamic mailcap config.");
        }
    }

    protected MediaMultipart(String subType) {
        super(subType);
    }

    public MediaMultipart(String contentType, InputStream inputStream) throws MessagingException {
        super((DataSource)new MediaStreamSource(inputStream, contentType));
        if (this.getCount() != 2) {
            throw new MessagingException("Multipart must have Atom and media part");
        }
        boolean atomFirst = this.getBodyPart(0).isMimeType(ContentType.ATOM.getMediaType());
        if (!atomFirst && !this.getBodyPart(1).isMimeType(ContentType.ATOM.getMediaType())) {
            throw new MessagingException("No Atom MIME body part found");
        }
        this.atomPart = (MediaBodyPart)this.getBodyPart(atomFirst ? 0 : 1);
        this.mediaPart = (MediaBodyPart)this.getBodyPart(atomFirst ? 1 : 0);
    }

    public MediaMultipart(IEntry entry, MediaSource media) throws MessagingException {
        super("related");
        Preconditions.checkNotNull((Object)entry, (Object)"entry");
        Preconditions.checkNotNull((Object)media, (Object)"media");
        this.atomPart = new MediaBodyPart(entry);
        this.addBodyPart((BodyPart)this.atomPart);
        this.mediaPart = new MediaBodyPart(media);
        this.addBodyPart((BodyPart)this.mediaPart);
    }

    public MimeBodyPart createMimeBodyPart(InputStream is) throws MessagingException {
        return new MediaBodyPart(is);
    }

    public MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        return new MediaBodyPart(headers, content);
    }

    public MediaBodyPart getAtomPart() {
        return this.atomPart;
    }

    public MediaBodyPart getMediaPart() {
        return this.mediaPart;
    }

    static {
        MediaMultipart.loadMimeMappings();
    }
}

