/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class BankAccountEditorPane
extends EditorPane {
    final String[] actions = new String[]{"", "Next Check Number", "Print Check", "Deposit", "ATM"};
    boolean newTransaction = false;
    private JButton addressButton;
    private JButton beginButton;
    private JButton cancelButton;
    private JComboBox categoryComboBox;
    private JCheckBox clearedCheckBox;
    private JButton closeButton;
    private JButton commitButton;
    private JPanel controlPanel;
    private JTextField dateTextField;
    private JButton deleteButton;
    private JTextField depositTextField;
    private JButton endButton;
    private JCheckBox enterModeCheckBox;
    private JButton helpButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField memoTextField;
    private JButton memorizeButton;
    private JButton newButton;
    private JButton nextButton;
    private JComboBox numberComboBox;
    private JTextField payeeTextField;
    private JTextField paymentTextField;
    private JButton previousButton;
    private JTextField recordNumTextField;
    private JPanel splitsPanel;
    private JPanel topPanel;

    public BankAccountEditorPane(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.initComboBoxen();
        this.getTextField(this.numberComboBox).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.setChanged(true);
                BankAccountEditorPane.this.watchForLF(keyEvent);
            }
        });
        this.getTextField(this.categoryComboBox).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.setChanged(true);
                BankAccountEditorPane.this.watchForLF(keyEvent);
            }
        });
    }

    private void initComboBoxen() {
        for (int i = 0; i < this.actions.length; ++i) {
            this.numberComboBox.addItem(this.actions[i]);
        }
    }

    @Override
    public void loadForm(Account account, int n) {
        this.handleEnterMode(false);
        this.orig_t = null;
        this.edit_t = null;
        if (account != null) {
            this.account = account;
            this.index = n;
            this.orig_t = account.getTransaction(n);
            this.edit_t = new Transaction(this.parent, this.orig_t);
            if (this.edit_t != null) {
                this.loadForm(this.edit_t);
                this.account.accountDisplay.scrollToTransaction(n, true);
            } else {
                System.out.println("loadForm transaction null on account: " + account);
            }
        }
    }

    private void loadForm(Transaction transaction) {
        this.suppressChange = true;
        this.dateTextField.setText(transaction.displayDate);
        String string = transaction.db_Number;
        if (string.equals("(new)")) {
            System.out.println("default mode " + this.account.db_DefaultTransactionMode + "," + transaction.displayDate);
            this.numberComboBox.setSelectedIndex(this.account.db_DefaultTransactionMode);
            String string2 = (String)this.numberComboBox.getSelectedItem();
            string2 = string2 == null ? "" : string2;
            this.getTextField(this.numberComboBox).setText(string2);
            this.newTransaction = true;
        } else {
            this.newTransaction = false;
            this.getTextField(this.numberComboBox).setText(string);
        }
        this.paymentTextField.setText("");
        this.depositTextField.setText("");
        if (transaction.db_Amount > 0.005) {
            this.depositTextField.setText(this.parent.commonCode.getAbsDollarCentString(transaction.db_Amount, false));
        } else if (transaction.db_Amount < -0.005) {
            this.paymentTextField.setText(this.parent.commonCode.getAbsDollarCentString(transaction.db_Amount, false));
        }
        this.payeeTextField.setText(transaction.db_Payee);
        this.memoTextField.setText(transaction.db_Memo);
        this.setupCategories(transaction);
        this.dateTextField.requestFocus();
        this.hasSplits = this.getSplitsPanel().setupTable(this.account, transaction, transaction.splits);
        this.address = this.parent.commonCode.unEscapeMultiLine(transaction.db_Address);
        this.clearedCheckBox.setSelected(transaction.db_Cleared);
        this.showCount();
        this.dateTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BankAccountEditorPane.this.setChanged(false);
            }
        });
        this.suppressChange = false;
    }

    private void setupCategories(Transaction transaction) {
        this.categoryComboBox.removeAllItems();
        this.categoryComboBox.addItem("");
        this.parent.categoryHandler.setupComboBox(this.categoryComboBox, "");
        this.parent.accountHandler.setupComboBox(this.categoryComboBox, transaction.db_Category);
    }

    private void showCount() {
        String string = "";
        string = this.index >= this.account.size() ? "New Transaction" : this.index + 1 + " of " + this.account.size() + " transactions";
        this.recordNumTextField.setText(string);
    }

    private void cancel() {
        this.parent.beep();
        int n = JOptionPane.showConfirmDialog(this.parent, "Discard Changes?", "Transaction Changed", 1);
        if (n == 0) {
            this.loadForm(this.account, this.index);
        }
    }

    private SplitsHandler getSplitsPanel() {
        return (SplitsHandler)this.splitsPanel;
    }

    @Override
    protected void commit(int n) {
        if (this.account != null) {
            this.getSplitsPanel().stopEditing();
            boolean bl = this.buildTransaction(this.edit_t);
            this.newTransaction = false;
            if (bl) {
                this.account.deleteTransaction(this.orig_t, true, true);
                this.account.addTransaction(this.edit_t, true, true);
                this.loadForm(this.account, this.index + n);
                this.parent.playSound();
            }
        }
    }

    private void overrideNumberComboBox(boolean bl) {
        if (bl) {
            this.numberComboBox.setSelectedItem("Deposit");
            this.getTextField(this.numberComboBox).setText("Deposit");
        } else {
            String string = (String)this.numberComboBox.getSelectedItem();
            if (string == null || string.equals("Deposit")) {
                this.numberComboBox.setSelectedItem("");
            }
        }
    }

    private boolean buildTransaction(Transaction transaction) {
        String string;
        String string2;
        Object object;
        Vector vector;
        transaction.splits = vector = this.getSplitsPanel().createSplitsVector();
        if (vector == null) {
            Object object2 = this.categoryComboBox.getSelectedItem();
            if (object2 != null) {
                transaction.db_Category = object2.toString();
                if (transaction.db_Category.endsWith(":")) {
                    transaction.db_Category = transaction.db_Category.substring(0, transaction.db_Category.length() - 1);
                }
                if (transaction.db_Category.length() > 0 && transaction.db_Category.charAt(0) == '[') {
                    object = this.parent.commonCode.getAccountForTag(this.parent.accountHandler.dataMap, transaction.db_Category);
                    if (object == null) {
                        JOptionPane.showMessageDialog(null, "Please enter or select a valid category or account.", "Invalid Category/Account Entry", 0);
                        return false;
                    }
                } else {
                    int n = this.parent.categoryHandler.validateCategory(transaction.db_Category);
                    if (n == 0) {
                        JOptionPane.showMessageDialog(null, "Please enter a category,\nor select a category from the dropdown list.", "No Category Entered", 0);
                        return false;
                    }
                    if (n == 2) {
                        this.setupCategories(transaction);
                    }
                }
            }
        } else {
            transaction.db_Category = "";
            transaction.recomputeSplits();
        }
        boolean bl = false;
        object = "";
        if (vector != null) {
            bl = transaction.db_Amount > 0.0;
        } else {
            int n = this.depositTextField.getText().trim().length();
            int n2 = this.paymentTextField.getText().trim().length();
            if (n > 0) {
                bl = true;
            }
            object = bl ? this.depositTextField.getText().trim() : this.paymentTextField.getText().trim();
        }
        this.overrideNumberComboBox(bl);
        if (vector == null) {
            if (((String)object).length() == 0) {
                this.parent.beep();
                JOptionPane.showMessageDialog(null, "Please enter a number in either \"Payment\" or \"Deposit\".", "Number Entry Error", 0);
                return false;
            }
            String string3 = this.parent.commonCode.formatCurrency((String)object, false);
            if (string3 == null) {
                return false;
            }
            if (!bl) {
                string3 = "-" + string3;
            }
            transaction.db_Amount = this.parent.commonCode.parseCurrencyDollarCentString(string3);
        }
        transaction.db_Payee = this.payeeTextField.getText();
        transaction.db_Memo = this.memoTextField.getText();
        if (this.newTransaction) {
            this.account.db_DefaultTransactionMode = this.numberComboBox.getSelectedIndex();
        }
        if ((string2 = this.getTextField(this.numberComboBox).getText()).equals("Next Check Number")) {
            this.getTextField(this.numberComboBox).setText(String.valueOf(this.account.db_CheckNumber));
        }
        if (this.parent.commonCode.isValidInt(string = this.getTextField(this.numberComboBox).getText())) {
            this.account.db_CheckNumber = Integer.parseInt(string) + 1;
        }
        transaction.db_Number = string;
        transaction.db_Cleared = this.clearedCheckBox.isSelected();
        transaction.setTime(this.parent.commonCode.timeForDisplayDateLenient(this.dateTextField.getText()));
        transaction.updateKey();
        transaction.db_Address = this.parent.commonCode.escapeMultiLine(this.address);
        return true;
    }

    protected void handlePayeeTabExit() {
        String string = this.payeeTextField.getText();
        if (string.length() == 0) {
            return;
        }
        MemorizedItem memorizedItem = this.parent.memHandler.nearestMatchLCValue(string);
        if (memorizedItem != null) {
            if (memorizedItem.Payee.indexOf(string) == 0) {
                String string2 = memorizedItem.Type;
                if (string2.equals("C")) {
                    String string3 = this.actions[this.account.db_DefaultTransactionMode];
                    if (string3.equals("Next Check Number") || string3.equals("Print Check")) {
                        this.numberComboBox.setSelectedIndex(this.account.db_DefaultTransactionMode);
                        this.getTextField(this.numberComboBox).setText(string3);
                    }
                } else if (string2.equals("D")) {
                    this.numberComboBox.setSelectedItem("Deposit");
                    this.getTextField(this.numberComboBox).setText("Deposit");
                }
                this.memoTextField.setText(memorizedItem.Memo);
                this.categoryComboBox.setSelectedItem(memorizedItem.Category);
                double d = memorizedItem.Amount;
                CurrencyValue currencyValue = new CurrencyValue(this.parent);
                currencyValue.setValue(d);
                if (d < 0.0) {
                    this.paymentTextField.setText(currencyValue.getAbsDollarsCentsString());
                    this.paymentTextField.selectAll();
                    this.depositTextField.setText("");
                    this.paymentTextField.requestFocus();
                } else {
                    this.depositTextField.setText(currencyValue.getAbsDollarsCentsString());
                    this.depositTextField.selectAll();
                    this.paymentTextField.setText("");
                    this.depositTextField.requestFocus();
                }
                this.overrideNumberComboBox(d >= 0.0);
                this.address = this.parent.commonCode.unEscapeMultiLine(memorizedItem.Address);
                if (memorizedItem.getSplits() != null) {
                    this.hasSplits = this.getSplitsPanel().setupTable(this.account, this.edit_t, memorizedItem.getSplits());
                }
            } else {
                String string4 = (String)this.numberComboBox.getSelectedItem();
                if (string4 != null && string4.equals("Deposit")) {
                    this.depositTextField.requestFocus();
                } else {
                    this.paymentTextField.requestFocus();
                }
            }
        }
    }

    protected void editAddress() {
        String string = MultiLineEntryForm.showForm(this.parent, "Enter or change address below:", "Edit address", this.address);
        if (!this.address.equals(string)) {
            this.address = string;
            this.setChanged(true);
        }
    }

    private void memorizeTransaction() {
        Transaction transaction;
        String string = this.edit_t.db_Amount < -0.005 ? "P" : "D";
        String string2 = this.getTextField(this.numberComboBox).getText();
        if (this.parent.commonCode.zeroFailParseInteger(this.getTextField(this.numberComboBox).getText()) > 0 || string2.equals("Next Check Number") || string2.equals("Print Check")) {
            string = "C";
        }
        if (this.buildTransaction(transaction = new Transaction(this.parent))) {
            this.parent.memHandler.memorizeTransaction(transaction.db_Payee, transaction, string);
        }
    }

    @Override
    protected void setChanged(boolean bl) {
        if (!this.suppressChange) {
            this.dataChanged = bl;
            this.commitButton.setEnabled(bl);
            this.cancelButton.setEnabled(bl);
        }
    }

    private void handleEnterMode(boolean bl) {
        if (bl) {
            this.parent.programValues.db_EnterMode = this.enterModeCheckBox.isSelected();
        } else {
            this.enterModeCheckBox.setSelected(this.parent.programValues.db_EnterMode);
        }
    }

    private void help_bankTransaction() {
        this.parent.launchHelp("BasicOperations.html#Entering_your_first_transaction");
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.dateTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.payeeTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.depositTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.categoryComboBox = new ActiveComboBox(this.parent, true);
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.numberComboBox = new JComboBox();
        this.clearedCheckBox = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.paymentTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.memoTextField = new JTextField();
        this.addressButton = new JButton();
        this.enterModeCheckBox = new JCheckBox();
        this.splitsPanel = new SplitsHandler(this.parent, this, false);
        this.controlPanel = new JPanel();
        this.deleteButton = new MyJButton();
        this.beginButton = new MyJButton();
        this.previousButton = new MyJButton();
        this.recordNumTextField = new JTextField();
        this.nextButton = new MyJButton();
        this.endButton = new MyJButton();
        this.newButton = new MyJButton();
        this.commitButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.memorizeButton = new MyJButton();
        this.helpButton = new MyJButton();
        this.closeButton = new MyJButton();
        this.setBorder(BorderFactory.createTitledBorder(null, "Bank Transaction Editor", 4, 2));
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText("Date");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.dateTextField.setToolTipText("<html>You may use '+' and '-' keys,<br/>or your mouse wheel,<br/>to change this value");
        this.dateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                BankAccountEditorPane.this.dateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.dateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.dateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.dateTextField, gridBagConstraints);
        this.jLabel1.setText("Payee");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.payeeTextField.setText("John Doe");
        this.payeeTextField.setToolTipText("Payee name");
        this.payeeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BankAccountEditorPane.this.payeeTextFieldFocusLost(focusEvent);
            }
        });
        this.payeeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.payeeTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.payeeTextField, gridBagConstraints);
        this.jLabel3.setText("Deposit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.depositTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.depositTextFieldActionPerformed(actionEvent);
            }
        });
        this.depositTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.depositTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.depositTextField, gridBagConstraints);
        this.jLabel5.setText("Category");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.categoryComboBox.setEditable(true);
        this.categoryComboBox.setToolTipText("Category or account");
        this.categoryComboBox.setMinimumSize(new Dimension(24, 24));
        this.categoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BankAccountEditorPane.this.categoryComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.categoryComboBox, gridBagConstraints);
        this.jPanel3.add(this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel6.setText("Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.numberComboBox.setEditable(true);
        this.numberComboBox.setToolTipText("Check number or type");
        this.numberComboBox.setMinimumSize(new Dimension(24, 24));
        this.numberComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BankAccountEditorPane.this.numberComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.numberComboBox, gridBagConstraints);
        this.clearedCheckBox.setText("Cleared");
        this.clearedCheckBox.setToolTipText("Normally controlled by \"Reconcile\"");
        this.clearedCheckBox.setFocusable(false);
        this.clearedCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BankAccountEditorPane.this.clearedCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.clearedCheckBox, gridBagConstraints);
        this.jLabel7.setText("Payment");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.paymentTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.paymentTextFieldActionPerformed(actionEvent);
            }
        });
        this.paymentTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.paymentTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.paymentTextField, gridBagConstraints);
        this.jLabel4.setText("Memo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.memoTextField.setToolTipText("Additional information");
        this.memoTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                BankAccountEditorPane.this.memoTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.memoTextField, gridBagConstraints);
        this.addressButton.setText("Address");
        this.addressButton.setToolTipText("Address associated with this transaction");
        this.addressButton.setMinimumSize(new Dimension(25, 25));
        this.addressButton.setPreferredSize(new Dimension(25, 25));
        this.addressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.addressButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.addressButton, gridBagConstraints);
        this.enterModeCheckBox.setText("Enter mode");
        this.enterModeCheckBox.setToolTipText("Pressing \"Enter\" completes transaction");
        this.enterModeCheckBox.setFocusable(false);
        this.enterModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                BankAccountEditorPane.this.enterModeCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.enterModeCheckBox, gridBagConstraints);
        this.jPanel3.add(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.topPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.splitsPanel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.topPanel.add((Component)this.splitsPanel, gridBagConstraints);
        this.add((Component)this.topPanel, "Center");
        this.controlPanel.setLayout(new GridBagLayout());
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        this.deleteButton.setToolTipText("Delete this transaction");
        this.deleteButton.setMinimumSize(new Dimension(34, 30));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.beginButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBegin.png")));
        this.beginButton.setToolTipText("First transaction");
        this.beginButton.setMinimumSize(new Dimension(34, 30));
        this.beginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.beginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.beginButton, gridBagConstraints);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBack.png")));
        this.previousButton.setToolTipText("Previous transaction");
        this.previousButton.setMinimumSize(new Dimension(34, 30));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.previousButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.previousButton, gridBagConstraints);
        this.recordNumTextField.setEditable(false);
        this.recordNumTextField.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.recordNumTextField, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRForward.png")));
        this.nextButton.setToolTipText("Next transaction");
        this.nextButton.setMinimumSize(new Dimension(34, 30));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.nextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.nextButton, gridBagConstraints);
        this.endButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCREnd.png")));
        this.endButton.setToolTipText("Last transaction");
        this.endButton.setMinimumSize(new Dimension(34, 30));
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.endButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.endButton, gridBagConstraints);
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/New.png")));
        this.newButton.setToolTipText("New transaction");
        this.newButton.setMinimumSize(new Dimension(34, 30));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.newButton, gridBagConstraints);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentIn.png")));
        this.commitButton.setToolTipText("Commit changes to account");
        this.commitButton.setFocusable(false);
        this.commitButton.setMargin(new Insets(2, 4, 2, 4));
        this.commitButton.setMaximumSize(new Dimension(54, 30));
        this.commitButton.setPreferredSize(new Dimension(54, 30));
        this.commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.commitButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.commitButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Undo.png")));
        this.cancelButton.setToolTipText("Revert to original values");
        this.cancelButton.setFocusable(false);
        this.cancelButton.setMargin(new Insets(2, 4, 2, 4));
        this.cancelButton.setMaximumSize(new Dimension(54, 30));
        this.cancelButton.setPreferredSize(new Dimension(54, 30));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.memorizeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/LaptopIn.png")));
        this.memorizeButton.setToolTipText("Memorize this transaction");
        this.memorizeButton.setFocusable(false);
        this.memorizeButton.setMargin(new Insets(2, 4, 2, 4));
        this.memorizeButton.setMaximumSize(new Dimension(54, 30));
        this.memorizeButton.setPreferredSize(new Dimension(54, 30));
        this.memorizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.memorizeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.memorizeButton, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setToolTipText("Provide context-sensitive help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.helpButton, gridBagConstraints);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.setFocusable(false);
        this.closeButton.setMinimumSize(new Dimension(34, 30));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BankAccountEditorPane.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controlPanel.add((Component)this.closeButton, gridBagConstraints);
        this.add((Component)this.controlPanel, "South");
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.help_bankTransaction();
    }

    private void numberComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void enterModeCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.handleEnterMode(true);
    }

    private void clearedCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void memoTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void paymentTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void categoryComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void depositTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.newTransaction();
    }

    private void endButtonActionPerformed(ActionEvent actionEvent) {
        this.toEnd();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.changeTransaction(1, false);
    }

    private void previousButtonActionPerformed(ActionEvent actionEvent) {
        this.changeTransaction(-1, false);
    }

    private void beginButtonActionPerformed(ActionEvent actionEvent) {
        this.toBegin();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteTransaction();
    }

    private void memorizeButtonActionPerformed(ActionEvent actionEvent) {
        this.memorizeTransaction();
    }

    private void addressButtonActionPerformed(ActionEvent actionEvent) {
        this.editAddress();
    }

    private void depositTextFieldActionPerformed(ActionEvent actionEvent) {
        this.handleNumberEntry(actionEvent, false);
    }

    private void paymentTextFieldActionPerformed(ActionEvent actionEvent) {
        this.handleNumberEntry(actionEvent, false);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeEditingWindow(this.account);
    }

    private void commitButtonActionPerformed(ActionEvent actionEvent) {
        this.commit(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void payeeTextFieldFocusLost(FocusEvent focusEvent) {
        this.handlePayeeTabExit();
    }

    private void payeeTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
        this.handlePayeeField(this.payeeTextField, keyEvent);
    }

    private void dateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
        this.parent.commonCode.handleDateFieldKey(keyEvent, true);
    }

    private void dateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.setChanged(true);
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }
}

