/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public final class CommonCode {
    DateFormat longDateFormat = null;
    DateFormat shortDateFormat = null;
    DateFormat shortLenientDateFormat = null;
    DateFormat displayDateFormat = null;
    NumberFormat nfNormal = null;
    NumberFormat nfExtended = null;
    public String decimalSeparator;
    final double epsilon = 0.005;
    final String lineSep = System.getProperty("line.separator");
    final String fileSep = System.getProperty("file.separator");
    final int ACTION_DO_NOTHING = 0;
    final int ACTION_DELETE = 1;
    final String eol = System.getProperty("line.separator");
    PLCash parent;
    public final String[] actionLabels = new String[]{"BuyX", "CGLongX", "CGMidX", "CGShortX", "DivX", "ReinvDiv", "ReinvInt", "ReinvLg", "ReinvMd", "ReinvSh", "Reminder", "RtrnCapX", "SellX", "ShrsIn", "ShrsOut", "ShtSellx", "StkSplit"};
    public final boolean[] saleForLabels = new boolean[]{false, true, true, true, true, false, false, false, false, false, false, false, true, false, true, true, false};

    CommonCode(PLCash pLCash) {
        this.parent = pLCash;
        this.init();
    }

    NumberFormat createNumberFormat(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat;
    }

    void init() {
        this.nfNormal = this.createNumberFormat(2);
        this.nfExtended = this.createNumberFormat(3);
        this.decimalSeparator = "" + new DecimalFormatSymbols().getDecimalSeparator();
        this.shortDateFormat = DateFormat.getDateInstance();
        this.displayDateFormat = DateFormat.getDateInstance();
        this.shortLenientDateFormat = DateFormat.getDateInstance();
        this.shortLenientDateFormat.setLenient(true);
    }

    public boolean isSale(String string) {
        string = string.toLowerCase();
        boolean bl = false;
        for (int i = 0; i < this.actionLabels.length; ++i) {
            if (!string.equals(this.actionLabels[i].toLowerCase())) continue;
            bl = this.saleForLabels[i];
            break;
        }
        return bl;
    }

    public boolean nonZero(double d) {
        return Math.abs(d) > 0.005;
    }

    public boolean isValidInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String formatCurrency(String string, boolean bl) {
        Double d = this.safeParseDouble(string);
        if (d == null) {
            this.parent.beep();
            JOptionPane.showMessageDialog(null, "Invalid number.", "Number Entry Error", 0);
            return null;
        }
        double d2 = d;
        return this.getAbsDollarCentString(d2, bl);
    }

    double getDouble(String string) {
        double d = 0.0;
        try {
            d = this.parent.numberFormat.parse(string).doubleValue();
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".getDouble: Error: " + exception);
            exception.printStackTrace();
        }
        return d;
    }

    double getDoubleUSLocale(String string) {
        double d = 0.0;
        try {
            d = this.parent.usNumberFormat.parse(string).doubleValue();
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".getDouble: Error: " + exception);
            exception.printStackTrace();
        }
        return d;
    }

    public Double safeParseDouble(String string) {
        return this.getDouble(string);
    }

    public double defaultFailParseDouble(String string, double d) {
        Double d2 = this.safeParseDouble(string);
        if (d2 == null) {
            return d;
        }
        return d2;
    }

    public double zeroFailParseDouble(String string) {
        Double d = this.safeParseDouble(string);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public Integer safeParseInteger(String string) {
        Integer n = null;
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public Long safeParseLong(String string) {
        Long l = null;
        if (string != null) {
            try {
                l = new Long(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public int defaultFailParseInteger(String string, int n) {
        Integer n2 = this.safeParseInteger(string);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public long defaultFailParseLong(String string, long l) {
        Long l2 = this.safeParseLong(string);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    public int zeroFailParseInteger(String string) {
        Integer n = this.safeParseInteger(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public String safeTreeGetDefault(TreeMap treeMap, String string, String string2) {
        if (string != null && treeMap.containsKey(string)) {
            return (String)treeMap.get(string);
        }
        return string2;
    }

    public String safeTreeGet(TreeMap treeMap, String string) {
        if (string != null && treeMap.containsKey(string)) {
            return (String)treeMap.get(string);
        }
        return "";
    }

    public long getNormalizedTime() {
        String string = this.dbDate();
        long l = this.timeForDbDate(string);
        return l;
    }

    public String dbDate() {
        return this.dbDateForTime(new Date().getTime());
    }

    public String dbDateForTime(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar.get(1) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(5);
    }

    public String qifDateStringForTime(long l, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        String string = "/";
        if (n >= 2000) {
            n -= 2000;
            string = "'";
        } else {
            n -= 1900;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && n2 < 10) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(String.valueOf(n2) + "/");
        if (n3 < 10) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(String.valueOf(n3) + string);
        if (n < 10) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(String.valueOf(n));
        return stringBuffer.toString();
    }

    public long timeForDbDate(String string) {
        long l = -1L;
        try {
            String[] stringArray = string.split("-");
            if (stringArray.length == 3) {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                int n3 = Integer.parseInt(stringArray[2].trim());
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, 0, 0, 0);
                l = gregorianCalendar.getTimeInMillis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public String displayDateForTime(long l) {
        if (l == 0L) {
            return "";
        }
        return this.displayDateFormat.format(new Date(l));
    }

    public long timeForDisplayDate(String string) {
        long l = -1L;
        try {
            l = this.displayDateFormat.parse(string).getTime();
            System.out.println("decoded: " + new Date(l).toString());
        }
        catch (Exception exception) {
            System.out.println("timeForDisplayDate: fail on " + string + ": " + exception);
            exception.printStackTrace();
        }
        return l;
    }

    public long timeForDisplayDateLenient(String string) {
        long l = -1L;
        try {
            l = this.shortLenientDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            System.out.println("timeForDisplayDateLenient: fail on " + string + ": " + exception);
            exception.printStackTrace();
        }
        return l;
    }

    public String mediumDateForTime(long l) {
        return DateFormat.getDateInstance(2).format(new Date(l));
    }

    public long timeForQIFDate(String string) {
        int n = 0;
        String[] stringArray = string.split("/");
        if (stringArray.length < 3 && (stringArray = (string = string.replaceAll("'", "/")).split("/")).length < 3) {
            return 0L;
        }
        n = Integer.parseInt(stringArray[2].trim());
        if (n < 50) {
            n += 2000;
        } else if (n < 100) {
            n += 1900;
        }
        int n2 = Integer.parseInt(stringArray[0].trim());
        int n3 = Integer.parseInt(stringArray[1].trim());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3, 0, 0, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    public void setTableCellTextColor(JLabel jLabel, double d, Color color) {
        if (d < -0.005) {
            jLabel.setForeground(color);
        }
    }

    public String getAbsDollarString(double d, boolean bl) {
        String string = this.getAbsDollarCentString(d, bl);
        int n = string.lastIndexOf(this.decimalSeparator);
        return string.substring(0, n);
    }

    public String getDollarString(double d, boolean bl) {
        String string = this.getCurrencyDollarCentString(d, bl);
        int n = string.lastIndexOf(this.decimalSeparator);
        return string.substring(0, n);
    }

    public String getCentString(double d, boolean bl) {
        String string = this.getCurrencyDollarCentString(d, bl);
        int n = string.lastIndexOf(this.decimalSeparator);
        return string.substring(n + 1);
    }

    public String getDollarCentString(double d, boolean bl) {
        DecimalFormat decimalFormat = bl ? new DecimalFormat(String.format("0%s0000", this.decimalSeparator)) : new DecimalFormat(String.format("0%s00", this.decimalSeparator));
        double d2 = Math.abs(d);
        double d3 = bl ? 5.0E-5 : 0.005;
        if (d2 < d3) {
            d = 0.0;
        }
        return decimalFormat.format(d);
    }

    public String getAbsDollarCentString(double d, boolean bl) {
        return this.getCurrencyDollarCentString(Math.abs(d), bl);
    }

    public String getCurrencyDollarCentString(double d, boolean bl) {
        double d2 = Math.abs(d);
        double d3 = bl ? 5.0E-5 : 0.005;
        if (d2 < d3) {
            d = 0.0;
        }
        String string = bl ? this.nfExtended.format(d) : this.nfNormal.format(d);
        return string;
    }

    public double parseCurrencyDollarCentString(String string) {
        double d = 0.0;
        if (string != null && string.length() > 0) {
            try {
                d = this.nfNormal.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return d;
    }

    public String wrapHTMLColorOnCurrency(CurrencyValue currencyValue, Color color, Color color2) {
        if (currencyValue.isNegative()) {
            color = color2;
        }
        return "<font color=\"#" + this.toHexString(color.getRGB()) + "\">" + this.getCurrencyDollarCentString(currencyValue.getValue(), false) + "</font>";
    }

    public String wrapHTMLColorOnDouble(double d, Color color, Color color2, boolean bl) {
        if (d < -0.005) {
            color = color2;
        }
        return "<font color=\"#" + this.toHexString(color.getRGB()) + "\">" + this.getCurrencyDollarCentString(d, bl) + "</font>";
    }

    public String toHexString(long l) {
        String string = Long.toHexString(0xFFFFFFL & l);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    public String colorToHexString(Color color) {
        return this.toHexString(color.getRGB());
    }

    public String toHTMLColorString(Color color) {
        return "#" + this.colorToHexString(color);
    }

    public Account getAccountForTag(TreeMap treeMap, String string) {
        Account account = null;
        if (string != null && string.length() > 0 && string.charAt(0) == '[') {
            String string2 = string.replaceFirst("(\\[)(.*)(\\])", "$2");
            account = (Account)treeMap.get(string2);
        }
        return account;
    }

    public TransactionLocation locateTransaction(TreeMap treeMap, Account account, Transaction transaction, int n) {
        TransactionLocation transactionLocation = null;
        Account account2 = this.getAccountForTag(treeMap, transaction.db_Category);
        if (account2 != account && account2 != null) {
            transactionLocation = this.locateReciprocalLink(account, account2, transaction, n);
            if (transactionLocation == null) {
                // empty if block
            }
        } else if (account2 == account) {
            transactionLocation = new TransactionLocation(transaction, account);
        }
        return transactionLocation;
    }

    public TransactionLocation locateReciprocalLink(Account account, Account account2, Transaction transaction, int n) {
        Transaction transaction2;
        int n2;
        TransactionLocation transactionLocation = null;
        int n3 = account2.getTransactionList().size();
        long l = transaction.getTime();
        for (int i = n2 = account2.binarySearch(transaction); i > 0 && i <= n3 && account2.getTransaction(i - 1).getTime() == l; --i) {
        }
        for (int i = i; i < n3 && transactionLocation == null && (transaction2 = account2.getTransaction(i)).getTime() == l; ++i) {
            Vector vector = transaction2.getSplits();
            if (vector != null) {
                for (int j = 0; j < vector.size() && transactionLocation == null; ++j) {
                    Transaction transaction3 = (Transaction)vector.get(j);
                    if (!this.compareTransactions(transaction, transaction3)) continue;
                    transactionLocation = new TransactionLocation(transaction2, account2);
                    if (n != 1) continue;
                    transaction2.deleteSplit(transaction3, true, false);
                    if (transaction2.splits != null) continue;
                    account2.deleteTransaction(transaction2, true, false);
                }
                continue;
            }
            if (!this.compareTransactions(transaction, transaction2)) continue;
            transactionLocation = new TransactionLocation(transaction2, account2);
            if (n != 1) continue;
            account2.deleteTransaction(transaction2, true, false);
        }
        if (transactionLocation == null) {
            // empty if block
        }
        return transactionLocation;
    }

    public boolean compareTransactions(Transaction transaction, Transaction transaction2) {
        return transaction.getSrchTag().equals(transaction2.getRecipSrchTag()) && transaction.getRecipSrchTag().equals(transaction2.getSrchTag());
    }

    public void createNewTransactionLink(TreeMap treeMap, Account account, Transaction transaction) {
        Account account2 = this.getAccountForTag(treeMap, transaction.db_Category);
        if (account2 != null) {
            Transaction transaction2 = new Transaction(this.parent, account2, transaction.getPayee(), transaction.getTime(), "[" + account.db_Name + "]", transaction.db_Memo, -transaction.getTransactionAmount());
            transaction2.db_Number = "";
            account2.addTransaction(transaction2, true, false);
        }
    }

    public void deleteExistingLinks(TreeMap treeMap, Account account, Transaction transaction) {
        Vector vector = transaction.getSplits();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Transaction transaction2 = (Transaction)vector.get(i);
                this.locateTransaction(treeMap, account, transaction2, 1);
            }
        } else {
            this.locateTransaction(treeMap, account, transaction, 1);
        }
    }

    public void createRequiredLinks(TreeMap treeMap, Account account, Transaction transaction) {
        Vector vector = transaction.getSplits();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Transaction transaction2 = (Transaction)vector.get(i);
                this.createNewTransactionLink(treeMap, account, transaction2);
            }
        } else {
            this.createNewTransactionLink(treeMap, account, transaction);
        }
    }

    public double sumOfSplits(Vector vector) {
        if (vector == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            d += ((Transaction)vector.get((int)i)).db_Amount;
        }
        return d;
    }

    public String getFieldValueAsString(Field field, Object object) {
        String string = "";
        try {
            string = field.getType().isAssignableFrom(Boolean.TYPE) ? ((Boolean)field.get(object) != false ? "1" : "0") : (field.getType().isAssignableFrom(Boolean.class) ? ((Boolean)field.get(object) != false ? "1" : "0") : String.valueOf(field.get(object)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void parseRecordValues(Object object, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            this.parseSingleValue(object, string, string2);
        }
    }

    public void parseRecordValues(Object object, String[] stringArray, JTextField[] jTextFieldArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = jTextFieldArray[i].getText();
            this.parseSingleValue(object, string, string2);
        }
    }

    public void parseSingleValue(Object object, String string, String string2) {
        try {
            Field field = object.getClass().getDeclaredField(string);
            Class<Object> clazz = field.getType();
            if (clazz.isAssignableFrom(String.class)) {
                field.set(object, string2);
            } else if (clazz.isAssignableFrom(Boolean.class)) {
                field.set(object, string2.equals("1"));
            } else if (clazz.isAssignableFrom(Boolean.TYPE)) {
                field.set(object, string2.equals("1"));
            } else if (clazz.isAssignableFrom(Integer.class)) {
                field.set(object, new Integer(string2));
            } else if (clazz.isAssignableFrom(Integer.TYPE)) {
                field.set(object, new Integer(string2));
            } else if (clazz.isAssignableFrom(Long.class)) {
                field.set(object, new Long(string2));
            } else if (clazz.isAssignableFrom(Long.TYPE)) {
                field.set(object, new Long(string2));
            } else if (clazz.isAssignableFrom(Double.class)) {
                field.set(object, new Double(string2));
            } else if (clazz.isAssignableFrom(Double.TYPE)) {
                field.set(object, new Double(string2));
            } else if (clazz.isAssignableFrom(Color.class)) {
                String string3 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3");
                String[] stringArray = string3.split("\t");
                field.set(object, new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])));
            } else if (clazz.isAssignableFrom(Dimension.class)) {
                String string4 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] stringArray = string4.split("\t");
                field.set(object, new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            } else if (clazz.isAssignableFrom(Point.class)) {
                String string5 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2");
                String[] stringArray = string5.split("\t");
                field.set(object, new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            } else if (clazz.isAssignableFrom(Rectangle.class)) {
                String string6 = string2.replaceFirst("\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+(\\d+)\\D+", "$1\t$2\t$3\t$4");
                String[] stringArray = string6.split("\t");
                field.set(object, new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String unEscapeMultiLine(String string) {
        return string.replaceAll("\\\\n", "\n");
    }

    public String escapeMultiLine(String string) {
        return string.replaceAll("\\n", "\\\\n");
    }

    public boolean changeDateField(JTextField jTextField, int n, boolean bl) {
        String string = jTextField.getText();
        if (string.length() > 0) {
            try {
                Date date = this.displayDateFormat.parse(jTextField.getText());
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                gregorianCalendar.add(6, n);
                long l = gregorianCalendar.getTimeInMillis();
                string = this.displayDateFormat.format(new Date(l));
                jTextField.setText(string);
                return true;
            }
            catch (Exception exception) {
                this.parent.beep();
            }
        } else if (bl) {
            this.parent.beep();
        }
        return false;
    }

    public boolean handleCheckNumberField(JTextField jTextField, int n, boolean bl) {
        try {
            int n2 = Integer.parseInt(jTextField.getText());
            jTextField.setText(String.valueOf(n2 += n));
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.parent.beep();
            }
            return false;
        }
    }

    public boolean handleDateFieldKey(KeyEvent keyEvent, boolean bl) {
        JTextField jTextField = (JTextField)keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == '=') {
            if (this.changeDateField(jTextField, 1, bl)) {
                keyEvent.consume();
                return true;
            }
        } else if ((c == '-' || c == '_') && this.changeDateField(jTextField, -1, bl)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public boolean handleDateFieldMouseWheel(MouseWheelEvent mouseWheelEvent, boolean bl) {
        int n = mouseWheelEvent.getWheelRotation() > 0 ? -1 : 1;
        JTextField jTextField = (JTextField)mouseWheelEvent.getSource();
        if (this.changeDateField(jTextField, n, bl)) {
            mouseWheelEvent.consume();
            return true;
        }
        return false;
    }

    public boolean handleCheckNumberField(KeyEvent keyEvent, boolean bl) {
        JTextField jTextField = (JTextField)keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == '=') {
            if (this.handleCheckNumberField(jTextField, 1, bl)) {
                keyEvent.consume();
                return true;
            }
        } else if ((c == '-' || c == '_') && this.handleCheckNumberField(jTextField, -1, bl)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public boolean handleDoubleNumberField(JTextField jTextField, double d, boolean bl) {
        char c = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        try {
            double d2 = this.getDouble(jTextField.getText());
            jTextField.setText(new DecimalFormat(String.format("0%s00", this.decimalSeparator)).format(d2 += d));
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.parent.beep();
            }
            return false;
        }
    }

    public boolean handleDoubleNumberField(KeyEvent keyEvent, boolean bl, double d) {
        JTextField jTextField = (JTextField)keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == '=') {
            if (this.handleDoubleNumberField(jTextField, d, bl)) {
                keyEvent.consume();
                return true;
            }
        } else if ((c == '-' || c == '_') && this.handleDoubleNumberField(jTextField, -d, bl)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void loadComboBox(JComboBox jComboBox, String[] stringArray, int n, int n2) {
        int n3 = n > 0 ? n : stringArray.length;
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        if (n2 != -1) {
            jComboBox.setSelectedIndex(n2);
        }
    }

    double interpolate(double d, double d2, double d3, double d4, double d5) {
        return (d - d2) / (d3 - d2) * (d5 - d4) + d4;
    }

    public String readFile(File file) {
        String string = "";
        char[] cArray = new char[(int)file.length()];
        try {
            FileReader fileReader = new FileReader(file);
            fileReader.read(cArray);
            fileReader.close();
            string = new String(cArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String wrapTag(String string, String string2) {
        return "<" + string + ">" + this.eol + string2 + "</" + string + ">" + this.eol;
    }

    public String wrapTag(String string, String string2, String string3) {
        return "<" + string + " " + string2 + ">" + this.eol + string3 + "</" + string + ">" + this.eol;
    }

    public String toSystemLineEndings(String string) {
        if (!this.eol.equals("\n")) {
            string = string.replaceAll("\n", this.eol);
        }
        return string;
    }

    public String toJavaLineEndings(String string) {
        if (string != null) {
            if (string.indexOf("\r\n") != -1) {
                string = string.replaceAll("\r\n", "\n");
            } else if (string.indexOf("\r") != -1) {
                string = string.replaceAll("\r", "\n");
            }
        }
        return string;
    }

    public boolean testFileAccess(File file) {
        return this.testFileAccess(file, null);
    }

    public boolean testFileAccess(File file, PLCash pLCash) {
        boolean bl = false;
        try {
            if (!file.exists()) {
                file = new File(file.getParent());
            }
            boolean bl2 = file.canRead();
            boolean bl3 = file.canWrite();
            boolean bl4 = bl = bl2 && bl3;
            if (!bl) {
                String string = "";
                string = !bl2 && !bl3 ? "read and write" : (!bl2 ? "read" : "write");
                String string2 = "<html><h3><font color=red>Warning!</font> PLCash has detected a " + string + " access error<br>for file or directory \"" + file.getPath() + "\"</h3><BR>This is a very serious error. Please:<font color=blue><ul><li>Close the PLCash program.<li>Correct system access permissions so that user \"" + System.getProperty("user.name") + "\"<BR>can access, read and write the file or directory \"" + file.getPath() + "\"<li>Run PLCash and check the integrity of your records.</ul></font><b><font color=red>Please do this now, do not delay.</font><b><br><br>If you do not understand this message or do not know what action to take,<br>please contact your system administrator now.";
                JOptionPane.showMessageDialog(pLCash, string2, "File/Directory Access error.", 2);
                throw new Exception("File access error: " + string + " failed on " + file.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void main(String[] stringArray) {
        this.testFileAccess(new File("/temp/x"));
    }
}

