/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public final class JListCheckBox
extends JList {
    public JListCheckBox() {
        this.init();
    }

    public JListCheckBox(Object[] objectArray) {
        this.setListData(this.createData(objectArray));
        this.init();
    }

    public JListCheckBox(Vector vector) {
        this.setListData(this.createData(vector));
        this.init();
    }

    public String[] getSelectedStrings() {
        String[] stringArray = new String[]{""};
        Vector vector = this.getSelectedItems();
        if (vector != null && vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = vector.get(i).toString();
            }
        }
        return stringArray;
    }

    public Vector getSelectedItems() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)this.getModel().getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            vector.add(checkableItem.getObject());
        }
        return vector;
    }

    public HashSet getSelectedHash() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)this.getModel().getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            hashSet.add(checkableItem.toString());
        }
        return hashSet;
    }

    public void replaceListData(Object[] objectArray) {
        HashSet hashSet = null;
        int n = this.getModel().getSize();
        if (n > 0) {
            hashSet = this.getSelectedHash();
        }
        super.setListData(this.createData(objectArray));
        if (hashSet == null) {
            return;
        }
        this.setSelectedHash(hashSet, false);
    }

    private void setSelectedHash(HashSet hashSet, boolean bl) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)this.getModel().getElementAt(i);
            if (hashSet.contains(checkableItem.toString())) {
                checkableItem.setSelected(true);
                continue;
            }
            if (!bl) continue;
            checkableItem.setSelected(false);
        }
    }

    public void setSelected(String[] stringArray, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        this.setSelectedHash(hashSet, bl);
    }

    public void setListData(Object[] objectArray) {
        super.setListData(this.createData(objectArray));
    }

    public void setListData(Vector vector) {
        this.setListData(this.createData(vector));
    }

    public void init() {
        this.setCellRenderer(new CheckListRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CheckableItem checkableItem;
                int n = JListCheckBox.this.locationToIndex(mouseEvent.getPoint());
                checkableItem.setSelected(!(checkableItem = (CheckableItem)JListCheckBox.this.getModel().getElementAt(n)).isSelected());
                Rectangle rectangle = JListCheckBox.this.getCellBounds(n, n);
                JListCheckBox.this.repaint(rectangle);
            }
        });
    }

    public void setSelected(int n, boolean bl) {
        CheckableItem checkableItem = (CheckableItem)this.getModel().getElementAt(n);
        checkableItem.setSelected(bl);
    }

    public void setSelectedAll(boolean bl) {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            this.setSelected(i, bl);
        }
        this.repaint();
    }

    private CheckableItem[] createData(Vector vector) {
        return this.createData(vector.toArray(new String[0]));
    }

    private CheckableItem[] createData(Object[] objectArray) {
        int n = objectArray.length;
        CheckableItem[] checkableItemArray = new CheckableItem[n];
        for (int i = 0; i < n; ++i) {
            checkableItemArray[i] = new CheckableItem(objectArray[i]);
        }
        return checkableItemArray;
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            this.setSelected(((CheckableItem)object).isSelected());
            this.setFont(jList.getFont());
            this.setText(object.toString());
            return this;
        }
    }
}

