/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.print.PrintService;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class PrintManager
extends JDialog {
    final double physPageWidth = 8.5;
    final double physPageHeight = 11.0;
    PLCash parent;
    int cofp = 3;
    int jobCheckNum = 0;
    boolean valid = false;
    Vector checks;
    int length;
    Account account;
    PrintService[] services;
    int serviceIndex = 0;
    private JButton cancelButton;
    private JComboBox checkTypeComboBox;
    private JLabel checksLabel;
    private JTextField checksTextField;
    private JPanel controlPanel;
    private JPanel displayPanel;
    private JTextField firstCheckNumTextField;
    private JButton goButton;
    private JTextField horizTextField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JComboBox printerComboBox;
    private JTextField vertTextField;

    public PrintManager(Frame frame, boolean bl) {
        super(frame, bl);
        this.parent = (PLCash)frame;
        this.initComponents();
        this.setPreferredSize(new Dimension(500, 300));
    }

    public void setupShow(Account account) {
        int n;
        this.account = account;
        this.findChecks();
        if (this.length == 0) {
            this.parent.beep();
            JOptionPane.showMessageDialog(this.parent, "There are no checks to print in\naccount " + this.account.db_Name, "No Checks", 1);
            return;
        }
        this.checksLabel.setText("<html><center>There are " + this.length + " checks to print<br>in account " + this.account.db_Name + "</center></html>");
        this.services = PrinterJob.lookupPrintServices();
        if (this.services == null || this.services.length == 0) {
            this.parent.beep();
            JOptionPane.showMessageDialog(this.parent, "There are no printers defined on this machine.", "No Printers", 1);
            return;
        }
        for (n = 0; n < this.services.length; ++n) {
            this.printerComboBox.addItem(this.services[n].getName());
        }
        this.printerComboBox.setSelectedItem(this.parent.programValues.db_checkPrinter);
        for (n = 0; n < PrintFormatter.checkTypeNames.length; ++n) {
            this.checkTypeComboBox.addItem(PrintFormatter.checkTypeNames[n]);
        }
        this.checkTypeComboBox.setSelectedIndex(this.parent.programValues.db_checkType);
        this.checksTextField.setText("3");
        this.horizTextField.setText("" + this.parent.programValues.db_CheckPrintDeltaX);
        this.parent.commonCode.handleDoubleNumberField(this.horizTextField, 0.0, false);
        this.vertTextField.setText("" + this.parent.programValues.db_CheckPrintDeltaY);
        this.parent.commonCode.handleDoubleNumberField(this.vertTextField, 0.0, false);
        this.firstCheckNumTextField.setText("" + account.db_CheckNumber);
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
        this.processResult();
    }

    private void getValues() {
        this.parent.programValues.db_checkPrinter = (String)this.printerComboBox.getSelectedItem();
        this.serviceIndex = this.printerComboBox.getSelectedIndex();
        this.serviceIndex = this.serviceIndex < 0 ? 0 : this.serviceIndex;
        this.parent.programValues.db_checkType = this.checkTypeComboBox.getSelectedIndex();
        this.cofp = Integer.parseInt(this.checksTextField.getText());
        this.cofp = this.cofp > 3 ? 3 : this.cofp;
        this.cofp = this.cofp < 1 ? 1 : this.cofp;
        this.parent.programValues.db_CheckPrintDeltaX = this.parent.commonCode.getDouble(this.horizTextField.getText());
        this.parent.programValues.db_CheckPrintDeltaY = this.parent.commonCode.getDouble(this.vertTextField.getText());
        this.jobCheckNum = Integer.parseInt(this.firstCheckNumTextField.getText());
    }

    private void processResult() {
        if (this.valid) {
            this.getValues();
            this.printChecks(this.account);
            for (int i = 0; i < this.checks.size(); ++i) {
                Transaction transaction = (Transaction)this.checks.get(i);
                transaction.db_Number = "" + this.jobCheckNum;
                ++this.jobCheckNum;
            }
            this.account.db_CheckNumber = this.jobCheckNum;
            this.account.whenDataChanged();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void go() {
        this.valid = true;
        this.setVisible(false);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void findChecks() {
        this.checks = new Vector();
        int n = this.account.size();
        for (int i = 0; i < n; ++i) {
            Transaction transaction = this.account.getTransaction(i);
            if (!transaction.db_Number.equals("Print Check")) continue;
            this.checks.add(transaction);
        }
        this.length = this.checks.size();
    }

    public void getPrintDims(PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = this.parent.commonCode.interpolate(0.25, 0.0, 8.5, 0.0, d);
        double d4 = this.parent.commonCode.interpolate(0.25, 0.0, 11.0, 0.0, d2);
        double d5 = this.parent.commonCode.interpolate(8.25, 0.0, 8.5, 0.0, d) - d3;
        double d6 = this.parent.commonCode.interpolate(10.75, 0.0, 11.0, 0.0, d2) - d4;
        paper.setImageableArea(d3, d4, d5, d6);
        pageFormat.setPaper(paper);
    }

    public void printChecks(Account account) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintService(this.services[this.serviceIndex]);
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(1);
            this.getPrintDims(pageFormat);
            printerJob.setPrintable(new PrintFormatter(this.parent, account, this, pageFormat, this.checks, this.cofp));
            printerJob.print();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void help_printing() {
        this.parent.launchHelp("AdvancedOperations.html#Printing_Checks");
    }

    private void initComponents() {
        this.displayPanel = new JPanel();
        this.checksLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.printerComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.checkTypeComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.checksTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.horizTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel6 = new JLabel();
        this.vertTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.firstCheckNumTextField = new JTextField();
        this.controlPanel = new JPanel();
        this.jButton1 = new MyJButton();
        this.goButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.setTitle("Check Printing");
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(500, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrintManager.this.closeDialog(windowEvent);
            }
        });
        this.displayPanel.setMinimumSize(new Dimension(400, 200));
        this.displayPanel.setPreferredSize(new Dimension(400, 200));
        this.displayPanel.setLayout(new GridBagLayout());
        this.checksLabel.setHorizontalAlignment(0);
        this.checksLabel.setText("****");
        this.checksLabel.setMaximumSize(new Dimension(0, 128));
        this.checksLabel.setMinimumSize(new Dimension(0, 32));
        this.checksLabel.setPreferredSize(new Dimension(0, 32));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.checksLabel, gridBagConstraints);
        this.jLabel1.setText("1. Choose a printer:");
        this.jLabel1.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.printerComboBox, gridBagConstraints);
        this.jLabel2.setText("2. Choose a check type:");
        this.jLabel2.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.checkTypeComboBox, gridBagConstraints);
        this.jLabel3.setText("3. Checks on first page:");
        this.jLabel3.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.checksTextField.setText("3");
        this.checksTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PrintManager.this.checksTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.checksTextField, gridBagConstraints);
        this.jLabel4.setText("4. Align printing position - ");
        this.jLabel4.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Horizontal:");
        this.jLabel5.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.horizTextField.setText("0.0");
        this.horizTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PrintManager.this.horizTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.horizTextField, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("(units: inches)");
        this.jLabel8.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel6.setText("Vertical:");
        this.jLabel6.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.vertTextField.setText("0.0");
        this.vertTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PrintManager.this.vertTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.vertTextField, gridBagConstraints);
        this.jLabel7.setText("5. First Check Number:");
        this.jLabel7.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.firstCheckNumTextField.setText("0");
        this.firstCheckNumTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PrintManager.this.firstCheckNumTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.displayPanel.add((Component)this.firstCheckNumTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.displayPanel, "Center");
        this.controlPanel.setFocusable(false);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.jButton1.setText("Help");
        this.jButton1.setToolTipText("Provide context-sensitive help");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.jButton1);
        this.goButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Print.png")));
        this.goButton.setText("Print");
        this.goButton.setToolTipText("Take the plunge and print those checks");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.goButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.goButton);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Undo.png")));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Oh, never mind");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.help_printing();
    }

    private void vertTextFieldKeyTyped(KeyEvent keyEvent) {
        this.parent.commonCode.handleDoubleNumberField(keyEvent, true, 0.01);
    }

    private void checksTextFieldKeyTyped(KeyEvent keyEvent) {
        this.parent.commonCode.handleCheckNumberField(keyEvent, true);
    }

    private void firstCheckNumTextFieldKeyTyped(KeyEvent keyEvent) {
        this.parent.commonCode.handleCheckNumberField(keyEvent, true);
    }

    private void horizTextFieldKeyTyped(KeyEvent keyEvent) {
        this.parent.commonCode.handleDoubleNumberField(keyEvent, true, 0.01);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void goButtonActionPerformed(ActionEvent actionEvent) {
        this.go();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new PrintManager((Frame)new JFrame(), true).setVisible(true);
    }
}

