/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LookupError {
    public static final LookupError NOT_FOUND = new LookupError().withTag(Tag.NOT_FOUND);
    public static final LookupError NOT_FILE = new LookupError().withTag(Tag.NOT_FILE);
    public static final LookupError NOT_FOLDER = new LookupError().withTag(Tag.NOT_FOLDER);
    public static final LookupError RESTRICTED_CONTENT = new LookupError().withTag(Tag.RESTRICTED_CONTENT);
    public static final LookupError UNSUPPORTED_CONTENT_TYPE = new LookupError().withTag(Tag.UNSUPPORTED_CONTENT_TYPE);
    public static final LookupError OTHER = new LookupError().withTag(Tag.OTHER);
    private Tag _tag;
    private String malformedPathValue;

    private LookupError() {
    }

    private LookupError withTag(Tag _tag) {
        LookupError result = new LookupError();
        result._tag = _tag;
        return result;
    }

    private LookupError withTagAndMalformedPath(Tag _tag, String malformedPathValue) {
        LookupError result = new LookupError();
        result._tag = _tag;
        result.malformedPathValue = malformedPathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMalformedPath() {
        return this._tag == Tag.MALFORMED_PATH;
    }

    public static LookupError malformedPath(String value) {
        return new LookupError().withTagAndMalformedPath(Tag.MALFORMED_PATH, value);
    }

    public static LookupError malformedPath() {
        return LookupError.malformedPath(null);
    }

    public String getMalformedPathValue() {
        if (this._tag != Tag.MALFORMED_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_PATH, but was Tag." + this._tag.name());
        }
        return this.malformedPathValue;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isNotFile() {
        return this._tag == Tag.NOT_FILE;
    }

    public boolean isNotFolder() {
        return this._tag == Tag.NOT_FOLDER;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isUnsupportedContentType() {
        return this._tag == Tag.UNSUPPORTED_CONTENT_TYPE;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.malformedPathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LookupError) {
            LookupError other = (LookupError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MALFORMED_PATH: {
                    return this.malformedPathValue == other.malformedPathValue || this.malformedPathValue != null && this.malformedPathValue.equals(other.malformedPathValue);
                }
                case NOT_FOUND: {
                    return true;
                }
                case NOT_FILE: {
                    return true;
                }
                case NOT_FOLDER: {
                    return true;
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case UNSUPPORTED_CONTENT_TYPE: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<LookupError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(LookupError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MALFORMED_PATH: {
                    g.writeStartObject();
                    this.writeTag("malformed_path", g);
                    g.writeFieldName("malformed_path");
                    StoneSerializers.nullable(StoneSerializers.string()).serialize(value.malformedPathValue, g);
                    g.writeEndObject();
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case NOT_FILE: {
                    g.writeString("not_file");
                    break;
                }
                case NOT_FOLDER: {
                    g.writeString("not_folder");
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g.writeString("restricted_content");
                    break;
                }
                case UNSUPPORTED_CONTENT_TYPE: {
                    g.writeString("unsupported_content_type");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LookupError deserialize(JsonParser p) throws IOException, JsonParseException {
            LookupError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("malformed_path".equals(tag)) {
                String fieldValue = null;
                if (p.getCurrentToken() != JsonToken.END_OBJECT) {
                    Serializer.expectField("malformed_path", p);
                    fieldValue = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                }
                value = fieldValue == null ? LookupError.malformedPath() : LookupError.malformedPath(fieldValue);
            } else {
                value = "not_found".equals(tag) ? NOT_FOUND : ("not_file".equals(tag) ? NOT_FILE : ("not_folder".equals(tag) ? NOT_FOLDER : ("restricted_content".equals(tag) ? RESTRICTED_CONTENT : ("unsupported_content_type".equals(tag) ? UNSUPPORTED_CONTENT_TYPE : OTHER))));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MALFORMED_PATH,
        NOT_FOUND,
        NOT_FILE,
        NOT_FOLDER,
        RESTRICTED_CONTENT,
        UNSUPPORTED_CONTENT_TYPE,
        OTHER;

    }
}

