/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.jlocal;

import java.text.MessageFormat;
import java.util.StringTokenizer;

public abstract class Formatter {
    private static final String ESCAPE_CHAR = "|";
    private static final String SINGLE_QUOTE = "'";

    private Formatter() {
    }

    public static String format(String pattern, Object ... args) {
        return MessageFormat.format(Formatter.toMessageFormatPattern(pattern), args);
    }

    public static MessageFormat getMessageFormat(String simplifiedPattern) {
        return new MessageFormat(Formatter.toMessageFormatPattern(simplifiedPattern));
    }

    private static String toMessageFormatPattern(String simplifiedPattern) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(simplifiedPattern, "'|", true);
        boolean escapeMode = false;
        boolean firstInEscapeMode = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (escapeMode) {
                if (firstInEscapeMode) {
                    firstInEscapeMode = false;
                    if (ESCAPE_CHAR.equals(token)) {
                        builder.append(ESCAPE_CHAR);
                        continue;
                    }
                    builder.append(SINGLE_QUOTE);
                }
                if (SINGLE_QUOTE.equals(token)) {
                    throw new IllegalArgumentException("Single should not be escaped");
                }
                if (ESCAPE_CHAR.equals(token)) {
                    escapeMode = false;
                    builder.append(SINGLE_QUOTE);
                    continue;
                }
                builder.append(token);
                continue;
            }
            if (SINGLE_QUOTE.equals(token)) {
                builder.append(SINGLE_QUOTE);
                builder.append(SINGLE_QUOTE);
                continue;
            }
            if (ESCAPE_CHAR.equals(token)) {
                escapeMode = true;
                firstInEscapeMode = true;
                continue;
            }
            builder.append(token);
        }
        return builder.toString();
    }
}

