/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.dialog;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.dialog.DefaultScrollablePanel;
import com.fathzer.soft.ajlib.swing.framework.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;

public abstract class AbstractDialog<T, V>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private V result;
    private JButton cancelButton;
    private JButton okButton;
    protected T data;

    public AbstractDialog(Window owner, String title, T data) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.data = data;
        this.result = null;
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractDialog.this.cancel();
            }
        };
        String actionMapKey = "ESCAPE_KEY";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), actionMapKey);
        this.getRootPane().getActionMap().put(actionMapKey, escapeAction);
        this.setContentPane(this.createContentPane());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private Container createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout(5, 5));
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel southPane = new JPanel(new BorderLayout());
        southPane.setOpaque(false);
        JPanel buttonsPane = this.createButtonsPane();
        southPane.add((Component)buttonsPane, "East");
        JComponent extra = this.createExtraComponent();
        if (extra != null) {
            southPane.add((Component)extra, "West");
        }
        contentPane.add((Component)southPane, "South");
        JPanel centerPane = this.createCenterPane();
        if (centerPane != null) {
            JPanel component = centerPane instanceof Scrollable ? centerPane : new DefaultScrollablePanel(centerPane);
            JScrollPane scrollPane = new JScrollPane(component);
            scrollPane.setBorder(null);
            contentPane.add((Component)scrollPane, "Center");
        }
        this.updateOkButtonEnabled();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(AbstractDialog.this.okButton)) {
                    AbstractDialog.this.confirm();
                } else {
                    AbstractDialog.this.cancel();
                }
            }
        };
        this.getOkButton().addActionListener(listener);
        this.getCancelButton().addActionListener(listener);
        return contentPane;
    }

    protected JPanel createButtonsPane() {
        JPanel buttonsPane = new JPanel();
        buttonsPane.setOpaque(false);
        buttonsPane.add(this.getOkButton());
        buttonsPane.add(this.getCancelButton());
        this.getRootPane().setDefaultButton(this.okButton);
        return buttonsPane;
    }

    protected JComponent createExtraComponent() {
        return null;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(Application.getString("GenericButton.ok", this.getLocale()));
            this.okButton.setOpaque(false);
        }
        return this.okButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(Application.getString("GenericButton.cancel", this.getLocale()));
            this.cancelButton.setToolTipText(Application.getString("GenericButton.cancel.toolTip", this.getLocale()));
            this.cancelButton.setOpaque(false);
        }
        return this.cancelButton;
    }

    protected abstract JPanel createCenterPane();

    protected abstract V buildResult();

    protected void confirm() {
        this.result = this.buildResult();
        this.close();
    }

    protected void cancel() {
        this.result = null;
        this.close();
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    protected String getOkDisabledCause() {
        return null;
    }

    public V getResult() {
        return this.result;
    }

    public void updateOkButtonEnabled() {
        String cause = this.getOkDisabledCause();
        this.getOkButton().setEnabled(cause == null);
        this.getOkButton().setToolTipText(cause == null ? Application.getString("GenericButton.ok.toolTip", this.getLocale()) : cause);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = super.getPreferredSize();
        Rectangle availableSpace = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        preferred.height = Math.min(preferred.height, availableSpace.height);
        preferred.width = Math.min(preferred.width, availableSpace.width);
        return preferred;
    }

    @Deprecated
    public static Window getOwnerWindow(Component component) {
        return Utils.getOwnerWindow(component);
    }
}

