/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class RowSorter<M extends TableModel>
extends TableRowSorter<M> {
    private List<SortOrder> toggleSequence = Arrays.asList(SortOrder.values());

    public RowSorter() {
    }

    public RowSorter(M model) {
        super(model);
    }

    @Override
    public void toggleSortOrder(int column) {
        if (!this.isSortable(column)) {
            return;
        }
        List<RowSorter.SortKey> sortKeys = this.getSortKeys();
        ArrayList<RowSorter.SortKey> futureKeys = new ArrayList<RowSorter.SortKey>();
        RowSorter.SortKey theKey = null;
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (sortKey.getColumn() == column) {
                int index = this.toggleSequence.indexOf((Object)sortKey.getSortOrder());
                index = index < 0 || index == this.toggleSequence.size() - 1 ? 0 : ++index;
                theKey = new RowSorter.SortKey(column, this.toggleSequence.get(index));
                continue;
            }
            futureKeys.add(sortKey);
        }
        if (theKey == null) {
            theKey = new RowSorter.SortKey(column, this.toggleSequence.get(0));
        }
        if (!theKey.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
            futureKeys.add(0, theKey);
        } else {
            futureKeys.add(theKey);
        }
        super.setSortKeys(futureKeys);
    }

    public void setToggleSequence(List<SortOrder> sequence) {
        if (sequence == null) {
            this.toggleSequence = Arrays.asList(SortOrder.values());
        } else {
            if (sequence.isEmpty()) {
                throw new IllegalArgumentException("toggle sequence can't be empty");
            }
            this.toggleSequence = sequence;
        }
    }
}

