/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CharWidget
extends TextWidget {
    public static final String CHAR_PROPERTY = "char";
    private Character content;
    private Character defaultChar;

    public CharWidget() {
        super(1);
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String text = CharWidget.this.getText();
                if (text.length() == 0) {
                    CharWidget.this.setChar(CharWidget.this.defaultChar);
                } else if (text.length() > 1) {
                    CharWidget.this.setText(new String(new char[]{text.charAt(text.length() - 1)}));
                } else {
                    CharWidget.this.setChar(Character.valueOf(text.charAt(0)));
                }
                CharWidget.this.selectAll();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                CharWidget.this.selectAll();
            }
        });
    }

    public void setChar(Character character) {
        if (!NullUtils.areEquals(character, this.content)) {
            Character old = this.content;
            this.content = character;
            this.setText(this.content == null ? "" : new String(new char[]{this.content.charValue()}));
            this.firePropertyChange(CHAR_PROPERTY, old, this.content);
        }
    }

    public Character getChar() {
        return this.content;
    }

    public void setDefaultChar(char defaultChar) {
        this.defaultChar = Character.valueOf(defaultChar);
    }
}

