/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.worker;

import com.fathzer.soft.ajlib.swing.worker.DefaultWorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressPanel;
import com.fathzer.soft.ajlib.swing.worker.Worker;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public class WorkInProgressFrame
extends JDialog {
    public static final int DEFAULT_DELAY = 500;
    public static final int DEFAULT_MINIMUM_TIME_VISIBLE = 1000;
    private WorkInProgressPanel progressPanel;
    private long setVisibleTime;
    private int minimumVisibleTime = 1000;
    private int delay = 500;
    private Timer timer;
    private Worker<?, ?> worker;

    public WorkInProgressFrame(Window owner, String title, Dialog.ModalityType modality, Worker<?, ?> worker) {
        super(owner, title, modality);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (WorkInProgressFrame.this.getDefaultCloseOperation() != 0) {
                    Worker<?, ?> worker = WorkInProgressFrame.this.progressPanel.getWorker();
                    if (!worker.isFinished()) {
                        worker.cancel(false);
                    }
                    if (WorkInProgressFrame.this.getDefaultCloseOperation() == 2) {
                        WorkInProgressFrame.this.forceDispose();
                    }
                }
            }
        });
        this.worker = worker;
        this.buildContentPane();
        this.worker.addPropertyChangeListener(new AutoClosePropertyChangeListener());
        this.pack();
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        }
    }

    private void buildContentPane() {
        this.progressPanel = this.getWorkInProgressPanel();
        this.setContentPane(this.progressPanel);
    }

    public final WorkInProgressPanel getWorkInProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = this.buildProgressPanel();
            this.progressPanel.setSwingWorker(this.worker);
        }
        return this.progressPanel;
    }

    protected WorkInProgressPanel buildProgressPanel() {
        return new DefaultWorkInProgressPanel();
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setMinimumVisibleTime(int time) {
        this.minimumVisibleTime = time;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.execute();
        }
    }

    @Override
    public void dispose() {
        long remaining;
        long l = remaining = this.worker.isCancelled() ? 0L : (long)this.minimumVisibleTime - (System.currentTimeMillis() - this.setVisibleTime);
        if (remaining > 0L) {
            Timer disposeTimer = new Timer((int)remaining, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkInProgressFrame.this.forceDispose();
                }
            });
            disposeTimer.setRepeats(false);
            disposeTimer.start();
        } else {
            this.forceDispose();
        }
    }

    private void forceDispose() {
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (!this.worker.getState().equals((Object)SwingWorker.StateValue.PENDING)) {
            return;
        }
        this.worker.execute();
        if (!this.isVisible()) {
            if (this.delay > 0) {
                if (Dialog.ModalityType.MODELESS.equals((Object)this.getModalityType())) {
                    this.timer = new Timer(this.delay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WorkInProgressFrame.this.showIt();
                        }
                    });
                    this.timer.setRepeats(false);
                    this.timer.start();
                } else {
                    try {
                        Worker<?, ?> worker = this.worker;
                        synchronized (worker) {
                            this.worker.wait(this.delay);
                        }
                        this.showIt();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                this.showIt();
            }
        }
    }

    private synchronized void showIt() {
        this.setVisibleTime = System.currentTimeMillis();
        if (!this.isVisible() && !this.worker.isFinished()) {
            super.setVisible(true);
        }
    }

    protected Worker<?, ?> getWorker() {
        return this.worker;
    }

    private final class AutoClosePropertyChangeListener
    implements PropertyChangeListener {
        private AutoClosePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
                WorkInProgressFrame.this.dispose();
            }
        }
    }
}

