/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.worker;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import javax.swing.SwingWorker;

public abstract class Worker<T, V>
extends SwingWorker<T, V> {
    public static final String STATE_PROPERTY_NAME = "state";
    public static final String PROGRESS_PROPERTY_NAME = "progress";
    public static final String JOB_PHASE = "phase";
    public static final String PHASE_LENGTH = "length";
    private String phase = null;
    private int phaseLength = -1;
    private boolean isFinished = false;

    protected void setPhase(String phase, int phaseLength) {
        if (!NullUtils.areEquals(this.phase, phase)) {
            String old = this.phase;
            this.phase = phase;
            this.firePropertyChange(JOB_PHASE, old, phase);
        }
        this.setPhaseLength(phaseLength);
    }

    protected void setPhaseLength(int phaseLength) {
        if (phaseLength != this.phaseLength) {
            int old = this.phaseLength;
            this.phaseLength = phaseLength;
            this.firePropertyChange(PHASE_LENGTH, old, this.phase);
        }
    }

    public String getPhase() {
        return this.phase;
    }

    public int getPhaseLength() {
        return this.phaseLength;
    }

    public void reportProgress(int progress) {
        if (this.phaseLength < 0 || progress > this.phaseLength) {
            throw new IllegalArgumentException();
        }
        long percent = this.phaseLength == 0 ? 100L : (long)(progress * 100 / this.phaseLength);
        super.setProgress((int)percent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final T doInBackground() throws Exception {
        T result = this.doProcessing();
        Worker worker = this;
        synchronized (worker) {
            this.isFinished = true;
            this.notifyAll();
        }
        return result;
    }

    protected abstract T doProcessing() throws Exception;

    public boolean isFinished() {
        return this.isFinished;
    }
}

