/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class LocalizationData {
    public static final String DEFAULT_BUNDLE_NAME = "com.fathzer.soft.ajlib.Resources";
    public static LocalizationData DEFAULT = new LocalizationData("com.fathzer.soft.ajlib.Resources");
    private Map<Locale, List<ResourceBundle>> bundles;
    private List<String> bundleNames = new ArrayList<String>();
    private boolean translatorMode;

    public static Locale getSystemLocale() {
        try {
            return new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
        }
        catch (SecurityException e) {
            return Locale.getDefault();
        }
    }

    public LocalizationData(String bundlePath) {
        this.bundleNames.add(bundlePath);
        this.bundles = new HashMap<Locale, List<ResourceBundle>>();
        this.translatorMode = false;
    }

    public void add(String bundlePath) {
        for (Locale locale : this.bundles.keySet()) {
            List<ResourceBundle> bundles = this.bundles.get(locale);
            bundles.add(ResourceBundle.getBundle(bundlePath, locale));
        }
        this.bundleNames.add(bundlePath);
    }

    public String getString(String key, Locale locale) {
        if (this.translatorMode) {
            return key;
        }
        List<ResourceBundle> bundle = this.getBundle(locale);
        for (int i = bundle.size() - 1; i > 0; --i) {
            if (!bundle.get(i).containsKey(key)) continue;
            return bundle.get(i).getString(key);
        }
        return bundle.get(0).getString(key);
    }

    public String getString(String key) {
        return this.getString(key, Locale.getDefault());
    }

    private List<ResourceBundle> getBundle(Locale locale) {
        List<ResourceBundle> result = this.bundles.get(locale);
        if (result == null) {
            result = new ArrayList<ResourceBundle>();
            for (String bundleName : this.bundleNames) {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
                result.add(bundle);
            }
            this.bundles.put(locale, result);
        }
        return result;
    }

    public void setTranslatorMode(boolean translatorMode) {
        this.translatorMode = translatorMode;
    }
}

