/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.Entry;
import com.fathzer.soft.jclop.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Account {
    private static final Logger LOGGER = LoggerFactory.getLogger(Account.class);
    private static final String INFO_FILENAME = ".info";
    private File root;
    Service service;
    private String displayName;
    private String id;
    private boolean serialized;
    protected Serializable connectionData;
    protected long quota;
    protected long used;

    Account(Service service, File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.root = file;
        this.id = URLDecoder.decode(file.getName(), "UTF-8");
        ObjectInputStream stream = new ObjectInputStream(new FileInputStream(new File(this.root, INFO_FILENAME)));
        try {
            this.displayName = (String)stream.readObject();
            this.connectionData = (Serializable)stream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            stream.close();
        }
        this.service = service;
        this.quota = -1L;
        this.used = -1L;
        this.serialized = true;
    }

    public Account(Service service, String id, String displayName, Serializable connectionData) {
        this.service = service;
        this.id = id;
        this.displayName = displayName;
        this.connectionData = connectionData;
        this.quota = -1L;
        this.used = -1L;
        this.serialized = false;
        try {
            this.root = new File(service.getCacheRoot(), URLEncoder.encode(id, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void serialize() {
        this.serialized = false;
        if (this.root.isFile()) {
            this.root.delete();
        }
        this.root.mkdirs();
        if (!this.root.isDirectory()) {
            return;
        }
        File connectionDataFile = new File(this.root, INFO_FILENAME);
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(connectionDataFile));
            try {
                stream.writeObject(this.displayName);
                stream.writeObject(this.connectionData);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to serialize account " + this.displayName, e);
            return;
        }
        this.serialized = true;
    }

    public synchronized boolean isSerialized() {
        return this.serialized;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Service getService() {
        return this.service;
    }

    public Serializable getConnectionData() {
        return this.connectionData;
    }

    public long getQuota() {
        return this.quota;
    }

    public void setQuota(long quota) {
        this.quota = quota;
    }

    public long getUsed() {
        return this.used;
    }

    public void setUsed(long used) {
        this.used = used;
    }

    public Collection<Entry> getLocalEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        File[] files = this.root.listFiles();
        if (files != null) {
            for (File file : files) {
                Entry entry;
                if (!file.isDirectory() || (entry = this.service.getLocalEntry(this, file)) == null) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Account)) {
            return super.equals(obj);
        }
        return this.getId().equals(((Account)obj).getId());
    }

    File getRoot() {
        return this.root;
    }

    public void setDisplayName(String displayName) {
        if (!NullUtils.areEquals(displayName, this.displayName)) {
            this.displayName = displayName;
            this.serialize();
        }
    }

    public void setConnectionData(Serializable connectionData) {
        if (!NullUtils.areEquals(connectionData, this.connectionData)) {
            this.connectionData = connectionData;
            this.serialize();
        }
    }
}

