/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop;

import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.jclop.Account;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Entry;
import com.fathzer.soft.jclop.InvalidConnectionDataException;
import com.fathzer.soft.jclop.JClopException;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.UnreachableHostException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemService
extends Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemService.class);
    public static final FileSystemService INSTANCE;

    protected FileSystemService() throws IOException {
        super(null, true);
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public File getLocalFile(URI uri) {
        File file = new File(uri);
        try {
            return FileUtils.getCanonical(file);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to find canonical file for " + uri, e);
            return file;
        }
    }

    @Override
    public String getDisplayable(URI uri) {
        return uri.getPath();
    }

    @Override
    public Collection<Entry> getRemoteEntries(Account account, Cancellable task) throws UnreachableHostException, InvalidConnectionDataException {
        return Collections.emptyList();
    }

    @Override
    public String getConnectionDataURIFragment(Serializable connectionData) {
        return null;
    }

    @Override
    public Serializable getConnectionData(String uriFragment) {
        return null;
    }

    @Override
    public String getRemoteRevision(URI uri) throws JClopException {
        return this.getLocalRevision(uri);
    }

    @Override
    public boolean download(URI uri, OutputStream out, Cancellable task, Locale locale) throws IOException {
        return true;
    }

    @Override
    public boolean upload(InputStream in, long length, URI uri, Cancellable task, Locale locale) throws IOException {
        return true;
    }

    @Override
    public Entry getEntry(URI uri) {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException();
        }
        return new Entry(null, uri.getPath());
    }

    static {
        FileSystemService instance = null;
        try {
            instance = new FileSystemService();
        }
        catch (IOException e) {
            LOGGER.error("Unexpected exception", e);
        }
        INSTANCE = instance;
    }
}

