/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.dropbox.swing;

import com.dropbox.core.DbxAuthFinish;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.jclop.Account;
import com.fathzer.soft.jclop.JClopException;
import com.fathzer.soft.jclop.dropbox.DropboxService;
import com.fathzer.soft.jclop.dropbox.swing.ConnectionDialog;
import com.fathzer.soft.jclop.dropbox.swing.MessagePack;
import com.fathzer.soft.jclop.swing.AbstractURIChooserPanel;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public class DropboxURIChooser
extends AbstractURIChooserPanel {
    private static final String TITLE = "dropbox".substring(0, 1).toUpperCase() + "dropbox".substring(1);

    public DropboxURIChooser(DropboxService service) {
        super(service);
    }

    @Override
    protected Account createNewAccount() {
        Window owner = Utils.getOwnerWindow(this);
        ConnectionDialog connectionDialog = new ConnectionDialog(owner, ((DropboxService)this.getService()).getConnectionData(), this.getLocale());
        connectionDialog.setVisible(true);
        DbxAuthFinish finish = (DbxAuthFinish)connectionDialog.getResult();
        if (finish == null) {
            return null;
        }
        String id = finish.getUserId();
        Account account = this.getService().getAccount(id);
        if (account == null) {
            account = this.getService().newAccount(id, null, (Serializable)((Object)finish.getAccessToken()));
            try {
                ((DropboxService)this.getService()).setDisplayName(account);
            }
            catch (JClopException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Unable to get account name from Dropbox", e);
            }
        } else {
            account.setConnectionData((Serializable)((Object)finish.getAccessToken()));
        }
        return account;
    }

    @Override
    public String getTooltip(boolean save) {
        return save ? MessagePack.getString("com.fathzer.soft.jclop.dropbox.save.tabTooltip", this.getLocale()) : MessagePack.getString("com.fathzer.soft.jclop.dropbox.read.tabTooltip", this.getLocale());
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(DropboxURIChooser.class.getResource("dropbox.png"));
    }

    @Override
    public String getTitle() {
        return TITLE;
    }
}

