/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.currency.CurrencyData;
import net.yapbam.currency.CurrencyHandler;
import net.yapbam.remote.Cache;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractXMLCurrencyConverter
extends AbstractCurrencyConverter {
    protected AbstractXMLCurrencyConverter(Proxy proxy, Cache cache) {
        super(proxy, cache);
    }

    @Override
    protected CurrencyData parse(Cache cache, boolean tmp) throws ParseException, IOException {
        if (!tmp && cache.isEmpty()) {
            return new CurrencyData();
        }
        return this.parseXML(cache, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CurrencyData parseXML(Cache cache, boolean tmp) throws ParseException, IOException {
        CurrencyHandler handler = this.getXMLHandler();
        try {
            XMLReader saxReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            saxReader.setContentHandler(handler);
            saxReader.setErrorHandler(handler);
            InputStream input = cache.getInputStream(tmp);
            try {
                saxReader.parse(new InputSource(input));
            }
            finally {
                input.close();
            }
        }
        catch (SAXException e) {
            ParseException x = new ParseException(e.toString(), 0);
            x.initCause(e);
            throw x;
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e.toString(), 0);
        }
        return handler.getData();
    }

    protected abstract CurrencyHandler getXMLHandler();
}

